/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.state.elements.finalstate;

import com.modeliosoft.modelio.diagram.elements.core.figures.EllipseShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.IShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.ShapedFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.ShapedBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class FinalStateFigure
extends ShapedFigure {
    private ShapedBorder shapedBorder;
    private static final int MARGIN = 4;

    public FinalStateFigure() {
        super((IShaper)new EllipseShaper());
        this.setSize(20, 20);
        this.setOpaque(true);
        this.shapedBorder = new ShapedBorder(this.penOptions.lineColor, this.penOptions.lineWidth, this.shaper);
        this.setBorder((Border)this.shapedBorder);
    }

    public void setLineColor(Color lineColor) {
        if (this.penOptions.lineColor != lineColor) {
            this.shapedBorder.setColor(lineColor);
            super.setLineColor(lineColor);
            super.setFillColor(lineColor);
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.penOptions.lineWidth != lineWidth) {
            this.shapedBorder.setWidth(lineWidth);
            super.setLineWidth(lineWidth);
        }
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle innerRect = this.getBounds().getCopy().shrink(4, 4);
        graphics.setClip(this.shaper.getShapePath(innerRect));
        Color fillColor = this.getFillColor();
        if (this.isOpaque() && fillColor != null) {
            Color base = fillColor;
            if (this.brushOptions.useGradient) {
                Color gradientColor = this.computeGradientColor(base);
                graphics.setBackgroundColor(gradientColor);
                graphics.setForegroundColor(base);
                graphics.fillGradient(innerRect, false);
                gradientColor.dispose();
            } else {
                graphics.setBackgroundColor(base);
                graphics.fillRectangle(innerRect);
            }
        }
        graphics.restoreState();
    }

    public Color getFillColor() {
        return super.getLineColor();
    }

    public void setFillColor(Color fillColor) {
        this.setLineColor(fillColor);
    }
}

