/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.state.elements.internaltransition;

import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEvent;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IInternalTransition;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.state.elements.internaltransition.GmInternalTransitionStructuredStyleKeys;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.label.modelelement.GmModelElementFlatHeader;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.List;

public class GmInternalTransition
extends GmModelElementFlatHeader {
    private static GmInternalTransitionStructuredStyleKeys STRUCTKEYS = new GmInternalTransitionStructuredStyleKeys();
    private IInternalTransition element = null;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmInternalTransition(GmAbstractDiagram diagram, IInternalTransition theInternalTransition, ObRef ref) {
        super(diagram, ref);
        this.element = theInternalTransition;
    }

    public GmInternalTransition() {
    }

    public List<IStereotype> filterStereotypes(List<IStereotype> stereotypes) {
        return stereotypes;
    }

    public List<ITaggedValue> filterTags(List<ITaggedValue> taggedValues) {
        return taggedValues;
    }

    public IEditableText getEditableText() {
        return null;
    }

    public IModelElement getRelatedIElement() {
        return this.getRepresentedIElement();
    }

    public IModelElement getRepresentedIElement() {
        return this.element;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        return STRUCTKEYS.getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        return STRUCTKEYS.getStyleKeys();
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmInternalTransition.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    protected String computeLabel() {
        String elementLabel;
        IInternalTransition theTransition = (IInternalTransition)this.getRelatedIElement();
        StringBuilder symbol = new StringBuilder();
        IStateVertex targetVertex = theTransition.getTarget();
        boolean withEvent = true;
        IEvent trigger = theTransition.getTrigger();
        if (trigger != null) {
            symbol.append(trigger.getName());
        } else {
            symbol.append(theTransition.getReceivedEvents());
        }
        String condition = theTransition.getGuard();
        if (condition != null && !condition.equals("")) {
            symbol.append("[");
            symbol.append(condition);
            symbol.append("]");
        }
        String sEffect = theTransition.getEffect();
        IOperation op = theTransition.getProcessed();
        IBehavior b = theTransition.getBehaviorEffect();
        if (sEffect != null && !sEffect.isEmpty()) {
            symbol.append("/");
            symbol.append(sEffect);
        } else if (op != null) {
            symbol.append("/");
            symbol.append(op.getName());
            symbol.append("()");
        } else if (b != null) {
            symbol.append("/");
            symbol.append(b.getName());
        }
        ISignal effects = theTransition.getEffects();
        if (effects != null) {
            symbol.append("^");
            symbol.append(effects.getName());
            symbol.append("()");
        } else {
            String sentEvents = theTransition.getSentEvents();
            if (sentEvents.length() > 0) {
                symbol.append("^");
                symbol.append(sentEvents);
            }
        }
        String postCondition = theTransition.getPostCondition();
        if (postCondition != null && !postCondition.equals("")) {
            symbol.append("{");
            symbol.append(postCondition);
            symbol.append("}");
        }
        if (symbol.length() == 0) {
            symbol.append(theTransition.getName());
            if (targetVertex != null) {
                symbol.append("::");
                symbol.append(targetVertex.getName());
            }
        }
        if ((elementLabel = symbol.toString()).equals("")) {
            elementLabel = "/";
        }
        return elementLabel;
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmInternalTransition.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.element = (IInternalTransition)this.resolveRef(this.getRepresentedRef());
    }

    public int getMajorVersion() {
        return 0;
    }
}

