/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.state.elements.statediagram;

import com.modeliosoft.modelio.api.model.uml.behavior.state.IConnectionPointReference;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEntryPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IExitPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

class CreateCallBehaviorCommand
extends Command {
    private EditPart editPart;
    private IStateMachine stateMachine;
    private Point dropLocation;
    private IStateMachine parentElement;

    public CreateCallBehaviorCommand(Point dropLocation, IStateMachine toUnmask, EditPart editPart, IStateMachine parentElement) {
        this.stateMachine = toUnmask;
        this.dropLocation = dropLocation;
        this.editPart = editPart;
        this.parentElement = parentElement;
    }

    public void execute() {
        IConnectionPointReference reference;
        GmModel gmModel = (GmModel)this.editPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IState el = factory.createState();
        el.setParent(this.parentElement.getTop());
        el.setName(this.stateMachine.getName());
        el.setSubMachine(this.stateMachine);
        for (IEntryPointPseudoState entry : this.stateMachine.getEntryPoint()) {
            reference = factory.createConnectionPointReference();
            reference.setName(entry.getName());
            reference.setEntry(entry);
            reference.setOwnerState(el);
        }
        for (IExitPointPseudoState exit : this.stateMachine.getExitPoint()) {
            reference = factory.createConnectionPointReference();
            reference.setName(exit.getName());
            reference.setExit(exit);
            reference.setOwnerState(el);
        }
        this.unmaskElement((IElement)el);
    }

    private void unmaskElement(IElement el) {
        ModelioCreationContext gmCreationContext = new ModelioCreationContext(el);
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(this.dropLocation);
        creationRequest.setSize(new Dimension(-1, -1));
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        Command cmd = this.editPart.getTargetEditPart((Request)creationRequest).getCommand((Request)creationRequest);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }

    public boolean canExecute() {
        return this.parentElement != null && this.parentElement.isValid() && this.parentElement.getElementStatus().isModifiable();
    }
}

