/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.state.elements.transition;

import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEvent;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.model.uml.behavior.state.ITransition;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.state.elements.transition.GmTransitionStyleKeys;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.label.modelelement.GmDefaultFlatHeader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;

public class GmTransitionMainLabel
extends GmDefaultFlatHeader {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmTransitionMainLabel(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    protected String computeLabel() {
        ITransition theTransition = (ITransition)this.getRelatedIElement();
        if (theTransition == null) {
            return "";
        }
        StringBuilder symbol = new StringBuilder();
        boolean withEvent = true;
        IEvent trigger = theTransition.getTrigger();
        if (trigger != null) {
            symbol.append(trigger.getName());
        } else {
            symbol.append(theTransition.getReceivedEvents());
        }
        String sEffect = theTransition.getEffect();
        IOperation op = theTransition.getProcessed();
        IBehavior behavior = theTransition.getBehaviorEffect();
        if (sEffect != null && !sEffect.isEmpty()) {
            symbol.append("/");
            symbol.append(sEffect);
        } else if (op != null) {
            symbol.append("/");
            symbol.append(op.getName());
            symbol.append("()");
        } else if (behavior != null) {
            symbol.append("/");
            symbol.append(behavior.getName());
        }
        ISignal effects = theTransition.getEffects();
        if (effects != null) {
            symbol.append("^");
            symbol.append(effects.getName());
            symbol.append("()");
        } else {
            String sentEvents = theTransition.getSentEvents();
            if (sentEvents.length() > 0) {
                symbol.append("^");
                symbol.append(sentEvents);
            }
        }
        if (symbol.length() == 0) {
            symbol.append(theTransition.getName());
            IStateVertex targetVertex = theTransition.getTarget();
            if (targetVertex != null) {
                symbol.append("::");
                symbol.append(targetVertex.getName());
            }
        }
        return symbol.toString();
    }

    public GmTransitionMainLabel() {
    }

    public boolean isVisible() {
        return (Boolean)this.getStyle().getProperty(GmTransitionStyleKeys.SHOWLABEL);
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmTransitionMainLabel.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmTransitionMainLabel.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

