/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.mdac;

import com.modeliosoft.modelio.api.mdac.DefaultMdacSession;
import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IMdacSession;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.modelio.Version;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.handlers.IHandlerActivation;

public class DefaultMdacSession
implements IMdacSession {
    protected final IMdac mdac;
    private final Map<String, IHandlerActivation> handlerActivationTable = new HashMap();
    private PerspectiveAdapter perspectiveListener;

    public DefaultMdacSession(IMdac module) {
        this.mdac = module;
    }

    public static boolean install(String modelioPath, String installPath) throws MdacException {
        return true;
    }

    public boolean select() throws MdacException {
        return true;
    }

    public boolean start() throws MdacException {
        this.addWorkbenchActions();
        this.addDiagramTools();
        this.addDiagramCustomizers();
        this.showModulePropertyViews();
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    public void stop() throws MdacException {
        this.hideMdacPropertyViews();
        this.removeDiagramCustomizers();
        this.removeDiagramTools();
        this.removeWorkbenchActions();
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void unselect() throws MdacException {
    }

    public void upgrade(Version oldVersion, Map<String, String> oldParameters) throws MdacException {
        this.mdac.getConfiguration().updateFrom(oldParameters);
    }

    private void showModulePropertyViews() {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void hideMdacPropertyViews() {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addWorkbenchActions() {
        Display.getDefault().syncExec((Runnable)new ContextualPopupActionsAdder(this.mdac, this.handlerActivationTable));
    }

    private void removeWorkbenchActions() {
        Display.getDefault().syncExec((Runnable)new ContextualPopupActionsRemover(this.mdac, this.handlerActivationTable));
    }

    private void addDiagramCustomizers() {
        if (this.mdac.getDiagramCustomizations().size() > 0) {
            Display.getDefault().syncExec((Runnable)new DiagramCustomizerAdder(this.mdac));
        }
    }

    private void removeDiagramCustomizers() {
        if (this.mdac.getDiagramCustomizations().size() > 0) {
            Display.getDefault().syncExec((Runnable)new DiagramCustomizerRemover(this.mdac));
        }
    }

    private void addDiagramTools() {
        if (this.mdac.getDiagramTools().size() > 0) {
            Display.getDefault().syncExec((Runnable)new DiagramToolsAdder(this.mdac));
        }
    }

    private void removeDiagramTools() {
        if (this.mdac.getDiagramTools().size() > 0) {
            Display.getDefault().syncExec((Runnable)new DiagramToolsRemover(this.mdac));
        }
    }

    static /* synthetic */ void access$0(DefaultMdacSession defaultMdacSession) {
        defaultMdacSession.showModulePropertyViews();
    }

    static /* synthetic */ void access$1(DefaultMdacSession defaultMdacSession) {
        defaultMdacSession.hideMdacPropertyViews();
    }

    static /* synthetic */ void access$2(DefaultMdacSession defaultMdacSession, PerspectiveAdapter perspectiveAdapter) {
        defaultMdacSession.perspectiveListener = perspectiveAdapter;
    }

    static /* synthetic */ PerspectiveAdapter access$3(DefaultMdacSession defaultMdacSession) {
        return defaultMdacSession.perspectiveListener;
    }
}

