/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.mdac.commands;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.mdac.commands.IMdacContextualCommand;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class DefaultMdacAction
implements IMdacAction {
    private String bitmapPath;
    private boolean editTheModel;
    private String label;
    private String name;
    private boolean needReadWriteObject;
    private String tooltip;
    private List<Class<? extends IElement>> allowedMetaclasses = new ArrayList();
    private IMdacContextualCommand command;
    private IMdac mdac;
    private List<IStereotype> allowedStereotypes = new ArrayList();
    private List<String> slotImagePaths = new ArrayList();
    private List<String> slots = new ArrayList();

    public DefaultMdacAction(IMdac mdac, String name, String label, String tooltip, String bitmapPath, boolean needReadWriteObject, boolean editTheModel, IMdacContextualCommand command) {
        this(mdac, name, label, tooltip, bitmapPath, "", "", needReadWriteObject, editTheModel, command);
    }

    public DefaultMdacAction(IMdac mdac, String name, String label, String tooltip, String bitmapPath, String slotPattern, String slotImagePaths, boolean needReadWriteObject, boolean editTheModel, IMdacContextualCommand command) {
        this.mdac = mdac;
        this.name = name;
        this.label = label;
        this.tooltip = tooltip;
        this.bitmapPath = bitmapPath;
        if (!slotPattern.isEmpty()) {
            String[] stringArray = slotPattern.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String slot = stringArray[n2];
                this.slots.add(slot);
                ++n2;
            }
            stringArray = slotImagePaths.split("\\|");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String slotImagePath = stringArray[n2];
                this.slotImagePaths.add(slotImagePath);
                ++n2;
            }
        }
        this.needReadWriteObject = needReadWriteObject;
        this.editTheModel = editTheModel;
        this.command = command;
        this.allowedMetaclasses = new ArrayList();
    }

    @Deprecated
    public DefaultMdacAction(IMdac mdac, int id, String name, String label, String tooltip, String bitmapPath, String slotName, String hint, boolean needReadWriteObject, boolean editTheModel, IMdacContextualCommand command) {
        this(mdac, name, label, tooltip, bitmapPath, slotName, "", needReadWriteObject, editTheModel, command);
    }

    public final boolean accept(IElement[] selectedElements) {
        int i = 0;
        while (i < selectedElements.length) {
            boolean matchStereotype = false;
            boolean matchMetaClass = false;
            for (Class metaclass : this.allowedMetaclasses) {
                if (!metaclass.isAssignableFrom(selectedElements[i].getClass())) continue;
                matchMetaClass = true;
                break;
            }
            if (this.allowedStereotypes.size() > 0) {
                for (IStereotype stereotype : this.allowedStereotypes) {
                    IModelElement modelElement;
                    IElement element = selectedElements[i];
                    if (!(element instanceof IModelElement) || !(modelElement = (IModelElement)element).isStereotyped(stereotype.getName())) continue;
                    matchStereotype = true;
                    break;
                }
            } else {
                matchStereotype = true;
            }
            if (!matchMetaClass || !matchStereotype) {
                return false;
            }
            ++i;
        }
        return this.command.accept(new ObList(selectedElements), this.mdac);
    }

    public void addAllowedMetaclass(Class<? extends IElement> eltName) {
        this.allowedMetaclasses.add(eltName);
    }

    public void addAllowedStereotype(IStereotype stereotype) {
        this.allowedStereotypes.add(stereotype);
    }

    public ImageDescriptor getBitmap() {
        File candidateFile = new File(this.getImagePath());
        if (!(candidateFile.exists() && candidateFile.isFile() && candidateFile.isAbsolute())) {
            File moduleDirectory = this.mdac.getConfiguration().getModuleResourcesPath();
            candidateFile = new File(moduleDirectory, this.getImagePath());
        }
        if (candidateFile.exists() && candidateFile.isFile()) {
            try {
                return ImageDescriptor.createFromURL((URL)candidateFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                Modelio.getInstance().getLogService().error(this.mdac, (Throwable)e);
            }
        }
        return null;
    }

    public IMdacContextualCommand getCommand() {
        return this.command;
    }

    @Deprecated
    public String getImagePath() {
        return this.bitmapPath;
    }

    public String getLabel() {
        return this.label;
    }

    public IMdac getMdac() {
        return this.mdac;
    }

    public String getName() {
        return this.name;
    }

    public ImageDescriptor getSlotImage(int slotIndex) {
        if (slotIndex < this.slotImagePaths.size()) {
            String slotImagePath = (String)this.slotImagePaths.get(slotIndex);
            File candidateFile = new File(slotImagePath);
            if (!(candidateFile.exists() && candidateFile.isFile() && candidateFile.isAbsolute())) {
                File moduleDirectory = this.mdac.getConfiguration().getModuleResourcesPath();
                candidateFile = new File(moduleDirectory, slotImagePath);
            }
            if (candidateFile.exists() && candidateFile.isFile()) {
                try {
                    return ImageDescriptor.createFromURL((URL)candidateFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    Modelio.getInstance().getLogService().error(this.mdac, (Throwable)e);
                }
            }
        }
        return null;
    }

    public List<String> getSlots() {
        return this.slots;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public final boolean isActiveFor(IElement[] selectedElements, boolean readOnlyTool) {
        if (this.editTheModel && readOnlyTool) {
            return false;
        }
        if (this.needReadWriteObject) {
            IElement[] iElementArray = selectedElements;
            int n = selectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                IElement element = iElementArray[n2];
                if (!element.getElementStatus().isModifiable()) {
                    return false;
                }
                ++n2;
            }
        }
        return this.command.isActiveFor(new ObList(selectedElements), this.mdac);
    }

    public boolean needReadWriteObject() {
        return this.needReadWriteObject;
    }
}

