/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.mdac.propertiesPage;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyPage;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyTable;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class AbstractMdacPropertyPage
implements IMdacPropertyPage {
    protected IMdac mdac;
    private String name = null;
    private String label = null;
    private ImageDescriptor bitmap = null;

    public ImageDescriptor getBitmap() {
        return this.bitmap;
    }

    public final IMdac getMdac() {
        return this.mdac;
    }

    public AbstractMdacPropertyPage(IMdac mdac, String name, String label, String bitmap) {
        this.mdac = mdac;
        this.name = name;
        this.label = label;
        File tmpFile = null;
        File bitmapFile = new File(bitmap);
        if (bitmapFile.exists() && bitmapFile.isFile() && bitmapFile.isAbsolute()) {
            tmpFile = new File(bitmap);
        } else {
            File mdacDirectory = mdac.getConfiguration().getModuleResourcesPath();
            tmpFile = new File(mdacDirectory, bitmap);
        }
        if (tmpFile.isFile()) {
            try {
                this.bitmap = ImageDescriptor.createFromURL((URL)tmpFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.bitmap = null;
                Modelio.getInstance().getLogService().error(this.mdac, (Throwable)e);
            }
        } else {
            this.bitmap = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void update(ObList<IElement> elements, IMdacPropertyTable table) {
    }

    public void changeProperty(ObList<IElement> elements, int row, String value) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBitmap(ImageDescriptor image) {
        this.bitmap = image;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMdac(IMdac mdac) {
        this.mdac = mdac;
    }
}

