/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.model;

import com.modeliosoft.modelio.api.Messages;
import com.modeliosoft.modelio.api.model.InvalidPathException;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.utils.IObListFilter;
import com.modeliosoft.modelio.api.utils.NameFilter;
import com.modeliosoft.modelio.api.utils.ObList;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class UMLPath {
    private List<INameSpace> hierarchy = new ArrayList();
    private boolean valid = false;

    public UMLPath(INameSpace rootNamespace, String path) {
        this(rootNamespace, path, ".");
    }

    public UMLPath(INameSpace rootNamespace, String path, String delim) {
        this.valid = false;
        INameSpace currentNamespace = rootNamespace;
        StringTokenizer tokenizer = new StringTokenizer(path, delim);
        while (tokenizer.hasMoreTokens()) {
            String nextNamespace = tokenizer.nextToken();
            NameFilter nameFilter = new NameFilter(nextNamespace);
            ObList namespaces = currentNamespace.getOwnedElement().select((IObListFilter)nameFilter);
            if (namespaces.size() != 1) {
                this.hierarchy.clear();
                return;
            }
            if (namespaces.get(0) instanceof INameSpace) {
                this.hierarchy.add((INameSpace)namespaces.get(0));
            }
            currentNamespace = (INameSpace)this.hierarchy.get(this.hierarchy.size() - 1);
        }
        this.valid = true;
    }

    public UMLPath(INameSpace element) {
        this.valid = true;
        this.hierarchy.add(element);
        IElement owner = element.getCompositionOwner();
        while (owner != null) {
            if (owner.getCompositionOwner() == null) break;
            if (!(owner instanceof INameSpace)) {
                this.valid = false;
                this.hierarchy.clear();
                return;
            }
            this.hierarchy.add(0, (INameSpace)owner);
            owner = owner.getCompositionOwner();
        }
    }

    public List<INameSpace> getHierarchy() throws InvalidPathException {
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage((String)"keyUmlPath.Invalid", (String[])new String[0]));
        }
        return this.hierarchy;
    }

    public INameSpace getLastElement() throws InvalidPathException, IllegalArgumentException {
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage((String)"keyUmlPath.Invalid", (String[])new String[0]));
        }
        if (this.hierarchy.size() == 0) {
            throw new IllegalArgumentException(Messages.getMessage((String)"keyUmlPath.Empty", (String[])new String[0]));
        }
        return (INameSpace)this.hierarchy.get(this.hierarchy.size() - 1);
    }

    public UMLPath getParentPath() throws InvalidPathException, IllegalArgumentException {
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage((String)"keyUmlPath.Invalid", (String[])new String[0]));
        }
        if (this.hierarchy.size() == 0) {
            throw new IllegalArgumentException("the parent path cannot be determined from an empty hierarchy");
        }
        ArrayList newList = new ArrayList(this.hierarchy);
        newList.remove(newList.size() - 1);
        return new UMLPath(newList);
    }

    public String getPath(String separator) throws InvalidPathException {
        String path = "";
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage((String)"keyUmlPath.Invalid", (String[])new String[0]));
        }
        int i = 0;
        while (i < this.hierarchy.size()) {
            if (i != 0) {
                path = path.concat(separator);
            }
            path = path.concat(((INameSpace)this.hierarchy.get(i)).getName());
            ++i;
        }
        return path;
    }

    public boolean isValid() {
        return this.valid;
    }

    private UMLPath(List<INameSpace> existingHierarchy) {
        this.hierarchy = existingHierarchy;
        this.valid = true;
    }
}

