/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.modelio;

public class Version {
    private int buildVersion;
    private int majorVersion;
    private int metamodelVersion;
    private int minorVersion;

    public Version(int major, int minor, int build, int mmVersion) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.buildVersion = build;
        this.metamodelVersion = mmVersion;
    }

    public Version(String versionString) throws NumberFormatException {
        String[] versionNumbers = versionString.split("\\.", 4);
        this.majorVersion = versionNumbers.length > 0 && versionNumbers[0].length() != 0 ? Integer.parseInt(versionNumbers[0]) : 0;
        this.minorVersion = versionNumbers.length > 1 && versionNumbers[1].length() != 0 ? Integer.parseInt(versionNumbers[1]) : 0;
        this.buildVersion = versionNumbers.length > 2 && versionNumbers[2].length() != 0 ? this.parseRevision(versionNumbers[2]) : 0;
        this.metamodelVersion = versionNumbers.length > 3 && versionNumbers[3].length() != 0 ? Integer.parseInt(versionNumbers[3]) : 0;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Version) {
            Version other = (Version)anObject;
            return this.majorVersion == other.majorVersion && this.minorVersion == other.minorVersion && this.buildVersion == other.buildVersion && this.metamodelVersion == other.metamodelVersion;
        }
        return false;
    }

    public int getBuildVersion() {
        return this.buildVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMetamodelVersion() {
        return this.metamodelVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isNewerThan(Version other) {
        if (this.majorVersion < other.majorVersion) {
            return false;
        }
        if (this.majorVersion > other.majorVersion) {
            return true;
        }
        if (this.minorVersion < other.minorVersion) {
            return false;
        }
        if (this.minorVersion > other.minorVersion) {
            return true;
        }
        if (this.buildVersion < other.buildVersion) {
            return false;
        }
        if (this.buildVersion > other.buildVersion) {
            return true;
        }
        if (this.metamodelVersion < other.metamodelVersion) {
            return false;
        }
        return this.metamodelVersion > other.metamodelVersion;
    }

    public boolean isOlderThan(Version other) {
        if (this.majorVersion > other.majorVersion) {
            return false;
        }
        if (this.majorVersion < other.majorVersion) {
            return true;
        }
        if (this.minorVersion > other.minorVersion) {
            return false;
        }
        if (this.minorVersion < other.minorVersion) {
            return true;
        }
        if (this.buildVersion > other.buildVersion) {
            return false;
        }
        if (this.buildVersion < other.buildVersion) {
            return true;
        }
        if (this.metamodelVersion > other.metamodelVersion) {
            return false;
        }
        return this.metamodelVersion < other.metamodelVersion;
    }

    public String toString() {
        StringBuffer stringBuf = new StringBuffer();
        stringBuf.append(this.majorVersion);
        stringBuf.append('.');
        stringBuf.append(this.minorVersion);
        stringBuf.append('.');
        stringBuf.append(String.format("%02d", this.buildVersion));
        stringBuf.append('.');
        stringBuf.append(this.metamodelVersion);
        return stringBuf.toString();
    }

    private int parseRevision(String revision) throws NumberFormatException {
        try {
            return Integer.parseInt(revision);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(revision, 36);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.buildVersion;
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.metamodelVersion;
        result = 31 * result + this.minorVersion;
        return result;
    }
}

