/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui;

import com.modeliosoft.modelio.api.ui.IModelioDialog;
import org.eclipse.jface.dialogs.ControlAnimator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ImageAndMessageArea;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ModelioDialog
extends TrayDialog
implements IModelioDialog {
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    private static final int MIN_DIALOG_HEIGHT = 250;
    private static final int MIN_DIALOG_WIDTH = 350;
    Color titleAreaColor;
    private ControlAnimator animator;
    private String errorMessage;
    private Label leftFillerLabel;
    private String message = "";
    private ImageAndMessageArea messageArea;
    private Image messageImage;
    private Label messageImageLabel;
    private Text messageLabel;
    private int messageLabelHeight;
    private boolean showingError = false;
    private boolean showingWarning = false;
    private Composite titleArea;
    private RGB titleAreaRGB;
    private boolean titleImageLargest = true;
    private Label titleLabel;
    private Image titleLeftImage;
    private Label titleLeftImageLabel;
    private Image titleRightImage;
    private Label titleRightImageLabel;
    private String warningMessage;
    private Composite workArea;

    protected ModelioDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | ModelioDialog.getDefaultOrientation());
        this.setBlockOnOpen(true);
    }

    protected void addDefaultButtons(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.addButtonsInButtonBar(parent);
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)contents);
        FormLayout layout = new FormLayout();
        contents.setLayout((Layout)layout);
        this.workArea = new Composite(contents, 0);
        GridLayout childLayout = new GridLayout();
        childLayout.marginHeight = 0;
        childLayout.marginWidth = 0;
        childLayout.verticalSpacing = 0;
        this.workArea.setLayout((Layout)childLayout);
        Control top = this.createTitleArea(contents);
        this.resetWorkAreaAttachments(top);
        this.workArea.setFont(JFaceResources.getDialogFont());
        this.initializeDialogUnits((Control)this.workArea);
        this.dialogArea = this.createDialogArea(this.workArea);
        this.buttonBar = this.createButtonBar(this.workArea);
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ui", (String)"icons/headerLeft.png");
        Image image = imageDescriptor.createImage();
        this.setTitleLeftImage(image);
        this.init();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label titleBarSeparator = new Label(composite, 258);
        this.initHelpButton((Control)composite);
        this.createContentArea(composite);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(350), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(250), shellSize.y));
    }

    protected void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage != null ? this.errorMessage.equals(newErrorMessage) : newErrorMessage == null) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.messageArea != null && !this.showingWarning) {
                this.setMessageAreaVisible(false);
            }
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            if (this.showingWarning) {
                this.setWarningMessage(this.warningMessage);
            }
        } else {
            if (!this.showingError) {
                this.showingError = true;
            }
            if (this.showingWarning) {
                this.setWarningMessage(null);
            }
            if (this.messageArea == null) {
                this.messageArea = new ImageAndMessageArea(this.titleArea, 64);
                this.messageArea.setBackground(this.messageLabel.getBackground());
                this.animator = Policy.getAnimatorFactory().createAnimator((Control)this.messageArea);
            }
            this.messageArea.setToolTipText(this.errorMessage);
            this.messageArea.setText(this.errorMessage);
            this.messageArea.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
            this.setMessageAreaVisible(true);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
    }

    protected void setLogoImage(Image newLogoImage) {
        this.titleRightImage = newLogoImage;
        if (this.titleRightImageLabel != null && !this.titleRightImageLabel.isDisposed()) {
            this.titleRightImageLabel.setImage(newLogoImage);
            this.titleRightImageLabel.setVisible(newLogoImage != null);
            if (newLogoImage != null) {
                this.resetWorkAreaAttachments((Control)this.titleArea);
            }
        }
    }

    protected void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    protected void setTitle(String newTitle) {
        if (this.titleLabel == null) {
            return;
        }
        String title = newTitle;
        if (title == null) {
            title = "";
        }
        this.titleLabel.setText(title);
    }

    protected void setTitleLeftImage(Image newTitleImage) {
        this.titleLeftImage = newTitleImage;
        if (this.titleLeftImageLabel != null && !this.titleLeftImageLabel.isDisposed()) {
            this.titleLeftImageLabel.setImage(newTitleImage);
            this.titleLeftImageLabel.setVisible(newTitleImage != null);
            if (newTitleImage != null) {
                this.resetWorkAreaAttachments((Control)this.titleArea);
            }
        }
    }

    protected void setWarningMessage(String newMessage) {
        if (this.warningMessage != null ? this.warningMessage.equals(newMessage) : newMessage == null) {
            return;
        }
        this.warningMessage = newMessage;
        if (this.warningMessage == null) {
            if (this.messageArea != null && !this.showingError) {
                this.setMessageAreaVisible(false);
            }
            if (this.showingWarning) {
                this.showingWarning = false;
            }
        } else {
            if (!this.showingWarning) {
                this.showingWarning = true;
            }
            this.warningMessage = newMessage;
            if (this.messageArea == null) {
                this.messageArea = new ImageAndMessageArea(this.titleArea, 64);
                this.messageArea.setBackground(this.messageLabel.getBackground());
                this.animator = Policy.getAnimatorFactory().createAnimator((Control)this.messageArea);
            }
            this.messageArea.setToolTipText(this.warningMessage);
            this.messageArea.setText(this.warningMessage);
            this.messageArea.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            this.setMessageAreaVisible(true);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
    }

    private Control createTitleArea(Composite parent) {
        Color foreground;
        Color background;
        this.titleArea = new Composite(parent, 0);
        this.initializeDialogUnits((Control)this.titleArea);
        FormData titleAreaData = new FormData();
        titleAreaData.top = new FormAttachment(0, 0);
        titleAreaData.left = new FormAttachment(0, 0);
        titleAreaData.right = new FormAttachment(100, 0);
        this.titleArea.setLayoutData((Object)titleAreaData);
        FormLayout layout = new FormLayout();
        this.titleArea.setLayout((Layout)layout);
        this.titleArea.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Display display = this.titleArea.getDisplay();
        if (this.titleAreaRGB != null) {
            background = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground((Display)display);
            foreground = JFaceColors.getBannerForeground((Display)display);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.titleArea.setBackground(background);
        this.titleRightImageLabel = new Label(this.titleArea, 0);
        this.titleRightImageLabel.setBackground(background);
        if (this.titleRightImage != null && !this.titleRightImage.isDisposed()) {
            this.titleRightImageLabel.setImage(this.titleRightImage);
        }
        this.titleLeftImageLabel = new Label(this.titleArea, 0);
        this.titleLeftImageLabel.setBackground(background);
        if (this.titleLeftImage == null || this.titleLeftImage.isDisposed()) {
            this.titleLeftImageLabel.setImage(JFaceResources.getImage((String)"dialog_title_banner_image"));
        } else {
            this.titleLeftImageLabel.setImage(this.titleLeftImage);
        }
        FormData rightImageData = new FormData();
        rightImageData.top = new FormAttachment(0, 0);
        rightImageData.right = new FormAttachment(100, 0);
        this.titleRightImageLabel.setLayoutData((Object)rightImageData);
        FormData leftImageData = new FormData();
        leftImageData.top = new FormAttachment(0, 0);
        leftImageData.left = new FormAttachment(0, 0);
        this.titleLeftImageLabel.setLayoutData((Object)leftImageData);
        this.titleLabel = new Label(this.titleArea, 0);
        JFaceColors.setColors((Control)this.titleLabel, (Color)foreground, (Color)background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.left = new FormAttachment((Control)this.titleLeftImageLabel, 5);
        titleData.top = new FormAttachment(0, verticalSpacing);
        titleData.right = new FormAttachment((Control)this.titleRightImageLabel, -5);
        this.titleLabel.setLayoutData((Object)titleData);
        this.messageImageLabel = new Label(this.titleArea, 0);
        this.messageImageLabel.setBackground(background);
        this.messageLabel = new Text(this.titleArea, 74);
        this.messageLabel.setEnabled(false);
        this.messageLabel.setEditable(false);
        JFaceColors.setColors((Control)this.messageLabel, (Color)foreground, (Color)background);
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(this.titleArea, 0);
        this.leftFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        this.determineTitleImageLargest();
        return this.titleArea;
    }

    private void determineTitleImageLargest() {
        int titleY = this.titleLeftImageLabel.computeSize((int)-1, (int)-1).y;
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int labelY = this.titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += verticalSpacing;
        labelY += this.messageLabelHeight;
        this.titleImageLargest = titleY > (labelY += verticalSpacing);
    }

    private void layoutForNewMessage() {
        int verticalSpacing = this.convertVerticalDLUsToPixels(1);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        if (this.dialogArea != null) {
            this.titleArea.layout(true);
        }
    }

    private void resetWorkAreaAttachments(Control top) {
        FormData childData = new FormData();
        childData.top = new FormAttachment(top);
        childData.right = new FormAttachment(100, 0);
        childData.left = new FormAttachment(0, 0);
        childData.bottom = new FormAttachment(100, 0);
        this.workArea.setLayoutData((Object)childData);
    }

    private void setImageLabelVisible(boolean visible) {
        this.messageImageLabel.setVisible(visible);
        this.leftFillerLabel.setVisible(visible);
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this.titleRightImageLabel);
        messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, horizontalSpacing);
        if (!this.titleImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleRightImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)messageLabelData);
        FormData imageLabelData = new FormData();
        imageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        imageLabelData.left = new FormAttachment((Control)this.titleLeftImageLabel);
        this.messageImageLabel.setLayoutData((Object)imageLabelData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.titleLabel, 0, 128);
        data.left = new FormAttachment((Control)this.titleLeftImageLabel);
        data.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.leftFillerLabel.setLayoutData((Object)data);
    }

    protected void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)"dialog_message_error_image");
                }
            }
        }
        if (newType == 2) {
            this.setWarningMessage(newMessage);
        } else {
            this.setWarningMessage(null);
            this.showMessage(newMessage, newImage);
        }
    }

    private void setMessageAreaVisible(boolean visible) {
        this.messageArea.moveAbove(null);
        int bottom = this.titleArea.getBounds().y + this.titleArea.getBounds().height;
        Rectangle msgLabelBounds = this.messageLabel.getBounds();
        if (!this.messageArea.isVisible() && this.messageArea.getBounds().y != bottom) {
            this.messageArea.setBounds(this.messageImageLabel != null ? this.messageImageLabel.getBounds().x : msgLabelBounds.x, bottom, this.messageImageLabel != null ? msgLabelBounds.width + this.messageImageLabel.getBounds().width : msgLabelBounds.width, this.messageArea.computeSize((int)-1, (int)-1).y);
        }
        this.animator.setVisible(visible);
        this.setMessageLayoutData();
    }

    private void setMessageLayoutData() {
        if (this.messageArea == null) {
            return;
        }
        FormData messageAreaData = new FormData();
        messageAreaData.right = new FormAttachment((Control)this.titleRightImageLabel);
        messageAreaData.left = new FormAttachment((Control)this.leftFillerLabel);
        messageAreaData.bottom = new FormAttachment(100, 0);
        this.messageArea.setLayoutData((Object)messageAreaData);
    }

    private void showMessage(String newMessage, Image newImage) {
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        if (this.message == null) {
            this.message = "";
        }
        String shownMessage = this.message;
        this.messageImage = newImage;
        if (!this.showingError) {
            this.updateMessage(shownMessage);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            this.layoutForNewMessage();
        }
    }

    private void updateMessage(String newMessage) {
        this.messageLabel.setText(newMessage);
    }

    private void initHelpButton(Control control) {
        String helpId = this.getHelpId();
        if (helpId != null) {
            this.setHelpAvailable(true);
            control.addHelpListener((HelpListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected String getHelpId() {
        return null;
    }

    public void setBlockOnOpen(boolean shouldBlock) {
        if (!shouldBlock) {
            int style = this.getShellStyle();
            this.setShellStyle(style &= 0xFFFC7FFF);
        }
        super.setBlockOnOpen(shouldBlock);
    }
}

