/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.diagramcreation;

import com.modeliosoft.modelio.api.Messages;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.api.ui.diagramcreation.BrowserDialog;
import com.modeliosoft.modelio.api.ui.diagramcreation.ContributionModel;
import com.modeliosoft.modelio.api.ui.diagramcreation.DiagramWizardModel;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.ui.text.TextWrapperForIElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class DiagramWizardDialog
extends ModelioDialog
implements Listener {
    protected Button okButton;
    protected Button cancelButton;
    protected Button hideInvalidCheckBox;
    protected TextWrapperForIElement contextText;
    protected Text nameText;
    protected StyledText descriptionText;
    protected Table diagramList;
    protected DiagramWizardModel dataModel;
    protected ContributionModel contributionModel;
    protected DiagramWizardModel resultModel = null;
    protected StyledText detailsText;

    public DiagramWizardDialog(Shell parentShell, ContributionModel contributionModel, DiagramWizardModel dataModel) {
        super(parentShell);
        this.setShellStyle(3184);
        this.contributionModel = contributionModel;
        this.dataModel = dataModel;
    }

    public void setShowInvalidDiagram(Boolean value) {
        this.dataModel.setShowInvalidDiagram(value.booleanValue());
    }

    public void seDefaultContributor(IDiagramWizardContributor contributor) {
        this.dataModel.setSelectedContributor(contributor);
    }

    public List<IDiagramWizardContributor> getValidContributors(IElement context) {
        ArrayList<IDiagramWizardContributor> result = new ArrayList<IDiagramWizardContributor>();
        for (IDiagramWizardContributor type : this.contributionModel.getDiagramContributors()) {
            if (context == null || !type.accept(context)) continue;
            result.add(type);
        }
        return result;
    }

    public List<IDiagramWizardContributor> getInvalidContributors(IElement context) {
        ArrayList<IDiagramWizardContributor> result = new ArrayList<IDiagramWizardContributor>();
        for (IDiagramWizardContributor type : this.contributionModel.getDiagramContributors()) {
            if (context == null || type.accept(context)) continue;
            result.add(type);
        }
        return result;
    }

    private void update() {
        TableItem item;
        IDiagramWizardContributor selectedContributor = this.dataModel.getSelectedContributor();
        if (selectedContributor != null) {
            this.contextText.removeAllowedMetaclasses(this.contextText.getAllowedMetaclasses());
            this.contextText.addAllowedMetaclasses(selectedContributor.getAllowedMetaclasses());
            this.contextText.setAcceptNullValue(false);
            this.contextText.getTextField().setForeground(ColorConstants.red);
        }
        this.diagramList.removeAll();
        for (IDiagramWizardContributor type : this.getValidContributors((IElement)this.dataModel.getContext())) {
            item = new TableItem(this.diagramList, 0);
            item.setImage(type.getImage());
            item.setText(type.getCommandName());
            item.setData((Object)type);
            if (selectedContributor == null || !type.equals(selectedContributor)) continue;
            this.contextText.getTextField().setForeground(UIColor.BLACK);
            this.diagramList.setSelection(item);
            this.nameText.setText(selectedContributor.getCommandName());
            this.updateDetailsText(selectedContributor.getDetails());
            this.setMessage(selectedContributor.getInformation());
        }
        if (this.dataModel.isShowInvalidDiagram()) {
            for (IDiagramWizardContributor type : this.getInvalidContributors((IElement)this.dataModel.getContext())) {
                item = new TableItem(this.diagramList, 0);
                item.setImage(type.getImage());
                item.setText(type.getCommandName());
                item.setGrayed(true);
                item.setForeground(0, ColorConstants.gray);
                item.setData((Object)type);
                if (selectedContributor == null || !type.equals(selectedContributor)) continue;
                this.diagramList.setSelection(item);
                this.nameText.setText(selectedContributor.getCommandName());
                this.updateDetailsText(selectedContributor.getDetails());
                this.setMessage(selectedContributor.getInformation());
            }
        }
        TableColumn[] tableColumnArray = this.diagramList.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    public void handleEvent(Event event) {
        IModelElement context = (IModelElement)this.contextText.getTextField().getData();
        if (event.widget.equals(this.nameText)) {
            this.dataModel.setName(this.nameText.getText());
        } else if (event.widget.equals(this.descriptionText)) {
            this.dataModel.setDescription(this.descriptionText.getText());
        } else if (event.widget.equals(this.hideInvalidCheckBox)) {
            this.dataModel.setShowInvalidDiagram(!this.hideInvalidCheckBox.getSelection());
            this.update();
        } else if (event.widget.equals(this.diagramList)) {
            this.dataModel.setSelectedContributor((IDiagramWizardContributor)this.diagramList.getSelection()[0].getData());
            this.update();
        } else if (event.widget.equals(this.contextText.getTextField())) {
            this.dataModel.setContext(context);
            this.update();
        } else if (event.widget.equals(this.detailsText)) {
            try {
                int offset = this.detailsText.getOffsetAtLocation(new Point(event.x, event.y));
                StyleRange style = this.detailsText.getStyleRangeAtOffset(offset);
                if (style != null && style.underline && style.underlineStyle == 4) {
                    this.openBrowser();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.dataModel.getSelectedContributor() != null && this.dataModel.getSelectedContributor().accept((IElement)context) && context != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void addListeners() {
        this.nameText.addListener(24, (Listener)this);
        this.descriptionText.addListener(24, (Listener)this);
        this.hideInvalidCheckBox.addListener(13, (Listener)this);
        this.diagramList.addListener(13, (Listener)this);
        this.diagramList.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addListener(1, (Listener)this);
        this.okButton.addListener(0, (Listener)this);
        this.contextText.getTextField().addListener(24, (Listener)this);
        this.detailsText.addListener(3, (Listener)this);
    }

    protected void okPressed() {
        super.okPressed();
        this.resultModel = this.dataModel;
    }

    public Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite g1 = new Composite(composite, 0);
        g1.setLayout((Layout)new GridLayout(2, false));
        FormData fdDiagramG1 = new FormData();
        fdDiagramG1.top = new FormAttachment(0, 10);
        fdDiagramG1.bottom = new FormAttachment(100, -10);
        fdDiagramG1.left = new FormAttachment(0, 10);
        g1.setLayoutData((Object)fdDiagramG1);
        this.diagramList = new Table(g1, 2048);
        this.diagramList.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        TableColumn column = new TableColumn(this.diagramList, 0x1000000);
        column.setResizable(false);
        column.setWidth(200);
        this.hideInvalidCheckBox = new Button(g1, 32);
        this.hideInvalidCheckBox.setText(Messages.getMessage((String)"Ui.DiagramCreationWizard.HideInvalid", (String[])new String[0]));
        this.hideInvalidCheckBox.setLayoutData((Object)new GridData(4, 4, true, false));
        ToolBar toolBar = new ToolBar(g1, 0x880000);
        toolBar.setLayoutData((Object)new GridData(131072, 1024, false, false));
        Composite g3 = new Composite(composite, 0);
        g3.setLayout((Layout)new GridLayout(2, false));
        FormData fdG3 = new FormData();
        fdG3.top = new FormAttachment(65, 0);
        fdG3.bottom = new FormAttachment(100, -10);
        fdG3.left = new FormAttachment((Control)g1, 10);
        fdG3.right = new FormAttachment(100, -10);
        g3.setLayoutData((Object)fdG3);
        Group g2 = new Group(composite, 0);
        g2.setLayout((Layout)new GridLayout(2, false));
        FormData fdG2 = new FormData();
        fdG2.top = new FormAttachment(0, 10);
        fdG2.left = new FormAttachment((Control)g1, 10);
        fdG2.right = new FormAttachment(100, -10);
        fdG2.bottom = new FormAttachment((Control)g3, -10);
        g2.setLayoutData((Object)fdG2);
        Label nameLabel = new Label((Composite)g2, 0);
        nameLabel.setText(Messages.getMessage((String)"Ui.DiagramCreationWizard.Name", (String[])new String[0]));
        nameLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.nameText = new Text((Composite)g2, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label contextLabel = new Label((Composite)g2, 0);
        contextLabel.setText(Messages.getMessage((String)"Ui.DiagramCreationWizard.Context", (String[])new String[0]));
        contextLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.contextText = new TextWrapperForIElement((Composite)g2, null, false, null);
        this.contextText.getTextField().setLayoutData((Object)new GridData(4, 4, true, false));
        Label descriptionLabel = new Label((Composite)g2, 0);
        descriptionLabel.setText(Messages.getMessage((String)"Ui.DiagramCreationWizard.Description", (String[])new String[0]));
        descriptionLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.descriptionText = new StyledText((Composite)g2, 2112);
        this.descriptionText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionText.setBackground(UIColor.TEXT_READONLY_BG);
        this.descriptionText.setForeground(UIColor.EDITOR_ROTEXT_FG);
        this.descriptionText.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.detailsText = new StyledText(g3, 66);
        this.detailsText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.detailsText.setForeground(UIColor.LABEL_TIP_FG);
        this.detailsText.setEditable(false);
        this.detailsText.setBackground(g3.getBackground());
        this.update();
        return composite;
    }

    protected void openBrowser() {
        String helpUrl = this.dataModel.getSelectedContributor().getHelpUrl();
        if (helpUrl != null) {
            BrowserDialog dialog = new BrowserDialog(this.getShell(), helpUrl);
            dialog.open();
        }
    }

    public void init() {
        Shell shell = this.getShell();
        shell.setSize(650, 500);
        int x = this.getShell().getSize().x / 2 - 250;
        int y = this.getShell().getSize().y / 2 - 100;
        shell.setLocation(x, y);
        shell.setMinimumSize(800, 600);
        shell.setText(Messages.getMessage((String)"Ui.DiagramCreationWizard.ShellTitle", (String[])new String[0]));
        this.setTitle(Messages.getMessage((String)"Ui.DiagramCreationWizard.Title", (String[])new String[0]));
        this.setMessage(Messages.getMessage((String)"Ui.DiagramCreationWizard.Message", (String[])new String[0]));
        this.nameText.setText(this.dataModel.getName());
        this.descriptionText.setText(this.dataModel.getDescription());
        this.hideInvalidCheckBox.setSelection(!this.dataModel.isShowInvalidDiagram());
        this.addListeners();
        if (this.dataModel.getSelectedContributor() == null) {
            IModelElement initialContext;
            IModelElement context = initialContext = this.dataModel.getContext();
            List validContributors = this.getValidContributors((IElement)context);
            while (validContributors.size() == 0 && context != null) {
                context = context.getCompositionOwner();
                validContributors = this.getValidContributors((IElement)context);
            }
            if (validContributors.size() > 0) {
                IDiagramWizardContributor newContributor = (IDiagramWizardContributor)validContributors.get(0);
                this.dataModel.setSelectedContributor(newContributor);
                this.contextText.addAllowedMetaclasses(newContributor.getAllowedMetaclasses());
                this.contextText.setAcceptNullValue(false);
                if (this.contextText.acceptElement((IElement)context)) {
                    this.contextText.setElement((IElement)context);
                }
                this.dataModel.setContext(context);
            }
        } else {
            IModelElement initialContext;
            IDiagramWizardContributor contributor = this.dataModel.getSelectedContributor();
            IModelElement context = initialContext = this.dataModel.getContext();
            while (!contributor.accept((IElement)context) && context != null) {
                context = context.getCompositionOwner();
            }
            this.contextText.addAllowedMetaclasses(contributor.getAllowedMetaclasses());
            this.contextText.setAcceptNullValue(false);
            if (this.contextText.acceptElement((IElement)context)) {
                this.contextText.setElement((IElement)context);
            }
            this.dataModel.setContext(context);
        }
        this.update();
    }

    public DiagramWizardModel getResultModel() {
        return this.resultModel;
    }

    public boolean close() {
        this.contextText.pickingAborted();
        return super.close();
    }

    private void updateDetailsText(String text) {
        String helpUrl = this.dataModel.getSelectedContributor().getHelpUrl();
        if (helpUrl != null) {
            String moreText = Messages.getMessage((String)"Ui.DiagramCreationWizard.More", (String[])new String[0]);
            this.detailsText.setText(String.valueOf(text) + moreText);
            StyleRange style = new StyleRange();
            style.underline = true;
            style.underlineStyle = 4;
            int[] ranges = new int[]{this.detailsText.getText().length() - moreText.length() + 1, moreText.length() - 1};
            StyleRange[] styles = new StyleRange[]{style};
            this.detailsText.setStyleRanges(ranges, styles);
        } else {
            this.detailsText.setText(text);
        }
    }
}

