/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.dnd;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.utils.ObRef;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

public class EditorDropListener
implements DropTargetListener {
    private IEditorDropClient client;

    public void dragEnter(DropTargetEvent event) {
        ModelElementTransfer elementTransfer = ModelElementTransfer.getInstance();
        int i = 0;
        while (i < event.dataTypes.length) {
            if (elementTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                break;
            }
            ++i;
        }
        if (elementTransfer.isSupportedType(event.currentDataType)) {
            boolean accept = false;
            ObRef[] refs = (ObRef[])elementTransfer.nativeToJava(event.currentDataType);
            if (refs != null) {
                IElement[] elements = new IElement[refs.length];
                int i2 = 0;
                while (i2 < elements.length) {
                    elements[i2] = Modelio.getInstance().getModelingSession().findByRef(refs[i2]);
                    ++i2;
                }
                if (elements.length > 0) {
                    accept = this.client.acceptDroppedElements(elements);
                }
            } else {
                accept = true;
            }
            if (!accept) {
                event.detail = 0;
            }
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        ObRef[] refs;
        if (ModelElementTransfer.getInstance().isSupportedType(event.currentDataType) && (refs = (ObRef[])event.data) != null) {
            IElement[] dropedElements = new IElement[refs.length];
            int i = 0;
            while (i < dropedElements.length) {
                dropedElements[i] = Modelio.getInstance().getModelingSession().findByRef(refs[i]);
                ++i;
            }
            if (this.client.acceptDroppedElements(dropedElements)) {
                this.client.setDroppedElements(dropedElements);
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public EditorDropListener(IEditorDropClient client) {
        this.client = client;
    }
}

