/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.dnd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LinuxDropTarget
extends DropTarget
implements DropTargetListener {
    private Map<Control, DropTargetListener> delegationMap = new HashMap();
    private Set<Control> alreadyInControls = new HashSet();

    public LinuxDropTarget(Control parentControl, int style) {
        super(parentControl, style);
        super.addDropListener((DropTargetListener)this);
    }

    public void addDropListener(Control delegationControl, DropTargetListener delegationListener) {
        this.delegationMap.put(delegationControl, delegationListener);
    }

    public void dragEnter(DropTargetEvent event) {
        for (Control delegationControl : this.delegationMap.keySet()) {
            if (!this.isDelegated(delegationControl, event)) continue;
            ((DropTargetListener)this.delegationMap.get(delegationControl)).dragEnter(event);
            this.alreadyInControls.add(delegationControl);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        for (Control delegationControl : this.delegationMap.keySet()) {
            if (!this.isDelegated(delegationControl, event)) continue;
            ((DropTargetListener)this.delegationMap.get(delegationControl)).dragLeave(event);
            this.alreadyInControls.remove(delegationControl);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        for (Control delegationControl : this.delegationMap.keySet()) {
            if (!this.isDelegated(delegationControl, event)) continue;
            ((DropTargetListener)this.delegationMap.get(delegationControl)).dragOperationChanged(event);
        }
    }

    public void dragOver(DropTargetEvent event) {
        for (Control delegationControl : this.delegationMap.keySet()) {
            if (this.isDelegated(delegationControl, event)) {
                if (!this.isAlreadyIn(delegationControl)) {
                    ((DropTargetListener)this.delegationMap.get(delegationControl)).dragEnter(event);
                    this.alreadyInControls.add(delegationControl);
                    continue;
                }
                ((DropTargetListener)this.delegationMap.get(delegationControl)).dragOver(event);
                continue;
            }
            if (!this.isAlreadyIn(delegationControl)) continue;
            ((DropTargetListener)this.delegationMap.get(delegationControl)).dragLeave(event);
            this.alreadyInControls.remove(delegationControl);
        }
    }

    public void drop(DropTargetEvent event) {
        for (Control delegationControl : this.delegationMap.keySet()) {
            if (!this.isDelegated(delegationControl, event)) continue;
            ((DropTargetListener)this.delegationMap.get(delegationControl)).drop(event);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        for (Control delegationControl : this.delegationMap.keySet()) {
            if (!this.isDelegated(delegationControl, event)) continue;
            ((DropTargetListener)this.delegationMap.get(delegationControl)).dropAccept(event);
        }
    }

    protected void checkSubclass() {
    }

    private boolean isDelegated(Control delegationControl, DropTargetEvent event) {
        boolean contains;
        Point position = Display.getDefault().map(null, delegationControl, event.x, event.y);
        Rectangle delegationRectangle = delegationControl.getBounds();
        boolean bl = contains = position.x >= 0 && position.y >= 0 && position.x < delegationRectangle.width && position.y < delegationRectangle.height;
        return contains && delegationControl.isVisible() && this.getControl().isVisible();
    }

    private boolean isAlreadyIn(Control delegationControl) {
        return this.alreadyInControls.contains(delegationControl);
    }
}

