/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.dnd;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObRef;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public final class ModelElementTransfer
extends ByteArrayTransfer {
    private static final String MYTYPENAME = "model_element_type";
    private static final int MYTYPEID = ModelElementTransfer.registerType((String)"model_element_type");
    private static final ModelElementTransfer INSTANCE = new ModelElementTransfer();

    public static ModelElementTransfer getInstance() {
        return INSTANCE;
    }

    private ModelElementTransfer() {
    }

    protected int[] getTypeIds() {
        return new int[]{MYTYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{MYTYPENAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        IElement[] selectedElements = (IElement[])object;
        ObRef[] refs = new ObRef[selectedElements.length];
        int i = 0;
        while (i < selectedElements.length) {
            refs[i] = new ObRef(selectedElements[i]);
            ++i;
        }
        byte[] bytes = this.toByteArray(refs);
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(bytes);
    }

    public byte[] toByteArray(ObRef[] refs) {
        byte[] buffer = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(refs);
            out.close();
            buffer = bos.toByteArray();
        }
        catch (IOException e) {
            Modelio.getInstance().getLogService().error(null, (Throwable)e);
        }
        return buffer;
    }

    public ObRef[] fromByteArray(byte[] buffer) {
        ObRef[] myData;
        if (buffer == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer));
            Object obj = in.readObject();
            myData = (ObRef[])obj;
            in.close();
        }
        catch (ClassNotFoundException e) {
            Modelio.getInstance().getLogService().error(null, (Throwable)e);
            return null;
        }
        catch (IOException e) {
            Modelio.getInstance().getLogService().error(null, (Throwable)e);
            return null;
        }
        return myData;
    }
}

