/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.ui.text;

import com.modeliosoft.modelio.api.Messages;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ResultsProposalPopup
extends PopupDialog {
    protected boolean loop;
    protected List<IElement> elements;
    protected IElement selected;
    protected boolean acceptNullValue = false;
    protected Composite parent;
    protected org.eclipse.swt.widgets.List list;
    protected Rectangle listRectangle;

    public ResultsProposalPopup(Control control, List<IElement> elements, boolean acceptNullValue) {
        super(control.getShell(), 16, true, false, false, false, false, Messages.getMessage((String)"ResultsProposalPopup.title", (String[])new String[0]), Messages.getMessage((String)"ResultsProposalPopup.description", (String[])new String[0]));
        this.parent = control.getParent();
        this.elements = elements;
        this.selected = null;
        this.loop = false;
        this.acceptNullValue = acceptNullValue;
        Rectangle textRect = control.getBounds();
        Rectangle tableRect = this.parent.getBounds();
        int posX = textRect.x;
        int posY = textRect.y;
        int width = textRect.width;
        int height = tableRect.height - textRect.y;
        if (width < 100) {
            width = 100;
        }
        if (height < 100) {
            height = 100;
        }
        this.listRectangle = Display.getDefault().map((Control)this.parent, null, new Rectangle(posX, posY, width, height));
    }

    protected Point getInitialSize() {
        return new Point(10, 10);
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(this.listRectangle.x, this.listRectangle.y);
    }

    protected Control createDialogArea(Composite area) {
        Composite composite = (Composite)super.createDialogArea(area);
        composite.setLayout((Layout)new FillLayout(512));
        this.list = new org.eclipse.swt.widgets.List(composite, 2564);
        return composite;
    }

    public Object getChoice() {
        Display display = Display.getDefault();
        this.open();
        this.setTitleText(Messages.getMessage((String)"ResultsProposalPopup.choose", (String[])new String[]{"" + this.elements.size()}));
        if (this.getShell().getSize().y < 100) {
            this.getShell().setSize(this.getShell().getSize().x, 100);
        }
        if (this.acceptNullValue) {
            this.list.add(Messages.getMessage((String)"None", (String[])new String[0]));
        }
        for (IElement e : this.elements) {
            if (!(e instanceof IModelElement)) continue;
            IModelElement me = (IModelElement)e;
            String item = me.getName();
            IElement owner = me.getCompositionOwner();
            if (owner instanceof IModelElement) {
                item = String.valueOf(item) + "  (" + Messages.getMessage((String)"From", (String[])new String[0]) + " " + ((IModelElement)me.getCompositionOwner()).getName() + ")";
            }
            this.list.add(item);
        }
        this.list.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.list.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.loop = true;
        while (this.loop) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Exception e) {
                Modelio.getInstance().getLogService().error(null, (Throwable)e);
            }
        }
        this.close();
        return this.selected;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void adjustBounds() {
        this.getShell().setBounds(this.listRectangle);
    }
}

