/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.deploy.util.URLUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ImageLoader
implements Runnable {
    private Component _component;
    private static ImageLoader _instance = null;
    private final Object _imageLoadingLock = new Object();
    private boolean _running = false;
    private ArrayList _toLoad = new ArrayList();

    private ImageLoader() {
    }

    public static ImageLoader getInstance() {
        if (_instance == null) {
            _instance = new ImageLoader();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getComponent() {
        if (this._component == null) {
            ImageLoader imageLoader = this;
            synchronized (imageLoader) {
                if (this._component == null) {
                    this._component = new Component(){};
                }
            }
        }
        return this._component;
    }

    public Image loadImage(String string) throws IOException {
        Image image = Toolkit.getDefaultToolkit().createImage(string);
        if (image != null) {
            Component component = this.getComponent();
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Failed to load");
            }
            return image;
        }
        return null;
    }

    public Image loadImage(URL uRL) throws IOException {
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        if (image != null) {
            Component component = this.getComponent();
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Failed to load");
            }
            return image;
        }
        return null;
    }

    public void loadImage(URL uRL, String string, ImageLoaderCallback imageLoaderCallback) {
        this.loadImage(uRL, string, imageLoaderCallback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(URL uRL, String string, ImageLoaderCallback imageLoaderCallback, boolean bl) {
        boolean bl2 = false;
        Object object = this._imageLoadingLock;
        synchronized (object) {
            if (!this._running) {
                this._running = true;
                bl2 = true;
            }
            this._toLoad.add(new LoadEntry(uRL, string, imageLoaderCallback, bl));
        }
        if (bl2) {
            new Thread(this).start();
        }
    }

    public void loadImage(URL uRL, ImageLoaderCallback imageLoaderCallback) {
        this.loadImage(uRL, imageLoaderCallback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(URL uRL, ImageLoaderCallback imageLoaderCallback, boolean bl) {
        boolean bl2 = false;
        Object object = this._imageLoadingLock;
        synchronized (object) {
            if (!this._running) {
                this._running = true;
                bl2 = true;
            }
            this._toLoad.add(new LoadEntry(uRL, imageLoaderCallback, bl));
        }
        if (bl2) {
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        while (!bl) {
            LoadEntry loadEntry = null;
            Object object = this._imageLoadingLock;
            synchronized (object) {
                if (this._toLoad.size() > 0) {
                    loadEntry = (LoadEntry)this._toLoad.remove(0);
                } else {
                    bl = true;
                    this._running = false;
                }
            }
            if (bl) continue;
            try {
                object = null;
                File file = null;
                URL uRL = loadEntry.url;
                if (uRL == null) {
                    Resource resource = ResourceProvider.get().getResource(loadEntry.iconRef, loadEntry.iconVer, false, 0, null);
                    File file2 = file = resource != null ? resource.getDataFile() : null;
                    if (file != null) {
                        uRL = URLUtil.fileToURL(file);
                    }
                }
                if (uRL != null) {
                    object = this.loadImage(uRL);
                }
                if (object != null) {
                    if (loadEntry.useCached) {
                        ImageLoader.publish(loadEntry, (Image)object, file, true);
                        continue;
                    }
                    ImageLoader.publish(loadEntry, (Image)object, file, false);
                    if (loadEntry.iconRef == null) continue;
                    new DelayedImageLoader(loadEntry, (Image)object).start();
                    continue;
                }
                if (loadEntry.iconRef == null) continue;
                new DelayedImageLoader(loadEntry, (Image)object).start();
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    private static void publish(LoadEntry loadEntry, final Image image, final File file, final boolean bl) {
        final URL uRL = loadEntry.iconRef;
        final String string = loadEntry.iconVer;
        final ImageLoaderCallback imageLoaderCallback = loadEntry.cb;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl) {
                    imageLoaderCallback.finalImageAvailable(uRL, string, image, file);
                } else {
                    imageLoaderCallback.imageAvailable(uRL, string, image, file);
                }
            }
        });
    }

    private class DelayedImageLoader
    extends Thread {
        private LoadEntry _entry;
        private Image _image;

        public DelayedImageLoader(LoadEntry loadEntry, Image image) {
            this._entry = loadEntry;
            this._image = image;
        }

        public void run() {
            try {
                Resource resource = ResourceProvider.get().getResource(this._entry.iconRef, this._entry.iconVer);
                File file = resource != null ? resource.getDataFile() : null;
                this._image = file != null ? ImageLoader.this.loadImage(file.getPath()) : ImageLoader.this.loadImage(this._entry.iconRef);
                ImageLoader.publish(this._entry, this._image, file, true);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    private class LoadEntry {
        public URL url;
        public URL iconRef;
        public String iconVer;
        public ImageLoaderCallback cb;
        public boolean useCached;

        public LoadEntry(URL uRL, String string, ImageLoaderCallback imageLoaderCallback, boolean bl) {
            this.cb = imageLoaderCallback;
            this.url = null;
            this.iconRef = uRL;
            this.iconVer = string;
            this.useCached = bl;
        }

        public LoadEntry(URL uRL, ImageLoaderCallback imageLoaderCallback, boolean bl) {
            this.url = uRL;
            this.cb = imageLoaderCallback;
            this.iconRef = null;
            this.iconVer = null;
            this.useCached = bl;
        }

        public String toString() {
            return "LoadEntry:\n  url: " + this.url + "\n" + "  iconRef " + this.iconRef + "\n" + "  iconVer: " + this.iconVer + "  useCached: " + this.useCached;
        }
    }
}

