/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable;

import de.kupzog.ktable.KTableCellDoubleClickListener;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableCellResizeListener;
import de.kupzog.ktable.KTableCellSelectionAdapter;
import de.kupzog.ktable.KTableCellSelectionListener;
import de.kupzog.ktable.KTableClickInterceptionListener;
import de.kupzog.ktable.KTableCursorProvider;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.renderers.TextCellRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class KTable
extends Canvas {
    protected KTableModel m_Model;
    protected KTableCellEditor m_CellEditor;
    protected int m_TopRow;
    protected int m_LeftColumn;
    protected HashMap m_Selection;
    protected int m_FocusRow;
    protected int m_FocusCol;
    protected int m_MainFocusRow;
    protected int m_MainFocusCol;
    protected int m_ClickColumnIndex;
    protected int m_ClickRowIndex;
    private int m_Style = 0;
    protected int m_RowsVisible;
    protected int m_RowsFullyVisible;
    protected int m_ColumnsVisible;
    protected int m_ColumnsFullyVisible;
    protected int m_ResizeColumnIndex;
    protected int m_ResizeColumnLeft;
    protected int m_ResizeRowIndex;
    protected int m_ResizeRowTop;
    protected boolean m_Capture = false;
    protected Color m_ColorTopBorder;
    protected Color m_ColorLeftBorder;
    protected Color m_ColorRightBorder;
    protected int m_ResizeAreaSize = 10;
    protected Display m_Display;
    protected ArrayList cellSelectionListeners;
    protected ArrayList cellDoubleClickListeners;
    protected ArrayList cellResizeListeners;
    protected ArrayList cellClickListeners;
    protected Cursor m_defaultCursor;
    protected Point m_defaultCursorSize;
    protected Cursor m_defaultRowResizeCursor;
    protected Cursor m_defaultColumnResizeCursor;
    protected String m_nativTooltip;
    protected KTableCursorProvider m_CursorProvider;
    protected int m_numRowsVisibleInPreferredSize = 1;
    protected int m_numColsVisibleInPreferredSize = 1;
    protected int m_preferredSizeDefaultRowHeight = 0;
    private static final int INVISIBLE_ROWS_TO_REGARD_DURING_WIDTH_OPTIMIZATION = 50;

    public KTable(Composite parent, int style) {
        super(parent, 0x140000 | style);
        this.m_Style = style;
        this.m_Display = Display.getCurrent();
        this.m_Selection = new HashMap();
        this.m_CellEditor = null;
        this.m_TopRow = 0;
        this.m_LeftColumn = 0;
        this.m_FocusRow = 0;
        this.m_FocusCol = 0;
        this.m_RowsVisible = 0;
        this.m_RowsFullyVisible = 0;
        this.m_ColumnsVisible = 0;
        this.m_ColumnsFullyVisible = 0;
        this.m_ResizeColumnIndex = -1;
        this.m_ResizeRowIndex = -1;
        this.m_ResizeRowTop = -1;
        this.m_ResizeColumnLeft = -1;
        this.m_ClickColumnIndex = -1;
        this.m_ClickRowIndex = -1;
        this.cellSelectionListeners = new ArrayList(10);
        this.cellDoubleClickListeners = new ArrayList(10);
        this.cellResizeListeners = new ArrayList(10);
        this.cellClickListeners = new ArrayList(10);
        this.createListeners();
        this.m_nativTooltip = super.getToolTipText();
        super.setToolTipText("");
        if ((style & 0x700) == 1792) {
            this.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    KTable.this.updateScrollbarVisibility();
                }
            });
            this.addCellResizeListener(new KTableCellResizeListener(){

                public void rowResized(int row, int newHeight) {
                    KTable.this.updateScrollbarVisibility();
                }

                public void columnResized(int col, int newWidth) {
                    KTable.this.updateScrollbarVisibility();
                }
            });
        }
        this.m_ColorTopBorder = (this.getStyle() & 0x800000) == 0 ? this.m_Display.getSystemColor(17) : this.m_Display.getSystemColor(25);
        this.m_ColorRightBorder = this.m_ColorLeftBorder = this.m_ColorTopBorder;
    }

    public void dispose() {
        if (this.m_defaultCursor != null) {
            this.m_defaultCursor.dispose();
        }
        if (this.m_defaultRowResizeCursor != null) {
            this.m_defaultRowResizeCursor.dispose();
        }
        if (this.m_defaultColumnResizeCursor != null) {
            this.m_defaultColumnResizeCursor.dispose();
        }
        super.dispose();
    }

    protected void createListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                KTable.this.onPaint(event);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                KTable.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                KTable.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                KTable.this.onMouseUp(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                KTable.this.onMouseDoubleClick(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                KTable.this.onMouseMove(e);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                KTable.this.onKeyDown(e);
            }
        });
        this.addCellSelectionListener(new KTableCellSelectionAdapter(){
            private Point[] oldSelections;

            public void cellSelected(int col, int row, int statemask) {
                if (KTable.this.isHighlightSelectionInHeader() && (statemask & 0x20000) == 0) {
                    Point[] selections = KTable.this.getCellSelection();
                    GC gc = new GC((Drawable)KTable.this);
                    this.repaintRelevantCells(gc, this.oldSelections);
                    this.repaintRelevantCells(gc, selections);
                    gc.dispose();
                    this.oldSelections = selections;
                }
            }

            private void repaintRelevantCells(GC gc, Point[] selections) {
                if (selections == null) {
                    return;
                }
                Rectangle bounds = KTable.this.getClientArea();
                Rectangle oldClipping = gc.getClipping();
                int fixedWidth = 0;
                int fixedHeight = 0;
                int k = 0;
                while (k < KTable.this.m_Model.getFixedHeaderColumnCount()) {
                    fixedWidth += KTable.this.getCellRectIgnoreSpan((int)k, (int)0).width + 1;
                    ++k;
                }
                k = 0;
                while (k < KTable.this.m_Model.getFixedHeaderRowCount()) {
                    fixedHeight += KTable.this.getCellRectIgnoreSpan((int)0, (int)k).height + 1;
                    ++k;
                }
                int i = 0;
                while (i < selections.length) {
                    Rectangle rowClip;
                    Point valid;
                    int col = selections[i].x;
                    int row = selections[i].y;
                    int j = 0;
                    while (j < KTable.this.getModel().getFixedHeaderColumnCount()) {
                        valid = KTable.this.getValidCell(j, row);
                        rowClip = new Rectangle(1, 1 + fixedHeight, fixedWidth, bounds.height - 1 - fixedHeight);
                        rowClip.intersect(oldClipping);
                        gc.setClipping(rowClip);
                        KTable.this.drawCell(gc, valid.x, valid.y);
                        ++j;
                    }
                    j = 0;
                    while (j < KTable.this.getModel().getFixedHeaderRowCount()) {
                        valid = KTable.this.getValidCell(col, j);
                        rowClip = new Rectangle(1 + fixedWidth, 1, bounds.width - 1 - fixedWidth, fixedHeight);
                        rowClip.intersect(oldClipping);
                        gc.setClipping(rowClip);
                        KTable.this.drawCell(gc, valid.x, valid.y);
                        ++j;
                    }
                    gc.setClipping(oldClipping);
                    ++i;
                }
            }
        });
        this.addFocusListener(new FocusListener(){
            private Point[] oldSelection;

            public void focusGained(FocusEvent e) {
                if (!KTable.this.isShowSelectionWithoutFocus() && this.oldSelection != null) {
                    KTable.this.setSelection(this.oldSelection, false);
                    int i = 0;
                    while (i < this.oldSelection.length) {
                        KTable.this.updateCell(this.oldSelection[i].x, this.oldSelection[i].y);
                        ++i;
                    }
                    this.oldSelection = null;
                }
            }

            public void focusLost(FocusEvent e) {
                if (!KTable.this.isShowSelectionWithoutFocus()) {
                    this.oldSelection = KTable.this.getCellSelection();
                    KTable.this.clearSelection();
                    if (this.oldSelection != null) {
                        int i = 0;
                        while (i < this.oldSelection.length) {
                            KTable.this.updateCell(this.oldSelection[i].x, this.oldSelection[i].y);
                            ++i;
                        }
                    }
                }
            }
        });
        TooltipListener tooltipListener = new TooltipListener();
        this.addListener(12, tooltipListener);
        this.addListener(1, tooltipListener);
        this.addListener(3, tooltipListener);
        this.addListener(8, tooltipListener);
        this.addListener(5, tooltipListener);
        this.addListener(32, tooltipListener);
        this.addListener(7, tooltipListener);
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int oldTopRow = KTable.this.m_TopRow;
                    KTable.this.m_TopRow = KTable.this.getVerticalBar().getSelection() + KTable.this.getFixedRowCount();
                    if (oldTopRow != KTable.this.m_TopRow) {
                        KTable.this.redraw();
                    }
                }
            });
            this.getVerticalBar().addListener(13, (Listener)tooltipListener);
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int oldLeftCol = KTable.this.m_LeftColumn;
                    KTable.this.m_LeftColumn = KTable.this.getHorizontalBar().getSelection() + KTable.this.getFixedColumnCount();
                    if (oldLeftCol != KTable.this.m_LeftColumn) {
                        KTable.this.redraw();
                    }
                }
            });
            this.getHorizontalBar().addListener(13, (Listener)tooltipListener);
        }
    }

    protected int getFixedWidth() {
        int width = 0;
        int i = 0;
        while (i < this.getFixedColumnCount()) {
            width += this.getColumnWidth(i);
            ++i;
        }
        return width;
    }

    protected int getHeaderWidth() {
        int width = 0;
        int i = 0;
        while (i < this.m_Model.getFixedHeaderColumnCount()) {
            width += this.getColumnWidth(i);
            ++i;
        }
        return width;
    }

    protected int getColumnLeft(int index) {
        if (index < this.getFixedColumnCount()) {
            int x = 0;
            int i = 0;
            while (i < index) {
                x += this.getColumnWidth(i);
                ++i;
            }
            return x;
        }
        if (index < this.m_LeftColumn) {
            return this.getFixedWidth();
        }
        if (index > this.m_LeftColumn + this.m_ColumnsVisible) {
            return -1;
        }
        int x = this.getFixedWidth();
        int i = this.m_LeftColumn;
        while (i < index) {
            x += this.getColumnWidth(i);
            ++i;
        }
        return x;
    }

    protected int getColumnRight(int index) {
        if (index < 0) {
            return 0;
        }
        return this.getColumnLeft(index) + this.getColumnWidth(index);
    }

    protected int getRowBottom(int index) {
        if (index < 0) {
            return 0;
        }
        int y = this.getFixedHeight();
        int i = this.m_TopRow;
        while (i <= index) {
            y += this.m_Model.getRowHeight(i);
            ++i;
        }
        return y;
    }

    private int getFixedHeight() {
        int height = 1;
        int i = 0;
        while (i < this.getFixedRowCount()) {
            height += this.m_Model.getRowHeight(i);
            ++i;
        }
        return height;
    }

    public int getVisibleRowCount() {
        if (this.m_Model == null) {
            return 0;
        }
        return this.getFixedRowCount() + this.getFullyVisibleRowCount(this.getFixedHeight());
    }

    private int getFullyVisibleRowCount(int fixedHeight) {
        Rectangle rect = this.getClientArea();
        int count = 0;
        int heightSum = fixedHeight;
        int i = this.m_TopRow;
        while (heightSum < rect.height && i < this.m_Model.getRowCount()) {
            int rowHeight = this.m_Model.getRowHeight(i);
            if (heightSum + rowHeight > rect.height) break;
            ++count;
            heightSum += rowHeight;
            ++i;
        }
        return count;
    }

    private int getFullyVisibleRowCountAtEndOfTable() {
        Rectangle rect = this.getClientArea();
        int count = 0;
        int heightSum = this.getFixedHeight();
        int i = this.m_Model.getRowCount() - 1;
        while (heightSum < rect.height && i >= this.getFixedRowCount()) {
            int rowHeight = this.m_Model.getRowHeight(i);
            if (heightSum + rowHeight > rect.height) break;
            ++count;
            heightSum += rowHeight;
            --i;
        }
        return count;
    }

    private int getFullyVisibleColCountAtEndOfTable() {
        Rectangle rect = this.getClientArea();
        int count = 0;
        int widthSum = this.getFixedWidth();
        int i = this.m_Model.getColumnCount() - 1;
        while (widthSum < rect.width && i >= this.getFixedColumnCount()) {
            int colWidth = this.m_Model.getColumnWidth(i);
            if (widthSum + colWidth > rect.width) break;
            ++count;
            widthSum += colWidth;
            --i;
        }
        return count;
    }

    protected void doCalculations() {
        ScrollBar sb;
        boolean allRowsFullyVisible;
        if (this.m_Model == null) {
            ScrollBar sb2 = this.getHorizontalBar();
            if (sb2 != null) {
                sb2.setMinimum(0);
                sb2.setMaximum(1);
                sb2.setPageIncrement(1);
                sb2.setThumb(1);
                sb2.setSelection(1);
            }
            if ((sb2 = this.getVerticalBar()) != null) {
                sb2.setMinimum(0);
                sb2.setMaximum(1);
                sb2.setPageIncrement(1);
                sb2.setThumb(1);
                sb2.setSelection(1);
            }
            return;
        }
        Rectangle rect = this.getClientArea();
        if (this.m_LeftColumn < this.getFixedColumnCount()) {
            this.m_LeftColumn = this.getFixedColumnCount();
        }
        if (this.m_LeftColumn > this.m_Model.getColumnCount()) {
            this.m_LeftColumn = 0;
        }
        if (this.m_TopRow < this.getFixedRowCount()) {
            this.m_TopRow = this.getFixedRowCount();
        }
        if (this.m_TopRow > this.m_Model.getRowCount()) {
            this.m_TopRow = 0;
        }
        boolean allColumnsFullyVisible = this.getFullyVisibleColCountAtEndOfTable() == this.m_Model.getColumnCount() - this.getFixedColumnCount();
        boolean bl = allRowsFullyVisible = this.getFullyVisibleRowCountAtEndOfTable() == this.m_Model.getRowCount() - this.getFixedRowCount();
        if (allColumnsFullyVisible) {
            this.m_LeftColumn = this.getFixedColumnCount();
        }
        if (allRowsFullyVisible) {
            this.m_TopRow = this.getFixedRowCount();
        }
        int fixedHeight = this.getFixedHeight();
        this.m_ColumnsVisible = 0;
        this.m_ColumnsFullyVisible = 0;
        if (this.m_Model.getColumnCount() > this.getFixedColumnCount()) {
            int runningWidth = this.getColumnLeft(this.m_LeftColumn);
            int col = this.m_LeftColumn;
            while (col < this.m_Model.getColumnCount()) {
                if (runningWidth < rect.width + rect.x) {
                    ++this.m_ColumnsVisible;
                }
                if ((runningWidth += this.getColumnWidth(col)) >= rect.width + rect.x) break;
                ++this.m_ColumnsFullyVisible;
                ++col;
            }
        }
        if ((sb = this.getHorizontalBar()) != null) {
            if (this.m_Model.getColumnCount() <= this.getFixedColumnCount() || allColumnsFullyVisible) {
                sb.setMinimum(0);
                sb.setMaximum(1);
                sb.setPageIncrement(1);
                sb.setThumb(1);
                sb.setSelection(1);
            } else {
                sb.setMinimum(0);
                sb.setMaximum(this.m_Model.getColumnCount() - this.getFullyVisibleColCountAtEndOfTable() + 5 - this.getFixedColumnCount());
                sb.setIncrement(1);
                sb.setPageIncrement(1);
                sb.setThumb(5);
                sb.setSelection(this.m_LeftColumn - this.getFixedColumnCount());
            }
        }
        this.m_RowsFullyVisible = this.getFullyVisibleRowCount(fixedHeight);
        this.m_RowsFullyVisible = Math.min(this.m_RowsFullyVisible, this.m_Model.getRowCount() - this.getFixedRowCount());
        this.m_RowsFullyVisible = Math.max(0, this.m_RowsFullyVisible);
        this.m_RowsVisible = this.m_RowsFullyVisible + 1;
        if (this.m_TopRow + this.m_RowsFullyVisible > this.m_Model.getRowCount()) {
            this.m_TopRow = Math.max(this.getFixedRowCount(), this.m_Model.getRowCount() - this.m_RowsFullyVisible);
        }
        if (this.m_TopRow + this.m_RowsFullyVisible >= this.m_Model.getRowCount()) {
            --this.m_RowsVisible;
        }
        if ((sb = this.getVerticalBar()) != null) {
            if (this.m_Model.getRowCount() <= this.getFixedRowCount() || allRowsFullyVisible) {
                sb.setMinimum(0);
                sb.setMaximum(1);
                sb.setPageIncrement(1);
                sb.setThumb(1);
                sb.setSelection(1);
            } else {
                sb.setMinimum(0);
                sb.setMaximum(this.m_Model.getRowCount() - this.getFullyVisibleRowCountAtEndOfTable() + 5 - this.getFixedRowCount());
                sb.setPageIncrement(this.m_RowsVisible - this.getFixedRowCount());
                sb.setIncrement(1);
                sb.setThumb(5);
                sb.setSelection(this.m_TopRow - this.getFixedRowCount());
            }
        }
    }

    protected Rectangle getCellRectIgnoreSpan(int col, int row) {
        return this.getCellRectIgnoreSpan(col, row, this.getColumnLeft(col) + 1);
    }

    protected Rectangle getCellRectIgnoreSpan(int col, int row, int x_startValue) {
        if (col < 0 || col >= this.m_Model.getColumnCount()) {
            return new Rectangle(-1, -1, 0, 0);
        }
        int x = x_startValue;
        int y = this.getYforRow(row);
        if (row >= this.getFixedRowCount() && row < this.m_TopRow) {
            y = this.getFixedHeight();
        }
        int width = this.getColumnWidth(col) - 1;
        int height = this.m_Model.getRowHeight(row) - 1;
        return new Rectangle(x, y, width, height);
    }

    private int getRowForY(int y) {
        int height;
        int rowSum = 1;
        int i = 0;
        while (i < this.getFixedRowCount()) {
            height = this.m_Model.getRowHeight(i);
            if (rowSum <= y && rowSum + height > y) {
                return i;
            }
            rowSum += height;
            ++i;
        }
        i = this.m_TopRow;
        while (i < this.m_Model.getRowCount()) {
            height = this.m_Model.getRowHeight(i);
            if (rowSum <= y && rowSum + height > y) {
                return i;
            }
            rowSum += height;
            ++i;
        }
        return -1;
    }

    private int getYforRow(int row) {
        int y;
        if (row == 0) {
            return 1;
        }
        if (row < this.getFixedRowCount()) {
            y = 1;
            int i = 0;
            while (i < row) {
                y += this.m_Model.getRowHeight(i);
                ++i;
            }
        } else {
            y = this.getFixedHeight();
            int i = this.m_TopRow;
            while (i < row) {
                y += this.m_Model.getRowHeight(i);
                ++i;
            }
        }
        return y;
    }

    private Rectangle getCellRect(int col, int row, int left_X) {
        Rectangle bound = this.getCellRectIgnoreSpan(col, row, left_X);
        bound.width += this.calculateExtraCellWidth(col, row, true);
        bound.height += this.calculateExtraCellHeight(col, row, true);
        return bound;
    }

    public Rectangle getCellRect(int col, int row) {
        this.checkWidget();
        Point valid = this.getValidCell(col, row);
        if (valid.x != col || row != valid.y) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bound = this.getCellRectIgnoreSpan(col, row);
        bound.width += this.calculateExtraCellWidth(col, row, true);
        bound.height += this.calculateExtraCellHeight(col, row, true);
        return bound;
    }

    private int calculateExtraCellWidth(int col, int row, boolean resultInPixels) {
        Point valid = this.getValidCell(col, row);
        if (valid.x != col || valid.y != row) {
            return 0;
        }
        int widthInPx = 0;
        int widthInColumns = 0;
        int i = 1;
        while (col + i < this.m_Model.getColumnCount() && this.getValidCell(col + i, row).equals((Object)new Point(col, row))) {
            if (col < this.getFixedColumnCount() && col + i >= this.getFixedColumnCount()) break;
            widthInPx += this.getColumnWidth(col + i);
            widthInColumns = i++;
        }
        if (col < this.getFixedColumnCount() && col + i >= this.getFixedColumnCount()) {
            int j = 0;
            while (this.getValidCell(this.m_LeftColumn + j, row).equals((Object)new Point(col, row))) {
                widthInPx += this.getColumnWidth(this.m_LeftColumn + j);
                widthInColumns = this.m_LeftColumn + j - row;
                ++j;
            }
        }
        if (col >= this.getFixedColumnCount() && col - this.m_LeftColumn < 0) {
            int k = 0;
            while (k < Math.abs(col - this.m_LeftColumn)) {
                widthInPx -= this.getColumnWidth(col + k);
                ++k;
            }
        }
        if (resultInPixels) {
            return widthInPx;
        }
        return widthInColumns;
    }

    private int calculateExtraCellHeight(int col, int row, boolean resultInPixels) {
        Point valid = this.getValidCell(col, row);
        if (valid.x != col || valid.y != row) {
            return 0;
        }
        int heightInPx = 0;
        int heightInRows = 0;
        int i = 1;
        while (row + i < this.m_Model.getRowCount() && this.getValidCell(col, row + i).equals((Object)new Point(col, row))) {
            if (row < this.getFixedRowCount() && row + i >= this.getFixedRowCount()) break;
            heightInPx += this.m_Model.getRowHeight(row + i);
            heightInRows = i++;
        }
        if (row < this.getFixedRowCount() && row + i >= this.getFixedRowCount()) {
            int j = 0;
            while (this.getValidCell(col, this.m_TopRow + j).equals((Object)new Point(col, row))) {
                heightInPx += this.m_Model.getRowHeight(this.m_TopRow + j);
                heightInRows = this.m_TopRow + j - row;
                ++j;
            }
        }
        if (row >= this.getFixedRowCount() && row - this.m_TopRow < 0) {
            int k = 0;
            while (k < Math.abs(row - this.m_TopRow)) {
                heightInPx -= this.m_Model.getRowHeight(row + k);
                ++k;
            }
        }
        if (resultInPixels) {
            return heightInPx;
        }
        return heightInRows;
    }

    public int getVisibleCellSpanWidth(int col, int row) {
        return this.calculateExtraCellWidth(col, row, false);
    }

    public int getVisibleCellSpanHeight(int col, int row) {
        return this.calculateExtraCellHeight(col, row, false);
    }

    public Rectangle getCellSpanExtent(int col, int row) {
        Point valid = this.getValidCell(col, row);
        Rectangle extent = new Rectangle(valid.x, valid.y, 1, 1);
        int i = extent.width;
        while (this.getValidCell(valid.x + i, valid.y).equals((Object)valid)) {
            ++extent.width;
            ++i;
        }
        int j = extent.height;
        while (this.getValidCell(valid.x, valid.y + j).equals((Object)valid)) {
            ++extent.height;
            ++j;
        }
        return extent;
    }

    protected boolean canDrawCell(Rectangle r, Rectangle clipRect) {
        if (r.height == 0 || r.width == 0) {
            return false;
        }
        if (r.y + r.height < clipRect.y) {
            return false;
        }
        if (r.y > clipRect.y + clipRect.height) {
            return false;
        }
        if (r.x + r.width < clipRect.x) {
            return false;
        }
        return r.x <= clipRect.x + clipRect.width;
    }

    protected void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        GC gc = event.gc;
        this.doCalculations();
        if (this.m_Model != null) {
            Rectangle oldClipping = this.setContentAreaClipping(gc);
            this.drawCells(gc, oldClipping, this.m_LeftColumn, this.m_Model.getColumnCount(), this.m_TopRow, this.m_TopRow + this.m_RowsVisible);
            this.setTopAreaClipping(gc, oldClipping);
            this.drawCells(gc, gc.getClipping(), 0, this.getFixedColumnCount(), this.m_TopRow, this.m_TopRow + this.m_RowsVisible);
            this.setLeftAreaClipping(gc, oldClipping);
            this.drawCells(gc, gc.getClipping(), this.m_LeftColumn, this.m_Model.getColumnCount(), 0, this.getFixedRowCount());
            gc.setClipping(oldClipping);
            this.drawCells(gc, gc.getClipping(), 0, this.getFixedColumnCount(), 0, this.getFixedRowCount());
            this.drawBottomSpace(gc);
        } else {
            gc.fillRectangle(rect);
        }
    }

    private void setTopAreaClipping(GC gc, Rectangle oldClipping) {
        Rectangle contentClip = this.getClientArea();
        contentClip.x = 1;
        contentClip.y = 1;
        --contentClip.width;
        --contentClip.height;
        int i = 0;
        while (i < this.getFixedRowCount()) {
            int height = this.getCellRectIgnoreSpan((int)0, (int)i).height;
            contentClip.y += height + 1;
            contentClip.height -= height + 1;
            ++i;
        }
        contentClip.intersect(oldClipping);
        gc.setClipping(contentClip);
    }

    private void setLeftAreaClipping(GC gc, Rectangle oldClipping) {
        Rectangle contentClip = this.getClientArea();
        contentClip.x = 1;
        contentClip.y = 1;
        --contentClip.width;
        --contentClip.height;
        int i = 0;
        while (i < this.getFixedColumnCount()) {
            int width = this.getCellRectIgnoreSpan((int)i, (int)0).width;
            contentClip.x += width + 1;
            contentClip.width -= width + 1;
            ++i;
        }
        contentClip.intersect(oldClipping);
        gc.setClipping(contentClip);
    }

    private Rectangle setContentAreaClipping(GC gc) {
        Rectangle oldClipping = gc.getClipping();
        Rectangle contentClip = this.getClientArea();
        contentClip.x = 1;
        contentClip.y = 1;
        --contentClip.width;
        --contentClip.height;
        int i = 0;
        while (i < this.getFixedColumnCount()) {
            int width = this.getCellRectIgnoreSpan((int)i, (int)0).width;
            contentClip.x += width + 1;
            contentClip.width -= width + 1;
            ++i;
        }
        i = 0;
        while (i < this.getFixedRowCount()) {
            int height = this.getCellRectIgnoreSpan((int)0, (int)i).height;
            contentClip.y += height + 1;
            contentClip.height -= height + 1;
            ++i;
        }
        contentClip.intersect(oldClipping);
        gc.setClipping(contentClip);
        return oldClipping;
    }

    protected void drawBottomSpace(GC gc) {
        Rectangle r = this.getClientArea();
        if (this.m_Model.getRowCount() > 0) {
            r.y = this.getFixedHeight();
            int i = 0;
            while (i < this.m_RowsVisible) {
                r.y += this.m_Model.getRowHeight(i + this.m_TopRow);
                ++i;
            }
        }
        int lastColRight = this.getColumnRight(Math.min(this.m_LeftColumn + this.m_ColumnsVisible, this.m_Model.getColumnCount() - 1));
        if ((this.getStyle() & 0x40000) != 0) {
            --lastColRight;
            int lastCol = this.m_Model.getColumnCount() - 1;
            int ystart = 1;
            int row = 0;
            while (row < this.getFixedRowCount()) {
                Point last = this.getValidCell(lastCol, row);
                KTableCellRenderer fixedRenderer = this.m_Model.getCellRenderer(last.x, last.y);
                int rowheight = this.m_Model.getRowHeight(row);
                fixedRenderer.drawCell(gc, new Rectangle(lastColRight + 2, ystart, r.width - 1, rowheight - 1), -1, -1, "", false, true, false, this.m_Model);
                ystart += rowheight;
                ++row;
            }
            TextCellRenderer defaultRenderer = new TextCellRenderer(0);
            int row2 = this.m_TopRow;
            while (row2 < this.m_TopRow + this.m_RowsVisible + 1) {
                int rowHeight = this.m_Model.getRowHeight(row2);
                defaultRenderer.drawCell(gc, new Rectangle(lastColRight + 2, ystart, r.width - 1, rowHeight - 1), -1, -1, "", false, false, false, this.m_Model);
                ystart += rowHeight;
                ++row2;
            }
            gc.setBackground(this.getBackground());
            gc.fillRectangle(r);
            Rectangle clientArea = this.getClientArea();
            gc.setForeground(this.m_Display.getSystemColor(25));
            gc.drawLine(1, r.y, clientArea.x + clientArea.width - 1, r.y);
            gc.drawLine(clientArea.x + clientArea.width - 1, 0, clientArea.x + clientArea.width - 1, r.y - 1);
            this.drawBorderLines(gc, clientArea);
        } else if ((this.getStyle() & 0x20000) != 0) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(r);
            Rectangle clientArea = this.getClientArea();
            gc.setForeground(this.m_Display.getSystemColor(1));
            gc.drawLine(1, r.y, clientArea.x + clientArea.width - 1, r.y);
            if (this.m_LeftColumn + this.m_ColumnsVisible == this.m_Model.getColumnCount()) {
                gc.drawLine(clientArea.x + clientArea.width - 1, 0, clientArea.x + clientArea.width - 1, r.y - 1);
            }
            this.drawBorderLines(gc, clientArea);
        } else {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(r);
            gc.fillRectangle(lastColRight + 2, 0, r.width, r.height);
            gc.setForeground(this.m_Display.getSystemColor(1));
            gc.drawLine(1, r.y, lastColRight + 1, r.y);
            gc.drawLine(lastColRight + 1, 0, lastColRight + 1, r.y - 1);
            this.drawBorderLines(gc, r);
        }
    }

    private void drawBorderLines(GC gc, Rectangle clientArea) {
        if (this.m_Model.getRowCount() > 0) {
            gc.setForeground(this.m_ColorTopBorder);
            gc.drawLine(0, 0, clientArea.x + clientArea.width, 0);
            gc.setForeground(this.m_ColorLeftBorder);
            gc.drawLine(0, 0, 0, clientArea.y + clientArea.height - 1);
            if (this.m_LeftColumn + this.m_ColumnsVisible == this.m_Model.getColumnCount()) {
                gc.setForeground(this.m_ColorRightBorder);
                gc.drawLine(clientArea.x + clientArea.width - 1, 0, clientArea.x + clientArea.width - 1, clientArea.y + clientArea.height);
            }
        }
    }

    public void redraw(Rectangle cellsToRedraw) {
        this.checkWidget();
        this.redraw(cellsToRedraw.x, cellsToRedraw.y, cellsToRedraw.width, cellsToRedraw.height);
    }

    public void redraw(int firstCol, int firstRow, int numOfCols, int numOfRows) {
        this.checkWidget();
        boolean redrawFixedRows = false;
        if (firstRow < this.getFixedRowCount()) {
            firstRow = this.m_TopRow;
            redrawFixedRows = true;
        }
        boolean redrawFixedCols = false;
        if (firstCol < this.getFixedColumnCount()) {
            firstCol = this.m_LeftColumn;
            redrawFixedCols = true;
        }
        Rectangle clipRect = this.getClientArea();
        GC gc = new GC((Drawable)this);
        Rectangle oldClip = this.setContentAreaClipping(gc);
        this.drawCells(gc, clipRect, firstCol, Math.min(firstCol + numOfCols, this.m_Model.getColumnCount()), firstRow, Math.min(firstRow + numOfRows, this.m_Model.getRowCount()));
        gc.setClipping(oldClip);
        if (redrawFixedRows) {
            this.drawCells(gc, gc.getClipping(), this.m_LeftColumn, this.m_Model.getColumnCount(), 0, this.getFixedRowCount());
        }
        if (redrawFixedCols) {
            this.drawCells(gc, gc.getClipping(), 0, this.getFixedColumnCount(), this.m_TopRow, this.m_TopRow + this.m_RowsVisible);
        }
        if (redrawFixedCols || redrawFixedRows) {
            this.drawCells(gc, gc.getClipping(), 0, this.getFixedColumnCount(), 0, this.getFixedRowCount());
            this.drawBottomSpace(gc);
        }
        gc.dispose();
    }

    protected void drawCells(GC gc, Rectangle clipRect, int fromCol, int toCol, int fromRow, int toRow) {
        if (this.m_CellEditor != null) {
            if (!this.isCellVisible(this.m_CellEditor.m_Col, this.m_CellEditor.m_Row)) {
                Rectangle hide = new Rectangle(-101, -101, 100, 100);
                this.m_CellEditor.setCellRect(hide);
            } else {
                this.m_CellEditor.setCellRect(this.getCellRect(this.m_CellEditor.m_Col, this.m_CellEditor.m_Row));
            }
        }
        int fromCol_X = this.getCellRectIgnoreSpan((int)fromCol, (int)fromRow).x;
        int row = fromRow;
        while (row < toRow) {
            Rectangle r = this.getCellRectIgnoreSpan(fromCol, row, fromCol_X);
            if (r.y > clipRect.y + clipRect.height) break;
            int right_border_x = r.x;
            int col = fromCol;
            while (col < toCol) {
                r = this.getCellRect(col, row, right_border_x);
                right_border_x += this.getColumnWidth(col);
                if (r.x > clipRect.x + clipRect.width) break;
                if (r.y > clipRect.y + clipRect.height) {
                    return;
                }
                Point valid = this.getValidCell(col, row);
                if (valid != null && (valid.x != col || valid.y != row)) {
                    if (valid.x < col && col - 1 < this.m_LeftColumn && col > this.getFixedColumnCount() || valid.y < row && row - 1 < this.m_TopRow && row > this.getFixedRowCount()) {
                        this.drawCell(gc, valid.x, valid.y);
                    }
                } else if (this.canDrawCell(r, clipRect)) {
                    this.drawCell(gc, col, row, r);
                }
                ++col;
            }
            ++row;
        }
    }

    public Point getValidCell(int colToCheck, int rowToCheck) {
        this.checkWidget();
        Point found = new Point(colToCheck, rowToCheck);
        if (colToCheck >= this.m_Model.getColumnCount() || rowToCheck >= this.m_Model.getRowCount() || colToCheck < 0 || rowToCheck < 0) {
            return found;
        }
        Point lastFound = null;
        while (!found.equals(lastFound)) {
            lastFound = found;
            found = this.m_Model.belongsToCell(found.x, found.y);
            if (found != null && (found.x > lastFound.x || found.y > lastFound.y)) {
                throw new IllegalArgumentException("When spanning over several cells, supercells that determine the content of the large cell must always be in the left upper corner!");
            }
            if (found != null) continue;
            return lastFound;
        }
        return found;
    }

    protected void drawCell(GC gc, int col, int row) {
        this.drawCell(gc, col, row, this.getCellRect(col, row));
        Rectangle oldClip = gc.getClipping();
        gc.setClipping(this.getClientArea());
        if ((this.getStyle() & Integer.MIN_VALUE) == Integer.MIN_VALUE && row >= this.m_TopRow) {
            int i = 0;
            while (i < this.m_Model.getFixedHeaderColumnCount()) {
                this.drawCell(gc, i, row, this.getCellRect(i, row));
                ++i;
            }
            i = 0;
            while (i < this.m_Model.getFixedHeaderRowCount()) {
                this.drawCell(gc, col, i, this.getCellRect(col, i));
                ++i;
            }
        }
        gc.setClipping(oldClip);
    }

    protected void drawCell(GC gc, int col, int row, Rectangle rect) {
        if (row < 0 || row >= this.m_Model.getRowCount()) {
            return;
        }
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Rectangle oldClip = gc.getClipping();
        Rectangle newClip = new Rectangle(rect.x, rect.y, rect.width + 1, rect.height + 1);
        newClip.intersect(oldClip);
        gc.setClipping(newClip);
        Point validClickedCell = this.getValidCell(this.m_ClickColumnIndex, this.m_ClickRowIndex);
        this.m_Model.getCellRenderer(col, row).drawCell(gc, rect, col, row, this.m_Model.getContentAt(col, row), this.showAsSelected(col, row) || this.highlightSelectedRowCol(col, row), this.isHeaderCell(col, row), col == validClickedCell.x && row == validClickedCell.y, this.m_Model);
        gc.setClipping(oldClip);
    }

    public void updateCell(int col, int row) {
        this.checkWidget();
        if (row < 0 || row >= this.m_Model.getRowCount() || col < 0 || col >= this.m_Model.getColumnCount()) {
            return;
        }
        Point valid = this.getValidCell(col, row);
        GC gc = new GC((Drawable)this);
        this.drawCell(gc, valid.x, valid.y);
        gc.dispose();
    }

    public boolean isFixedCell(int col, int row) {
        return col < this.getFixedColumnCount() || row < this.getFixedRowCount();
    }

    public boolean isHeaderCell(int col, int row) {
        return col < this.m_Model.getFixedHeaderColumnCount() || row < this.m_Model.getFixedHeaderRowCount();
    }

    protected boolean showAsSelected(int col, int row) {
        if (this.m_CellEditor != null && col == this.m_CellEditor.m_Col && row == this.m_CellEditor.m_Row && this.m_CellEditor.getControl() != null) {
            return false;
        }
        return this.isCellSelected(col, row) && (this.isFocusControl() || this.isShowSelectionWithoutFocus());
    }

    protected void drawRow(GC gc, int row) {
        this.drawCells(gc, this.getClientArea(), 0, this.getFixedColumnCount(), row, row + 1);
        this.drawCells(gc, this.getClientArea(), this.m_LeftColumn, this.m_Model.getColumnCount(), row, row + 1);
    }

    protected void drawCol(GC gc, int col) {
        if (col < this.getFixedColumnCount()) {
            this.drawCells(gc, this.getClientArea(), col, col + 1, 0, this.m_TopRow + this.m_RowsVisible);
        } else {
            this.drawCells(gc, this.getClientArea(), col, col + 1, 0, this.getFixedRowCount());
            Rectangle oldClip = this.setContentAreaClipping(gc);
            this.drawCells(gc, gc.getClipping(), col, col + 1, this.m_TopRow, this.m_TopRow + this.m_RowsVisible);
            gc.setClipping(oldClip);
        }
    }

    public void setDefaultCursor(Cursor cursor, Point size_below_hotspot) {
        this.checkWidget();
        if (this.m_defaultCursor != null) {
            this.m_defaultCursor.dispose();
        }
        this.m_defaultCursor = cursor;
        this.m_defaultCursorSize = size_below_hotspot;
        this.setCursor(cursor);
    }

    public void setDefaultRowResizeCursor(Cursor cursor) {
        this.checkWidget();
        if (this.m_defaultRowResizeCursor != null) {
            this.m_defaultRowResizeCursor.dispose();
        }
        this.m_defaultRowResizeCursor = cursor;
    }

    public void setDefaultColumnResizeCursor(Cursor cursor) {
        this.checkWidget();
        if (this.m_defaultColumnResizeCursor != null) {
            this.m_defaultColumnResizeCursor.dispose();
        }
        this.m_defaultColumnResizeCursor = cursor;
    }

    private int getHeaderHeight() {
        int height = 1;
        int i = 0;
        while (i < this.m_Model.getFixedHeaderRowCount()) {
            height += this.m_Model.getRowHeight(i);
            ++i;
        }
        return height;
    }

    protected int getColumnForResize(int x, int y) {
        if (this.m_Model == null || y <= 0 || y > this.getClientArea().y + this.getClientArea().height || y >= this.getHeaderHeight() & (this.getStyle() & 0x10000000) == 0) {
            return -1;
        }
        if (x < this.getFixedWidth() + this.m_ResizeAreaSize / 2) {
            int i = 0;
            while (i < this.getFixedColumnCount()) {
                if (Math.abs(x - this.getColumnRight(i)) < this.m_ResizeAreaSize / 2) {
                    if (this.m_Model.isColumnResizable(i)) {
                        return i;
                    }
                    return -1;
                }
                ++i;
            }
        }
        int left = this.getColumnLeft(this.m_LeftColumn);
        int i = this.m_LeftColumn;
        while (i < this.m_LeftColumn + this.m_ColumnsVisible + 1 && i < this.m_Model.getColumnCount()) {
            if (i >= this.m_Model.getColumnCount()) {
                return -1;
            }
            int right = left + this.getColumnWidth(i);
            if (Math.abs(x - right) < this.m_ResizeAreaSize / 2) {
                if (this.m_Model.isColumnResizable(i)) {
                    return i;
                }
                return -1;
            }
            if (x >= left + this.m_ResizeAreaSize / 2 && x <= right - this.m_ResizeAreaSize / 2) break;
            left = right;
            ++i;
        }
        return -1;
    }

    protected int getRowForResize(int x, int y) {
        if (this.m_Model == null || x <= 0 || x >= this.getHeaderWidth()) {
            return -1;
        }
        if (y < this.m_Model.getRowHeight(0) + this.m_ResizeAreaSize / 2) {
            if (Math.abs(this.m_Model.getRowHeight(0) - y) < this.m_ResizeAreaSize / 2 && this.m_Model.isRowResizable(0)) {
                return 0;
            }
            return -1;
        }
        int row = this.getRowForY(y);
        int row_y = this.getYforRow(row);
        int next_row_y = this.getYforRow(row + 1);
        if (Math.abs(y - next_row_y) < this.m_ResizeAreaSize / 2 && this.m_Model.isRowResizable(row)) {
            return row;
        }
        if (Math.abs(y - row_y) < this.m_ResizeAreaSize / 2 && this.m_Model.isRowResizable(row - 1)) {
            return row - 1;
        }
        return -1;
    }

    public Point calcColumnNum(int x, int y) {
        if (this.m_Model == null) {
            return new Point(-1, -1);
        }
        Point toFind = new Point(x, y);
        Point valid = this.getValidCell(this.m_LeftColumn, this.m_TopRow);
        Point found = this.checkIfMatchesInColumns(0, this.getFixedRowCount(), 0, this.getFixedColumnCount(), toFind, true);
        if (found != null) {
            return found;
        }
        found = this.checkIfMatchesInColumns(valid.y, this.m_TopRow + this.m_RowsVisible, 0, this.getFixedColumnCount(), toFind, true);
        if (found != null) {
            return found;
        }
        found = this.checkIfMatchesInColumns(0, this.getFixedRowCount(), valid.x, this.m_LeftColumn + this.m_ColumnsVisible, toFind, true);
        if (found != null) {
            return found;
        }
        found = this.checkIfMatchesInColumns(valid.y, this.m_TopRow + this.m_RowsVisible, valid.x, this.m_LeftColumn + this.m_ColumnsVisible, toFind, true);
        if (found != null) {
            return found;
        }
        return new Point(-1, -1);
    }

    protected Point calcNonSpanColumnNum(int x, int y) {
        if (this.m_Model == null) {
            return new Point(-1, -1);
        }
        Point toFind = new Point(x, y);
        Point valid = new Point(this.m_LeftColumn, this.m_TopRow);
        Point found = this.checkIfMatchesInColumns(0, this.getFixedRowCount(), 0, this.getFixedColumnCount(), toFind, false);
        if (found != null) {
            return found;
        }
        found = this.checkIfMatchesInColumns(valid.y, this.m_TopRow + this.m_RowsVisible, 0, this.getFixedColumnCount(), toFind, false);
        if (found != null) {
            return found;
        }
        found = this.checkIfMatchesInColumns(0, this.getFixedRowCount(), valid.x, this.m_LeftColumn + this.m_ColumnsVisible, toFind, false);
        if (found != null) {
            return found;
        }
        found = this.checkIfMatchesInColumns(valid.y, this.m_TopRow + this.m_RowsVisible, valid.x, this.m_LeftColumn + this.m_ColumnsVisible, toFind, false);
        if (found != null) {
            return found;
        }
        return new Point(-1, -1);
    }

    protected Point checkIfMatchesInColumns(int startRow, int endRow, int startCol, int endCol, Point toFind, boolean span) {
        int row = startRow;
        while (row < endRow) {
            int col = startCol;
            while (col < endCol) {
                Rectangle rect = this.getCellRectIgnoreSpan(col, row);
                ++rect.width;
                ++rect.height;
                if (rect.contains(toFind)) {
                    if (span) {
                        return this.getValidCell(col, row);
                    }
                    return new Point(col, row);
                }
                ++col;
            }
            ++row;
        }
        return null;
    }

    public boolean isCellVisible(int col, int row) {
        this.checkWidget();
        if (this.m_Model == null) {
            return false;
        }
        return (col >= this.m_LeftColumn && col < this.m_LeftColumn + this.m_ColumnsVisible || col < this.getFixedColumnCount()) && (row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsVisible || row < this.getFixedRowCount());
    }

    public boolean isCellFullyVisible(int col, int row) {
        this.checkWidget();
        if (this.m_Model == null) {
            return false;
        }
        return (col >= this.m_LeftColumn && col < this.m_LeftColumn + this.m_ColumnsFullyVisible || col < this.getFixedColumnCount()) && (row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsFullyVisible || row < this.getFixedRowCount());
    }

    public boolean isRowVisible(int row) {
        this.checkWidget();
        if (this.m_Model == null) {
            return false;
        }
        return row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsVisible || row < this.getFixedRowCount();
    }

    public boolean isRowFullyVisible(int row) {
        this.checkWidget();
        if (this.m_Model == null) {
            return false;
        }
        return row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsFullyVisible || row < this.getFixedRowCount();
    }

    /*
     * Unable to fully structure code
     */
    protected void focusCell(int col, int row, int stateMask) {
        block54: {
            block52: {
                block56: {
                    block57: {
                        block55: {
                            block53: {
                                orig = new Point(col, row);
                                valid = this.getValidCell(col, row);
                                if (valid != null) {
                                    col = valid.x;
                                    row = valid.y;
                                }
                                gc = new GC((Drawable)this);
                                this.closeCellEditor();
                                if (row < this.m_Model.getFixedHeaderRowCount() || col < this.m_Model.getFixedHeaderColumnCount() && !this.isRowSelectMode()) break block52;
                                if ((stateMask & 262144) != 0 || (stateMask & 131072) != 0) break block53;
                                redrawAll = this.m_Selection.size() > 1;
                                oldFocusRow = this.m_FocusRow;
                                oldFocusCol = this.m_FocusCol;
                                this.clearSelectionWithoutRedraw();
                                this.addToSelectionWithoutRedraw(col, row);
                                this.m_FocusRow = row;
                                this.m_FocusCol = col;
                                this.m_MainFocusRow = row;
                                this.m_MainFocusCol = col;
                                if (redrawAll) {
                                    this.redraw();
                                } else if (this.isRowSelectMode()) {
                                    if (oldFocusRow >= 0) {
                                        this.drawRow(gc, oldFocusRow);
                                    }
                                    this.drawRow(gc, this.m_FocusRow);
                                } else {
                                    origClipping = null;
                                    if (!this.isFixedCell(oldFocusCol, oldFocusRow)) {
                                        origClipping = this.setContentAreaClipping(gc);
                                    }
                                    if (oldFocusCol >= 0 && oldFocusRow >= 0) {
                                        this.drawCell(gc, oldFocusCol, oldFocusRow);
                                    }
                                    if (origClipping != null) {
                                        gc.setClipping(origClipping);
                                    }
                                    if (!this.isFixedCell(this.m_FocusCol, this.m_FocusRow)) {
                                        origClipping = this.setContentAreaClipping(gc);
                                    }
                                    this.drawCell(gc, this.m_FocusCol, this.m_FocusRow);
                                }
                                this.fireCellSelection(orig.x, orig.y, stateMask);
                                break block54;
                            }
                            if ((stateMask & 262144) == 0) break block55;
                            success = this.toggleSelection(col, row);
                            if (success) {
                                this.m_FocusCol = col;
                                this.m_FocusRow = row;
                            }
                            if (this.isRowSelectMode()) {
                                this.drawRow(gc, row);
                            } else {
                                this.drawCell(gc, col, row);
                            }
                            if (success) {
                                this.fireCellSelection(this.m_FocusCol, this.m_FocusRow, stateMask);
                            }
                            break block54;
                        }
                        if ((stateMask & 131072) == 0) break block54;
                        if (!this.isMultiSelectMode()) {
                            if (this.isRowSelectMode()) {
                                this.drawRow(gc, row);
                            } else {
                                this.drawCell(gc, col, row);
                            }
                            return;
                        }
                        if (!this.isRowSelectMode()) break block56;
                        oldSelection = new HashMap<K, V>(this.m_Selection);
                        if (row >= this.m_FocusRow) ** GOTO lbl68
                        while (row != this.m_FocusRow) {
                            this.addToSelectionWithoutRedraw(0, --this.m_FocusRow);
                        }
                        break block57;
lbl-1000:
                        // 1 sources

                        {
                            this.addToSelectionWithoutRedraw(0, ++this.m_FocusRow);
lbl68:
                            // 2 sources

                            ** while (row != this.m_FocusRow)
                        }
                    }
                    if (!oldSelection.equals(this.m_Selection)) {
                        oldSelection.putAll(this.m_Selection);
                        rowIt = oldSelection.values().iterator();
                        min = 0;
                        max = 0;
                        if (rowIt.hasNext()) {
                            max = min = ((Integer)rowIt.next()).intValue();
                        }
                        while (rowIt.hasNext()) {
                            r = (Integer)rowIt.next();
                            if (r < min) {
                                min = r;
                            }
                            if (r <= max) continue;
                            max = r;
                        }
                        this.redraw(0, min, this.m_Model.getColumnCount(), max - min + 1);
                        this.fireCellSelection(orig.x, orig.y, stateMask);
                    }
                    break block54;
                }
                sel = this.getCellSelection();
                min = new Point(0x7FFFFFFF, 0x7FFFFFFF);
                max = new Point(-1, -1);
                containsCell = false;
                i = 0;
                while (i < sel.length) {
                    if (sel[i].x > max.x) {
                        max.x = sel[i].x;
                    }
                    if (sel[i].y > max.y) {
                        max.y = sel[i].y;
                    }
                    if (sel[i].x < min.x) {
                        min.x = sel[i].x;
                    }
                    if (sel[i].y < min.y) {
                        min.y = sel[i].y;
                    }
                    if (!containsCell && sel[i].x == col && sel[i].y == row) {
                        containsCell = true;
                    }
                    ++i;
                }
                if (col < this.m_MainFocusCol && max.x > this.m_MainFocusCol) {
                    min.x = col;
                    max.x = this.m_MainFocusCol;
                } else if (col > this.m_MainFocusCol && min.x < this.m_MainFocusCol) {
                    min.x = this.m_MainFocusCol;
                    max.x = col;
                }
                if (row < this.m_MainFocusRow && max.y > this.m_MainFocusRow) {
                    min.y = row;
                    max.y = this.m_MainFocusRow;
                } else if (row > this.m_MainFocusRow && min.y < this.m_MainFocusRow) {
                    min.y = this.m_MainFocusRow;
                    max.y = row;
                }
                oldSelection = new HashMap<K, V>(this.m_Selection);
                if (containsCell) {
                    this.clearSelectionWithoutRedraw();
                    if (max.x == this.m_FocusCol) {
                        max.x = col;
                    }
                    if (max.y == this.m_FocusRow) {
                        max.y = row;
                    }
                    if (min.x == this.m_FocusCol) {
                        min.x = col;
                    }
                    if (min.y == this.m_FocusRow) {
                        min.y = row;
                    }
                    r = min.y;
                    while (r <= max.y) {
                        c = min.x;
                        while (c <= max.x) {
                            this.addToSelectionWithoutRedraw(c, r);
                            ++c;
                        }
                        ++r;
                    }
                    if (!oldSelection.equals(this.m_Selection)) {
                        this.redraw();
                        this.fireCellSelection(orig.x, orig.y, stateMask);
                    }
                } else {
                    if (col > max.x) {
                        max.x = col;
                    }
                    if (row > max.y) {
                        max.y = row;
                    }
                    if (col < min.x) {
                        min.x = col;
                    }
                    if (row < min.y) {
                        min.y = row;
                    }
                    r = min.y;
                    while (r <= max.y) {
                        c = min.x;
                        while (c <= max.x) {
                            this.addToSelectionWithoutRedraw(c, r);
                            ++c;
                        }
                        ++r;
                    }
                    if (this.isMultiSelectMode() && this.isHighlightSelectionInHeader()) {
                        this.redraw(-1, row, 1, 1);
                        this.redraw(col, -1, 1, 1);
                    }
                    if (!oldSelection.equals(this.m_Selection)) {
                        this.redraw(min.x, min.y, max.x - min.x + 1, max.y - min.y + 1);
                        this.fireCellSelection(orig.x, orig.y, stateMask);
                    }
                }
                this.m_FocusRow = row;
                this.m_FocusCol = col;
                break block54;
            }
            this.drawCell(gc, col, row);
            this.fireFixedCellSelection(orig.x, orig.y, stateMask);
        }
        gc.dispose();
    }

    public void closeCellEditor() {
        if (this.m_CellEditor != null) {
            this.m_CellEditor.close(true);
        }
    }

    protected void onMouseDown(MouseEvent e) {
        Point spanCell = this.getCellForCoordinates(e.x, e.y);
        Rectangle spanCellRect = this.getCellRect(spanCell.x, spanCell.y);
        if (this.fireCellClicked(spanCell.x, spanCell.y, spanCellRect, e.x, e.y, e.button)) {
            this.m_ClickColumnIndex = spanCell.x;
            this.m_ClickRowIndex = spanCell.y;
            this.closeCellEditor();
            this.redraw();
            return;
        }
        if (e.button == 1) {
            this.setCapture(true);
            this.m_Capture = true;
            int columnIndex = this.getColumnForResize(e.x, e.y);
            if (columnIndex >= 0) {
                this.m_ResizeColumnIndex = columnIndex;
                this.m_ResizeColumnLeft = this.getColumnLeft(columnIndex);
                return;
            }
            int rowIndex = this.getRowForResize(e.x, e.y);
            if (rowIndex >= 0) {
                this.m_ResizeRowIndex = rowIndex;
                this.m_ResizeRowTop = this.getYforRow(rowIndex);
                return;
            }
        }
        if (e.button == 1 || this.isMultiSelectMode() && !this.clickInSelectedCells(new Point(e.x, e.y))) {
            Point cell = this.calcNonSpanColumnNum(e.x, e.y);
            if (cell.x == -1 || cell.y == -1) {
                this.closeCellEditor();
                return;
            }
            this.m_ClickColumnIndex = cell.x;
            this.m_ClickRowIndex = cell.y;
            this.focusCell(cell.x, cell.y, e.stateMask);
        }
    }

    protected boolean clickInSelectedCells(Point click) {
        Point[] selection = this.getCellSelection();
        if (selection == null || selection.length < 0) {
            return false;
        }
        int i = 0;
        while (i < selection.length) {
            if (this.getCellRect(selection[i].x, selection[i].y).contains(click)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void onMouseMove(MouseEvent e) {
        int newSize;
        Rectangle rect;
        if (this.m_Model == null) {
            return;
        }
        this.checkCursorToDisplay(e.x, e.y);
        if (e.stateMask == 524288 && this.m_CellEditor == null && this.m_ResizeColumnIndex == -1 && this.m_ClickColumnIndex != -1 && this.isMultiSelectMode()) {
            Point cell = this.calcNonSpanColumnNum(e.x, e.y);
            if (cell.x == -1 || cell.y == -1) {
                return;
            }
            if (cell.y >= this.m_Model.getFixedHeaderRowCount() && cell.x >= this.m_Model.getFixedHeaderColumnCount() && (cell.x != this.m_ClickColumnIndex || cell.y != this.m_ClickRowIndex)) {
                this.m_ClickColumnIndex = cell.x;
                this.m_ClickRowIndex = cell.y;
                this.focusCell(cell.x, cell.y, e.stateMask | 0x20000);
            }
        }
        if (this.m_ResizeColumnIndex != -1) {
            rect = this.getClientArea();
            if (e.x > rect.x + rect.width - 1) {
                e.x = rect.x + rect.width - 1;
            }
            if ((newSize = e.x - this.m_ResizeColumnLeft) < 5) {
                newSize = 5;
            }
            this.m_Model.setColumnWidth(this.m_ResizeColumnIndex, newSize);
            this.fireColumnResize(this.m_ResizeColumnIndex, this.m_Model.getColumnWidth(this.m_ResizeColumnIndex));
            this.redraw();
        }
        if (this.m_ResizeRowIndex != -1) {
            rect = this.getClientArea();
            if (e.y > rect.y + rect.height - 1) {
                e.y = rect.y + rect.height - 1;
            }
            if ((newSize = e.y - this.m_ResizeRowTop) < this.m_Model.getRowHeightMinimum()) {
                newSize = this.m_Model.getRowHeightMinimum();
            }
            this.m_Model.setRowHeight(this.m_ResizeRowIndex, newSize);
            this.fireRowResize(this.m_ResizeRowIndex, newSize);
            this.redraw();
        }
    }

    private void checkCursorToDisplay(int x, int y) {
        if (this.m_ResizeColumnIndex != -1 || this.getColumnForResize(x, y) >= 0) {
            if (this.m_defaultColumnResizeCursor == null) {
                this.setCursor(new Cursor((Device)this.m_Display, 9));
            } else {
                this.setCursor(this.m_defaultColumnResizeCursor);
            }
        } else if (this.m_ResizeRowIndex != -1 || this.getRowForResize(x, y) >= 0) {
            if (this.m_defaultRowResizeCursor == null) {
                this.setCursor(new Cursor((Device)this.m_Display, 7));
            } else {
                this.setCursor(this.m_defaultRowResizeCursor);
            }
        } else if (this.m_CursorProvider != null) {
            Point cell = this.getCellForCoordinates(x, y);
            Cursor cursor = this.m_CursorProvider.getCursor(cell.x, cell.y, x, y);
            if (cursor == null) {
                this.setCursor(this.m_defaultCursor);
            } else {
                this.setCursor(cursor);
            }
        } else {
            this.setCursor(this.m_defaultCursor);
        }
    }

    protected void onMouseUp(MouseEvent e) {
        if (this.m_Model == null) {
            return;
        }
        this.setCapture(false);
        this.m_Capture = false;
        if (this.m_ResizeColumnIndex != -1 || this.m_ResizeRowIndex != -1) {
            this.m_ResizeColumnIndex = -1;
            this.m_ResizeRowIndex = -1;
            this.checkCursorToDisplay(e.x, e.y);
            this.redraw();
        } else if (e.count == 1) {
            Point click = new Point(e.x, e.y);
            Point cell = this.getCellForCoordinates(e.x, e.y);
            if (cell.x >= 0 && cell.y >= 0 && cell.x < this.m_Model.getColumnCount() && cell.y < this.m_Model.getRowCount()) {
                if (this.isHeaderCell(cell.x, cell.y)) {
                    KTableCellEditor editor = this.m_Model.getCellEditor(cell.x, cell.y);
                    if (editor != null && (editor.getActivationSignals() & 4) != 0 && editor.isApplicable(4, this, cell.x, cell.y, click, null, e.stateMask)) {
                        int oldFocusCol = this.m_FocusCol;
                        int oldFocusRow = this.m_FocusRow;
                        this.m_FocusCol = cell.x;
                        this.m_FocusRow = cell.y;
                        this.openEditorInFocus();
                        this.m_FocusCol = oldFocusCol;
                        this.m_FocusRow = oldFocusRow;
                    }
                } else if (this.m_FocusCol >= 0 && this.m_FocusRow >= 0) {
                    KTableCellEditor editor = this.m_Model.getCellEditor(this.m_FocusCol, this.m_FocusRow);
                    Rectangle rect = this.getCellRect(this.m_FocusCol, this.m_FocusRow);
                    if (editor != null && rect.contains(click) && (editor.getActivationSignals() & 4) != 0 && editor.isApplicable(4, this, this.m_FocusCol, this.m_FocusRow, click, null, e.stateMask)) {
                        this.openEditorInFocus();
                    }
                }
            }
        }
    }

    public Point getCellForCoordinates(int x, int y) {
        int width;
        Point cell = new Point(-1, -1);
        cell.y = this.getRowForY(y);
        int colSum = 0;
        int i = 0;
        while (i < this.getFixedColumnCount()) {
            width = this.m_Model.getColumnWidth(i);
            if (colSum <= x && colSum + width > x) {
                cell.x = i;
                return this.getValidCell(cell.x, cell.y);
            }
            colSum += width;
            ++i;
        }
        i = this.m_LeftColumn;
        while (i < this.m_Model.getColumnCount()) {
            width = this.m_Model.getColumnWidth(i);
            if (colSum <= x && colSum + width > x) {
                cell.x = i;
                return this.getValidCell(cell.x, cell.y);
            }
            colSum += width;
            ++i;
        }
        if (x >= colSum && x < this.getClientArea().x + this.getClientArea().width && (this.getStyle() & 0x20000) != 0) {
            cell.x = this.m_Model.getColumnCount() - 1;
        }
        return this.getValidCell(cell.x, cell.y);
    }

    protected void onKeyDown(KeyEvent e) {
        Point old;
        Object current;
        KTableCellEditor editor;
        boolean focusChanged = false;
        int newFocusRow = this.m_FocusRow;
        int newFocusCol = this.m_FocusCol;
        if (this.m_Model == null) {
            return;
        }
        if ((e.character == ' ' || e.character == '\r') && (editor = this.m_Model.getCellEditor(this.m_FocusCol, this.m_FocusRow)) != null && (editor.getActivationSignals() & 0x10) != 0 && editor.isApplicable(16, this, this.m_FocusCol, this.m_FocusRow, null, String.valueOf(e.character), e.stateMask)) {
            this.openEditorInFocus();
            return;
        }
        if (e.keyCode == 0x1000007) {
            newFocusCol = this.m_Model.getFixedHeaderColumnCount();
            if (newFocusRow == -1) {
                newFocusRow = this.m_Model.getFixedHeaderRowCount();
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000008) {
            newFocusCol = this.m_Model.getColumnCount() - 1;
            if (newFocusRow == -1) {
                newFocusRow = this.m_Model.getFixedHeaderRowCount();
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000003 || e.keyCode == 9 && (e.stateMask & 0x20000) != 0) {
            if (!this.isRowSelectMode()) {
                if (newFocusCol > this.m_Model.getFixedHeaderColumnCount()) {
                    Point newPt;
                    current = this.m_Model.belongsToCell(this.m_FocusCol, this.m_FocusRow);
                    if (current == null) {
                        current = new Point(this.m_FocusCol, this.m_FocusRow);
                    }
                    if ((newPt = this.m_Model.belongsToCell(current.x - 1, current.y)) == null) {
                        newPt = new Point(current.x - 1, current.y);
                    }
                    newFocusCol = newPt.x;
                    newFocusRow = newPt.y;
                } else if (newFocusCol == this.m_Model.getFixedHeaderColumnCount() && newFocusRow >= this.m_Model.getFixedHeaderRowCount() && e.keyCode == 9) {
                    newFocusCol = this.m_Model.getColumnCount() - 1;
                    --newFocusRow;
                }
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000004 || e.keyCode == 9 && (e.stateMask & 0x20000) == 0) {
            if (!this.isRowSelectMode()) {
                if (newFocusCol == -1) {
                    newFocusCol = this.m_Model.getFixedHeaderColumnCount();
                    newFocusRow = this.m_Model.getFixedHeaderRowCount();
                } else if (newFocusCol == this.m_Model.getColumnCount() - 1 && newFocusRow == this.m_Model.getRowCount() - 1) {
                    current = this;
                    boolean newFocusSet = false;
                    while (current.getParent() != null && !newFocusSet) {
                        Composite parent = current.getParent();
                        int i = 0;
                        while (i < parent.getTabList().length) {
                            if (parent.getTabList()[i] == current && i < parent.getTabList().length - 1) {
                                Control newFocus = parent.getTabList()[i + 1];
                                while (newFocus instanceof Composite && ((Composite)newFocus).getTabList() != null && ((Composite)newFocus).getTabList().length > 0) {
                                    newFocus = ((Composite)newFocus).getTabList()[0];
                                }
                                this.setSelection(new Point[0], false);
                                newFocus.setFocus();
                                newFocusSet = true;
                            }
                            ++i;
                        }
                        current = parent;
                    }
                } else if (newFocusCol < this.m_Model.getColumnCount() - 1) {
                    Point next;
                    old = new Point(this.m_FocusCol, this.m_FocusRow);
                    if ((next = this.m_Model.belongsToCell(++newFocusCol, newFocusRow)) == null) {
                        next = new Point(newFocusCol, newFocusRow);
                    }
                    while (next.equals((Object)old) && newFocusCol < this.m_Model.getColumnCount() - 1) {
                        if ((next = this.m_Model.belongsToCell(++newFocusCol, newFocusRow)) != null) continue;
                        next = new Point(newFocusCol, newFocusRow);
                    }
                    newFocusCol = next.x;
                } else if (this.m_FocusCol == this.m_Model.getColumnCount() - 1 && this.m_FocusRow != this.m_Model.getRowCount() - 1 && e.keyCode == 9) {
                    newFocusCol = this.m_Model.getFixedHeaderColumnCount();
                    ++newFocusRow;
                }
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000002) {
            if (newFocusRow == -1) {
                newFocusRow = this.m_Model.getFixedHeaderRowCount();
                newFocusCol = this.m_Model.getFixedHeaderColumnCount();
            } else if (newFocusRow < this.m_Model.getRowCount() - 1) {
                Point next;
                old = new Point(this.m_FocusCol, this.m_FocusRow);
                if ((next = this.m_Model.belongsToCell(newFocusCol, ++newFocusRow)) == null) {
                    next = new Point(newFocusCol, newFocusRow);
                }
                while (next.equals((Object)old)) {
                    if ((next = this.m_Model.belongsToCell(newFocusCol, ++newFocusRow)) != null) continue;
                    next = new Point(newFocusCol, newFocusRow);
                }
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000001) {
            if (newFocusRow > this.m_Model.getFixedHeaderRowCount()) {
                current = this.m_Model.belongsToCell(this.m_FocusCol, this.m_FocusRow);
                if (current == null) {
                    current = new Point(this.m_FocusCol, this.m_FocusRow);
                }
                newFocusCol = current.x;
                newFocusRow = current.y - 1;
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000006) {
            if ((newFocusRow += this.m_RowsVisible - 1) >= this.m_Model.getRowCount()) {
                newFocusRow = this.m_Model.getRowCount() - 1;
            }
            if (newFocusCol == -1) {
                newFocusCol = this.m_Model.getFixedHeaderColumnCount();
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000005) {
            if ((newFocusRow -= this.m_RowsVisible - 1) < this.m_Model.getFixedHeaderRowCount()) {
                newFocusRow = this.m_Model.getFixedHeaderRowCount();
            }
            if (newFocusCol == -1) {
                newFocusCol = this.m_Model.getFixedHeaderColumnCount();
            }
            focusChanged = true;
        } else if (this.isEditOnKeyEvent()) {
            if (e.keyCode == 127 || e.keyCode == 8) {
                editor = this.m_Model.getCellEditor(this.m_FocusCol, this.m_FocusRow);
                if (editor != null && (editor.getActivationSignals() & 8) != 0 && editor.isApplicable(8, this, this.m_FocusCol, this.m_FocusRow, null, String.valueOf(e.character), e.stateMask)) {
                    this.openEditorInFocus();
                    if (this.m_CellEditor != null) {
                        this.m_CellEditor.setContent("");
                    }
                }
                return;
            }
            if ((Character.isLetterOrDigit(e.character) || e.keyCode > 32 && e.keyCode < 254 && e.keyCode != 127) && e.keyCode != 262144 && e.keyCode != 65536 && (e.stateMask & 0x40000) == 0 && (e.stateMask & 0x10000) == 0 && (editor = this.m_Model.getCellEditor(this.m_FocusCol, this.m_FocusRow)) != null && (editor.getActivationSignals() & 8) != 0 && editor.isApplicable(8, this, this.m_FocusCol, this.m_FocusRow, null, String.valueOf(e.character), e.stateMask)) {
                this.openEditorInFocus();
                if (this.m_CellEditor != null) {
                    this.m_CellEditor.setContent(String.valueOf(e.character));
                }
                return;
            }
        }
        if (focusChanged) {
            Point valid = this.m_Model.belongsToCell(newFocusCol, newFocusRow);
            if (valid != null) {
                newFocusCol = valid.x;
                newFocusRow = valid.y;
            }
            this.focusCell(newFocusCol, newFocusRow, e.stateMask);
            if (!this.isCellFullyVisible(this.m_FocusCol, this.m_FocusRow)) {
                this.scrollToFocus();
            }
        }
    }

    protected void onMouseDoubleClick(MouseEvent e) {
        if (this.m_Model == null) {
            return;
        }
        if (e.button == 1) {
            if (e.y > 0 && e.y < this.getHeaderHeight() || (this.getStyle() & 0x10000000) != 0) {
                int columnIndex = this.getColumnForResize(e.x, e.y);
                this.m_ResizeColumnIndex = -1;
                if (this.resizeColumnOptimal(columnIndex) != -1) {
                    return;
                }
            }
            if (e.y < this.getHeaderHeight()) {
                Point cell = this.getCellForCoordinates(e.x, e.y);
                this.checkCursorToDisplay(e.x, e.y);
                this.fireFixedCellDoubleClicked(cell.x, cell.y, e.stateMask);
                return;
            }
            Point click = new Point(e.x, e.y);
            Point cell = this.getCellForCoordinates(e.x, e.y);
            if (this.isHeaderCell(cell.x, cell.y)) {
                KTableCellEditor editor = this.m_Model.getCellEditor(cell.x, cell.y);
                if (editor != null && (editor.getActivationSignals() & 2) != 0 && editor.isApplicable(2, this, cell.x, cell.y, click, null, e.stateMask)) {
                    int oldFocusCol = this.m_FocusCol;
                    int oldFocusRow = this.m_FocusRow;
                    this.m_FocusCol = cell.x;
                    this.m_FocusRow = cell.y;
                    this.openEditorInFocus();
                    this.m_FocusCol = oldFocusCol;
                    this.m_FocusRow = oldFocusRow;
                }
                this.fireFixedCellDoubleClicked(cell.x, cell.y, e.stateMask);
            } else if (this.m_FocusCol >= 0 && this.m_FocusRow >= 0) {
                KTableCellEditor editor = this.m_Model.getCellEditor(this.m_FocusCol, this.m_FocusRow);
                Rectangle rect = this.getCellRect(this.m_FocusCol, this.m_FocusRow);
                if (editor != null && rect.contains(click) && (editor.getActivationSignals() & 2) != 0 && editor.isApplicable(2, this, this.m_FocusCol, this.m_FocusRow, click, null, e.stateMask)) {
                    this.openEditorInFocus();
                }
                this.fireCellDoubleClicked(cell.x, cell.y, e.stateMask);
            }
        }
    }

    public void setToolTipText(String tooltip) {
        this.m_nativTooltip = tooltip;
    }

    public String getToolTipText() {
        return this.m_nativTooltip;
    }

    public int resizeColumnOptimal(int column) {
        this.checkWidget();
        if (column >= 0 && column < this.m_Model.getColumnCount()) {
            int width;
            Point valid;
            int optWidth = 5;
            GC gc = new GC((Drawable)this);
            int i = 0;
            while (i < this.m_Model.getFixedHeaderRowCount()) {
                valid = this.getValidCell(column, i);
                if (valid.x == column && valid.y == i && (width = this.m_Model.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.m_Model.getContentAt(column, i), true, this.m_Model)) > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            i = Math.max(0, this.m_TopRow - 50);
            while (i < Math.min(this.m_TopRow + this.m_RowsVisible + 50, this.m_Model.getRowCount())) {
                valid = this.getValidCell(column, i);
                if (valid.x == column && valid.y == i && (width = this.m_Model.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.m_Model.getContentAt(column, i), true, this.m_Model)) > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            gc.dispose();
            this.m_Model.setColumnWidth(column, optWidth);
            this.redraw();
            return optWidth;
        }
        return -1;
    }

    public void openEditorInFocus() {
        this.checkWidget();
        this.m_CellEditor = this.m_Model.getCellEditor(this.m_FocusCol, this.m_FocusRow);
        if (this.m_CellEditor != null) {
            this.scrollToFocus();
            Rectangle r = this.getCellRect(this.m_FocusCol, this.m_FocusRow);
            this.m_CellEditor.open(this, this.m_FocusCol, this.m_FocusRow, r);
        }
    }

    public boolean isEditorOpen(int col, int row) {
        Point valid = this.getValidCell(col, row);
        return this.m_CellEditor != null && this.m_CellEditor.m_Col == valid.x && this.m_CellEditor.m_Row == valid.y;
    }

    public void scroll(int col, int row) {
        if (col < 0 || col >= this.m_Model.getColumnCount() || row < 0 || row >= this.m_Model.getRowCount()) {
            return;
        }
        this.m_TopRow = row;
        this.m_LeftColumn = col;
        this.redraw();
    }

    protected void scrollToFocus() {
        if (this.m_FocusCol < 0 || this.m_FocusRow < 0 || this.m_FocusCol >= this.m_Model.getColumnCount() || this.m_FocusRow >= this.m_Model.getRowCount()) {
            return;
        }
        boolean change = false;
        if (this.getVerticalBar() != null) {
            if (this.m_FocusRow < this.m_TopRow && this.m_FocusRow >= this.getFixedRowCount()) {
                this.m_TopRow = this.m_FocusRow;
                change = true;
            }
            if (this.m_FocusRow >= this.m_TopRow + this.m_RowsFullyVisible) {
                this.m_TopRow = Math.min(this.m_Model.getRowCount() - 1, this.m_FocusRow - this.m_RowsFullyVisible + 1);
                change = true;
            }
        }
        if (this.getHorizontalBar() != null) {
            if (this.m_FocusCol < this.m_LeftColumn && this.m_FocusCol >= this.getFixedColumnCount()) {
                this.m_LeftColumn = this.m_FocusCol;
                change = true;
            }
            if (this.m_FocusCol >= this.m_LeftColumn + this.m_ColumnsFullyVisible) {
                int oldLeftCol = this.m_LeftColumn;
                Rectangle rect = this.getClientArea();
                int leftColX = this.getColumnLeft(this.m_FocusCol);
                int focusCellWidth = this.getCellRect((int)this.m_FocusCol, (int)this.m_FocusRow).width;
                while (this.m_LeftColumn < this.m_FocusCol && this.m_LeftColumn < this.m_Model.getColumnCount() && (leftColX < 0 || leftColX + focusCellWidth > rect.width + rect.x)) {
                    ++this.m_LeftColumn;
                    leftColX = this.getColumnLeft(this.m_FocusCol);
                }
                change |= oldLeftCol != this.m_LeftColumn;
            }
        }
        if (change) {
            this.redraw();
        }
    }

    protected void fireCellSelection(int col, int row, int statemask) {
        Point validCell = this.getValidCell(col, row);
        int i = 0;
        while (i < this.cellSelectionListeners.size()) {
            ((KTableCellSelectionListener)this.cellSelectionListeners.get(i)).cellSelected(validCell.x, validCell.y, statemask);
            ++i;
        }
    }

    protected boolean fireCellClicked(int col, int row, Rectangle cellRect, int x, int y, int button) {
        if (col < 0 || row < 0 || col >= this.m_Model.getColumnCount() || row >= this.m_Model.getRowCount()) {
            return false;
        }
        Point validCell = this.getValidCell(col, row);
        int i = 0;
        while (i < this.cellClickListeners.size()) {
            if (((KTableClickInterceptionListener)this.cellClickListeners.get(i)).cellClicked(validCell.x, validCell.y, cellRect, x, y, button, this)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void fireCellDoubleClicked(int col, int row, int statemask) {
        Point validCell = this.getValidCell(col, row);
        int i = 0;
        while (i < this.cellDoubleClickListeners.size()) {
            ((KTableCellDoubleClickListener)this.cellDoubleClickListeners.get(i)).cellDoubleClicked(validCell.x, validCell.y, statemask);
            ++i;
        }
    }

    protected void fireFixedCellDoubleClicked(int col, int row, int statemask) {
        Point validCell = this.getValidCell(col, row);
        int i = 0;
        while (i < this.cellDoubleClickListeners.size()) {
            ((KTableCellDoubleClickListener)this.cellDoubleClickListeners.get(i)).fixedCellDoubleClicked(validCell.x, validCell.y, statemask);
            ++i;
        }
    }

    protected void fireFixedCellSelection(int col, int row, int statemask) {
        Point validCell = this.getValidCell(col, row);
        int i = 0;
        while (i < this.cellSelectionListeners.size()) {
            ((KTableCellSelectionListener)this.cellSelectionListeners.get(i)).fixedCellSelected(validCell.x, validCell.y, statemask);
            ++i;
        }
    }

    protected void fireColumnResize(int col, int newSize) {
        int i = 0;
        while (i < this.cellResizeListeners.size()) {
            ((KTableCellResizeListener)this.cellResizeListeners.get(i)).columnResized(col, newSize);
            ++i;
        }
    }

    protected void fireRowResize(int row, int newSize) {
        int i = 0;
        while (i < this.cellResizeListeners.size()) {
            ((KTableCellResizeListener)this.cellResizeListeners.get(i)).rowResized(row, newSize);
            ++i;
        }
    }

    public void addCellSelectionListener(KTableCellSelectionListener listener) {
        this.cellSelectionListeners.add(listener);
    }

    public void addCellResizeListener(KTableCellResizeListener listener) {
        this.cellResizeListeners.add(listener);
    }

    public void addCellDoubleClickListener(KTableCellDoubleClickListener listener) {
        this.cellDoubleClickListeners.add(listener);
    }

    public void addClickInterceptionListener(KTableClickInterceptionListener listener) {
        this.cellClickListeners.add(listener);
    }

    public boolean removeCellSelectionListener(KTableCellSelectionListener listener) {
        return this.cellSelectionListeners.remove(listener);
    }

    public boolean removeCellResizeListener(KTableCellResizeListener listener) {
        return this.cellResizeListeners.remove(listener);
    }

    public boolean removeDoubleClickListener(KTableCellDoubleClickListener listener) {
        return this.cellDoubleClickListeners.remove(listener);
    }

    public boolean removeClickInterceptionListener(KTableClickInterceptionListener listener) {
        return this.cellClickListeners.remove(listener);
    }

    public boolean isRowSelectMode() {
        return (this.getStyle() & 0x10000) == 65536;
    }

    public boolean isMultiSelectMode() {
        return (this.getStyle() & 2) == 2;
    }

    protected boolean isShowSelectionWithoutFocus() {
        return (this.getStyle() & 0x8000) != 32768;
    }

    protected boolean isHighlightSelectionInHeader() {
        return (this.getStyle() & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    protected boolean isEditOnKeyEvent() {
        return (this.getStyle() & 0x40000000) == 0x40000000;
    }

    protected void clearSelectionWithoutRedraw() {
        this.m_Selection.clear();
    }

    public void clearSelection() {
        this.checkWidget();
        this.clearSelectionWithoutRedraw();
        this.m_FocusCol = -1;
        this.m_FocusRow = -1;
        if (this.isMultiSelectMode()) {
            this.redraw();
        }
    }

    protected boolean toggleSelection(int col, int row) {
        if (this.isMultiSelectMode()) {
            Integer o = this.isRowSelectMode() ? new Integer(row) : new Point(col, row);
            if (this.m_Selection.get(o) != null) {
                this.m_Selection.remove(o);
                return false;
            }
            this.m_Selection.put(o, o);
            return true;
        }
        return false;
    }

    protected void addToSelectionWithoutRedraw(int col, int row) {
        if (this.isMultiSelectMode()) {
            if (this.isRowSelectMode()) {
                Integer o = new Integer(row);
                this.m_Selection.put(o, o);
            } else {
                Point o = new Point(col, row);
                this.m_Selection.put(o, o);
            }
        }
    }

    public void setSelection(int col, int row, boolean scroll) {
        this.checkWidget();
        if (col < this.m_Model.getColumnCount() && col >= this.m_Model.getFixedHeaderColumnCount() && row < this.m_Model.getRowCount() && row >= this.m_Model.getFixedHeaderRowCount()) {
            this.focusCell(col, row, 0);
            if (scroll) {
                this.scrollToFocus();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSelection(Point[] selections, boolean scroll) {
        this.checkWidget();
        if (selections == null || selections.length < 1) {
            this.clearSelection();
            return;
        }
        if (this.isMultiSelectMode()) {
            try {
                this.setRedraw(false);
                int i = 0;
                while (i < selections.length) {
                    int col = selections[i].x;
                    int row = selections[i].y;
                    if (col < this.m_Model.getColumnCount() && col >= this.m_Model.getFixedHeaderColumnCount() && row < this.m_Model.getRowCount() && row >= this.m_Model.getFixedHeaderRowCount()) {
                        if (i == 0) {
                            this.focusCell(col, row, 262144);
                        } else {
                            this.addToSelectionWithoutRedraw(col, row);
                        }
                    }
                    ++i;
                }
                if (!scroll) return;
                this.scrollToFocus();
                return;
            }
            finally {
                this.setRedraw(true);
            }
        } else {
            this.setSelection(selections[0].x, selections[0].y, scroll);
        }
    }

    public boolean isCellSelected(int col, int row) {
        this.checkWidget();
        Point v = this.getValidCell(col, row);
        col = v.x;
        row = v.y;
        if (!this.isMultiSelectMode()) {
            if (this.isRowSelectMode()) {
                return row == this.m_FocusRow;
            }
            return col == this.m_FocusCol && row == this.m_FocusRow;
        }
        if (this.isRowSelectMode()) {
            return this.m_Selection.get(new Integer(row)) != null;
        }
        return this.m_Selection.get(new Point(col, row)) != null;
    }

    public boolean isRowSelected(int row) {
        return this.m_Selection.get(new Integer(row)) != null;
    }

    public int[] getRowSelection() {
        this.checkWidget();
        if (!this.isRowSelectMode()) {
            return null;
        }
        if (!this.isMultiSelectMode()) {
            if (this.m_FocusRow < 0) {
                return new int[0];
            }
            int[] tmp = new int[]{this.m_FocusRow};
            return tmp;
        }
        Object[] ints = this.m_Selection.values().toArray();
        int[] erg = new int[ints.length];
        int i = 0;
        while (i < erg.length) {
            erg[i] = (Integer)ints[i];
            ++i;
        }
        return erg;
    }

    public Point[] getCellSelection() {
        this.checkWidget();
        if (this.isRowSelectMode()) {
            return null;
        }
        if (!this.isMultiSelectMode()) {
            if (this.m_FocusRow < 0 || this.m_FocusCol < 0) {
                return new Point[0];
            }
            Point[] tmp = new Point[]{new Point(this.m_FocusCol, this.m_FocusRow)};
            return tmp;
        }
        return this.m_Selection.values().toArray(new Point[0]);
    }

    public Rectangle getVisibleCells() {
        return new Rectangle(this.m_LeftColumn, this.m_TopRow, this.m_ColumnsVisible, this.m_RowsVisible);
    }

    private boolean highlightSelectedRowCol(int col, int row) {
        if (!this.isHighlightSelectionInHeader() || !this.isHeaderCell(col, row)) {
            return false;
        }
        Point[] sel = this.getCellSelection();
        if (sel != null) {
            int i = 0;
            while (i < sel.length) {
                if (sel[i].x == col || sel[i].y == row) {
                    return true;
                }
                Point valid = this.getValidCell(sel[i].x, row);
                if (valid.x == col) {
                    return true;
                }
                valid = this.getValidCell(col, sel[i].y);
                if (valid.y == row) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setModel(KTableModel model) {
        this.checkWidget();
        this.m_Model = model;
        this.m_FocusCol = -1;
        this.m_FocusRow = -1;
        this.clearSelectionWithoutRedraw();
        if ((this.getStyle() & 0x700) == 1792) {
            this.updateScrollbarVisibility();
        }
        this.redraw();
    }

    public KTableModel getModel() {
        return this.m_Model;
    }

    protected int getFixedColumnCount() {
        return this.m_Model.getFixedHeaderColumnCount() + this.m_Model.getFixedSelectableColumnCount();
    }

    protected int getFixedRowCount() {
        return this.m_Model.getFixedHeaderRowCount() + this.m_Model.getFixedSelectableRowCount();
    }

    protected void updateScrollbarVisibility() {
        try {
            boolean horVisible;
            KTableModel model = this.getModel();
            Rectangle actualSize = this.getClientArea();
            boolean showVertBar = false;
            int theoreticalHeight = 1;
            int i = 0;
            while (i < model.getRowCount()) {
                if ((theoreticalHeight += model.getRowHeight(i)) > actualSize.height) {
                    showVertBar = true;
                    break;
                }
                ++i;
            }
            this.getVerticalBar().setVisible(showVertBar);
            int theoreticalWidth = 0;
            int i2 = 0;
            while (i2 < model.getColumnCount()) {
                theoreticalWidth += model.getColumnWidth(i2);
                ++i2;
            }
            boolean bl = horVisible = actualSize.width < theoreticalWidth;
            if (this.getHorizontalBar().isVisible() != horVisible) {
                this.getHorizontalBar().setVisible(horVisible);
                if (!horVisible) {
                    this.getHorizontalBar().setSelection(0);
                    this.m_LeftColumn = 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getColumnWidth(int col) {
        if (col == this.m_Model.getColumnCount() - 1 && (this.getStyle() & 0x20000) != 0) {
            Rectangle cl = this.getClientArea();
            int remaining = cl.x + cl.width - 2 - this.getColumnLeft(col);
            return Math.max(remaining, this.m_Model.getColumnWidth(col));
        }
        return this.m_Model.getColumnWidth(col);
    }

    public int getStyle() {
        return this.m_Style;
    }

    public void setStyle(int style) {
        this.m_Style = style;
    }

    public Color getColorTopBorder() {
        return this.m_ColorTopBorder;
    }

    public Color getColorLeftBorder() {
        return this.m_ColorLeftBorder;
    }

    public Color getColorRightBorder() {
        return this.m_ColorRightBorder;
    }

    public void setColorTopBorder(Color colorTopBorder) {
        this.m_ColorTopBorder = colorTopBorder;
    }

    public void setColorLeftBorder(Color colorLeftBorder) {
        this.m_ColorLeftBorder = colorLeftBorder;
    }

    public void setColorRightBorder(Color colorRightBorder) {
        this.m_ColorRightBorder = colorRightBorder;
    }

    public void setCursorProvider(KTableCursorProvider cursorProvider) {
        this.m_CursorProvider = cursorProvider;
    }

    public int getNumRowsVisibleInPreferredSize() {
        return this.m_numRowsVisibleInPreferredSize;
    }

    public int getNumColsVisibleInPreferredSize() {
        return this.m_numColsVisibleInPreferredSize;
    }

    public void setNumRowsVisibleInPreferredSize(int numRowsVisibleInPreferredSize) {
        this.m_numRowsVisibleInPreferredSize = numRowsVisibleInPreferredSize;
    }

    public void setNumColsVisibleInPreferredSize(int numColsVisibleInPreferredSize) {
        this.m_numColsVisibleInPreferredSize = numColsVisibleInPreferredSize;
    }

    public int getPreferredSizeDefaultRowHeight() {
        return this.m_preferredSizeDefaultRowHeight;
    }

    public void setPreferredSizeDefaultRowHeight(int preferredSizeDefaultRowHeight) {
        this.m_preferredSizeDefaultRowHeight = preferredSizeDefaultRowHeight;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height = 1;
        int width = 1;
        if (this.m_Model != null) {
            int i = 0;
            while (i < this.m_Model.getFixedHeaderRowCount()) {
                height += this.m_Model.getRowHeight(i);
                ++i;
            }
            int rowsVisible = 0;
            int i2 = this.m_Model.getFixedHeaderRowCount();
            while (i2 < this.m_Model.getFixedHeaderRowCount() + this.m_numRowsVisibleInPreferredSize && i2 < this.m_Model.getRowCount()) {
                height += this.m_Model.getRowHeight(i2);
                ++rowsVisible;
                ++i2;
            }
            i2 = rowsVisible;
            while (i2 < this.m_numRowsVisibleInPreferredSize) {
                height += this.m_preferredSizeDefaultRowHeight;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_Model.getFixedHeaderColumnCount()) {
                width += this.m_Model.getColumnWidth(i2);
                ++i2;
            }
            i2 = this.m_Model.getFixedHeaderColumnCount();
            while (i2 < this.m_Model.getFixedHeaderColumnCount() + this.m_numColsVisibleInPreferredSize && i2 < this.m_Model.getColumnCount()) {
                width += this.m_Model.getColumnWidth(this.m_Model.getFixedHeaderColumnCount());
                ++i2;
            }
        }
        if (this.getHorizontalBar() != null) {
            height += this.getHorizontalBar().getSize().y;
        }
        if (this.getVerticalBar() != null) {
            width += this.getVerticalBar().getSize().x;
        }
        return new Point(width, height);
    }

    class TooltipListener
    implements Listener {
        Shell tip = null;
        Label label = null;
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = KTable.this;
                        e.button = event.button;
                        e.stateMask = event.stateMask;
                        KTable.this.notifyListeners(3, e);
                    }
                }
                shell.dispose();
            }
        };

        TooltipListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 12: 
                case 13: {
                    if (this.tip == null) break;
                    this.tip.dispose();
                    this.tip = null;
                    this.label = null;
                    break;
                }
                case 32: {
                    if (this.tip != null && !this.tip.isDisposed()) {
                        this.tip.dispose();
                    }
                    Point cell = KTable.this.getCellForCoordinates(event.x, event.y);
                    String tooltip = null;
                    if (cell.x >= 0 && cell.x < KTable.this.m_Model.getColumnCount() && cell.y >= 0 && cell.y < KTable.this.m_Model.getRowCount()) {
                        tooltip = KTable.this.m_Model.getTooltipAt(cell.x, cell.y);
                    }
                    if ((tooltip == null || tooltip.equals("")) && (KTable.this.m_nativTooltip == null || KTable.this.m_nativTooltip.equals("")) || cell == null || cell.x == -1 || cell.y == -1) {
                        this.tip = null;
                        this.label = null;
                        return;
                    }
                    this.tip = new Shell(KTable.this.getShell(), 16384);
                    GridLayout gl = new GridLayout();
                    gl.marginWidth = 2;
                    gl.marginHeight = 2;
                    this.tip.setLayout((Layout)gl);
                    this.tip.setBackground(KTable.this.getDisplay().getSystemColor(29));
                    this.label = new Label((Composite)this.tip, 0);
                    this.label.setLayoutData((Object)new GridData(1808));
                    this.label.setForeground(KTable.this.getDisplay().getSystemColor(28));
                    this.label.setBackground(KTable.this.getDisplay().getSystemColor(29));
                    if (tooltip != null && !tooltip.equals("")) {
                        this.label.setText(tooltip);
                    } else {
                        this.label.setText(KTable.this.m_nativTooltip);
                    }
                    this.label.addListener(7, this.labelListener);
                    this.label.addListener(3, this.labelListener);
                    this.label.addListener(5, this.labelListener);
                    Point size = this.tip.computeSize(-1, -1);
                    int y = 20;
                    int x = 0;
                    if (KTable.this.m_defaultCursorSize != null && KTable.this.m_defaultCursorSize.x >= 0 && KTable.this.m_defaultCursorSize.y >= 0) {
                        y = KTable.this.m_defaultCursorSize.y + 1;
                        x = -KTable.this.m_defaultCursorSize.x;
                    }
                    Rectangle tableBounds = KTable.this.getBounds();
                    if (event.x + x + size.x > tableBounds.x + tableBounds.width) {
                        event.x -= event.x + x + size.x - tableBounds.x - tableBounds.width;
                    }
                    if (event.y + y + size.y > tableBounds.y + tableBounds.height) {
                        event.y -= event.y + y + size.y - tableBounds.y - tableBounds.height;
                    }
                    Point pt = KTable.this.toDisplay(event.x + x, event.y + y);
                    this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                    this.tip.setVisible(true);
                }
            }
        }
    }
}

