/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable;

import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellSelectionListener;
import de.kupzog.ktable.KTableModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class KTableActionHandler {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    public KTableCopyAction m_CopyAction;
    public KTableCopyAllAction m_CopyAllAction;
    public KTableCutAction m_CutAction;
    public KTablePasteAction m_PasteAction;
    public KTableSelectAllAction m_SelectAllAction;
    protected KTable m_table;
    protected MenuManager m_contextMenuManager;

    public KTableActionHandler(KTable table) {
        this.m_table = table;
        this.createActions();
        this.registerActionUpdater();
        this.m_contextMenuManager = new MenuManager("#PopupMenu");
        this.m_contextMenuManager.setRemoveAllWhenShown(true);
        this.m_contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                KTableActionHandler.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.m_contextMenuManager.createContextMenu((Control)this.m_table);
        this.m_table.setMenu(menu);
    }

    public MenuManager getMenuManager() {
        return this.m_contextMenuManager;
    }

    protected void createActions() {
        this.m_CopyAction = new KTableCopyAction();
        this.m_CopyAllAction = new KTableCopyAllAction();
        this.m_PasteAction = new KTablePasteAction();
        this.m_CutAction = new KTableCutAction();
        this.m_SelectAllAction = new KTableSelectAllAction();
    }

    protected void fillContextMenu(IMenuManager menumanager) {
        menumanager.add((IAction)this.m_CopyAction);
        menumanager.add((IAction)this.m_CutAction);
        menumanager.add((IAction)this.m_PasteAction);
        menumanager.add((IContributionItem)new Separator());
        menumanager.add((IAction)this.m_CopyAllAction);
        menumanager.add((IAction)this.m_SelectAllAction);
        menumanager.add((IContributionItem)new Separator());
        menumanager.add((IContributionItem)new Separator("additions"));
    }

    public void registerGlobalActions(IActionBars actionBar) {
        actionBar.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.m_CutAction);
        actionBar.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.m_CopyAction);
        actionBar.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.m_PasteAction);
        actionBar.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.m_SelectAllAction);
        actionBar.updateActionBars();
    }

    protected void setClipboardContent(Point[] selection) throws SWTError {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        HTMLTransfer htmlTransfer = HTMLTransfer.getInstance();
        String plainText = this.getTextForSelection(selection);
        String htmlText = this.getHTMLForSelection(selection);
        Clipboard clipboard = new Clipboard(this.m_table.getDisplay());
        try {
            try {
                clipboard.setContents((Object[])new String[]{plainText, htmlText}, new Transfer[]{plainTextTransfer, htmlTransfer});
            }
            catch (SWTError error) {
                if (error.code != 2002) {
                    throw error;
                }
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    private Point[] findTableDimensions(Point[] selection) {
        Point topLeft = new Point(-1, -1);
        Point bottomRight = new Point(-1, -1);
        int i = 0;
        while (i < selection.length) {
            Point cell = selection[i];
            if (topLeft.x < 0) {
                topLeft.x = cell.x;
            } else if (topLeft.x > cell.x) {
                topLeft.x = cell.x;
            }
            if (bottomRight.x < 0) {
                bottomRight.x = cell.x;
            } else if (bottomRight.x < cell.x) {
                bottomRight.x = cell.x;
            }
            if (topLeft.y < 0) {
                topLeft.y = cell.y;
            } else if (topLeft.y > cell.y) {
                topLeft.y = cell.y;
            }
            if (bottomRight.y < 0) {
                bottomRight.y = cell.y;
            } else if (bottomRight.y < cell.y) {
                bottomRight.y = cell.y;
            }
            ++i;
        }
        return new Point[]{topLeft, bottomRight};
    }

    private Point findCellSpanning(int col, int row, KTableModel model) {
        Point spanning = new Point(1, 1);
        Point cell = new Point(col, row);
        while (model.belongsToCell(col + spanning.x, row).equals((Object)cell)) {
            ++spanning.x;
        }
        while (model.belongsToCell(col, row + spanning.y).equals((Object)cell)) {
            ++spanning.y;
        }
        return spanning;
    }

    protected String getHTMLForSelection(Point[] selection) {
        StringBuffer html = new StringBuffer();
        this.sortSelectedCells(selection);
        Point[] dimensions = this.findTableDimensions(selection);
        Point topLeft = dimensions[0];
        Point bottomRight = dimensions[1];
        KTableModel model = this.m_table.getModel();
        if (model == null) {
            return "";
        }
        html.append("Version:1.0\n");
        html.append("StartHTML:0000000000\n");
        html.append("EndHTML:0000000000\n");
        html.append("StartFragment:0000000000\n");
        html.append("EndFragment:0000000000\n");
        html.append("<html><body><table>");
        Point nextValidCell = selection[0];
        int selCounter = 1;
        int row = topLeft.y;
        while (row <= bottomRight.y) {
            html.append("<tr>");
            int col = topLeft.x;
            while (col <= bottomRight.x) {
                if (model.belongsToCell(col, row).equals((Object)new Point(col, row))) {
                    if (nextValidCell.x == col && nextValidCell.y == row) {
                        html.append("<td");
                        Point spanning = this.findCellSpanning(col, row, model);
                        if (spanning.x > 1) {
                            html.append(" colspan=\"" + spanning.x + "\"");
                        }
                        if (spanning.y > 1) {
                            html.append(" rowspan=\"" + spanning.y + "\"");
                        }
                        html.append(">");
                        Object content = model.getContentAt(col, row);
                        html.append(this.maskHtmlChars(content.toString()));
                        if (selCounter < selection.length) {
                            nextValidCell = selection[selCounter];
                            ++selCounter;
                        }
                    } else {
                        html.append("<td>");
                    }
                    html.append("</td>");
                }
                ++col;
            }
            html.append("</tr>");
            ++row;
        }
        html.append("</table></body></html>");
        return html.toString();
    }

    private String maskHtmlChars(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("\ufffd", "&auml;");
        text = text.replaceAll("\ufffd", "&Auml;");
        text = text.replaceAll("\ufffd", "&ouml;");
        text = text.replaceAll("\ufffd", "&Ouml;");
        text = text.replaceAll("\ufffd", "&uuml;");
        text = text.replaceAll("\ufffd", "&Uuml;");
        text = text.replaceAll("\ufffd", "&szlig;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("<", "&lt");
        text = text.replaceAll(">", "&gt");
        text = text.replaceAll("\ufffd", "&euro;");
        return text;
    }

    /*
     * Unable to fully structure code
     */
    protected String getTextForSelection(Point[] selection) {
        text = new StringBuffer();
        topLeft = this.sortSelectedCells(selection);
        model = this.m_table.getModel();
        if (model == null) {
            return "";
        }
        currentCol = topLeft.x;
        i = 0;
        ** GOTO lbl27
        {
            text.append('\t');
            ++currentCol;
            do {
                if (currentCol < selection[i].x) continue block0;
                content = model.getContentAt(selection[i].x, selection[i].y);
                text.append(content.toString());
                if (i + 1 < selection.length) {
                    row = selection[i].y;
                    while (row < selection[i + 1].y) {
                        text.append(KTableActionHandler.PlatformLineDelimiter);
                        ++row;
                    }
                    if (selection[i].y != selection[i + 1].y) {
                        currentCol = topLeft.x;
                    }
                }
                ++i;
lbl27:
                // 2 sources

            } while (i < selection.length);
        }
        return text.toString();
    }

    protected Point sortSelectedCells(Point[] selection) {
        Arrays.sort(selection, new Comparator(){

            public int compare(Object o1, Object o2) {
                Point p1 = (Point)o1;
                Point p2 = (Point)o2;
                if (p1.y < p2.y) {
                    return -1;
                }
                if (p1.y > p2.y) {
                    return 1;
                }
                if (p1.x < p2.x) {
                    return -1;
                }
                if (p1.x > p2.x) {
                    return 1;
                }
                return 0;
            }
        });
        int minCol = selection[0].x;
        int i = 1;
        while (i < selection.length) {
            if (selection[i].x < minCol) {
                minCol = selection[i].x;
            }
            ++i;
        }
        return new Point(minCol, selection[0].y);
    }

    protected String getRTFForSelection(Point[] selection) {
        return this.getTextForSelection(selection);
    }

    protected void registerActionUpdater() {
        this.m_table.addCellSelectionListener(new KTableCellSelectionListener(){

            public void cellSelected(int col, int row, int statemask) {
                KTableActionHandler.this.updateActions();
            }

            public void fixedCellSelected(int col, int row, int statemask) {
                KTableActionHandler.this.updateActions();
            }
        });
    }

    protected void updateActions() {
        this.m_CopyAction.updateEnabledState();
        this.m_CopyAllAction.updateEnabledState();
        this.m_CutAction.updateEnabledState();
        this.m_PasteAction.updateEnabledState();
        this.m_SelectAllAction.updateEnabledState();
    }

    protected class KTableCopyAction
    extends Action {
        protected KTableCopyAction() {
            this.setId("KTableCopyActionHandler");
            this.setEnabled(false);
            this.setText("Kopieren");
        }

        public void run() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                KTableActionHandler.this.setClipboardContent(KTableActionHandler.this.m_table.getCellSelection());
            }
        }

        public void updateEnabledState() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                Point[] selection = KTableActionHandler.this.m_table.getCellSelection();
                this.setEnabled(selection != null && selection.length > 0);
            } else {
                this.setEnabled(false);
            }
        }
    }

    protected class KTableCopyAllAction
    extends Action {
        protected KTableCopyAllAction() {
            this.setId("KTableCopyAllActionHandler");
            this.setEnabled(false);
            this.setText("Ganze Tabelle kopieren");
        }

        public void run() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                KTableActionHandler.this.setClipboardContent(this.getAllTableCells());
            }
        }

        public void updateEnabledState() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        private Point[] getAllTableCells() {
            KTableModel model = KTableActionHandler.this.m_table.getModel();
            if (model == null) {
                return new Point[0];
            }
            Vector<Point> cells = new Vector<Point>(model.getColumnCount() * model.getRowCount());
            int row = 0;
            while (row < model.getRowCount()) {
                int col = 0;
                while (col < model.getColumnCount()) {
                    Point valid = model.belongsToCell(col, row);
                    if (valid.y == row && valid.x == col) {
                        cells.add(valid);
                    }
                    ++col;
                }
                ++row;
            }
            return cells.toArray(new Point[0]);
        }
    }

    protected class KTableCutAction
    extends Action {
        protected KTableCutAction() {
            this.setId("KTableCutActionHandler");
            this.setEnabled(false);
            this.setText("Ausschneiden");
        }

        public void run() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                Point[] selection = KTableActionHandler.this.m_table.getCellSelection();
                KTableActionHandler.this.setClipboardContent(selection);
                this.removeContentAt(selection);
            }
        }

        public void updateEnabledState() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                Point[] selection = KTableActionHandler.this.m_table.getCellSelection();
                this.setEnabled(selection != null && selection.length > 0);
            } else {
                this.setEnabled(false);
            }
        }

        protected void removeContentAt(Point[] selection) {
            KTableModel model = KTableActionHandler.this.m_table.getModel();
            if (model == null) {
                return;
            }
            boolean updateSeperateCells = selection.length <= 4;
            try {
                if (!updateSeperateCells) {
                    KTableActionHandler.this.m_table.setRedraw(false);
                }
                int i = 0;
                while (i < selection.length) {
                    model.setContentAt(selection[i].x, selection[i].y, "");
                    if (updateSeperateCells) {
                        KTableActionHandler.this.m_table.updateCell(selection[i].x, selection[i].y);
                    }
                    ++i;
                }
            }
            finally {
                if (!updateSeperateCells) {
                    KTableActionHandler.this.m_table.setRedraw(true);
                }
            }
        }
    }

    protected class KTablePasteAction
    extends Action {
        protected KTablePasteAction() {
            this.setId("KTablePasteActionHandler");
            this.setEnabled(false);
            this.setText("Einf\ufffdgen");
        }

        public void run() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                this.pasteToSelection(this.getTextFromClipboard(), KTableActionHandler.this.m_table.getCellSelection());
            }
        }

        protected String getTextFromClipboard() {
            Clipboard clipboard = new Clipboard(KTableActionHandler.this.m_table.getDisplay());
            try {
                String string = clipboard.getContents((Transfer)TextTransfer.getInstance()).toString();
                return string;
            }
            catch (Exception exception) {
                return "";
            }
            finally {
                clipboard.dispose();
            }
        }

        protected void pasteToSelection(String text, Point[] selection) {
            if (selection == null || selection.length == 0) {
                return;
            }
            KTableModel model = KTableActionHandler.this.m_table.getModel();
            if (model == null) {
                return;
            }
            try {
                KTableActionHandler.this.m_table.setRedraw(false);
                KTableActionHandler.this.m_table.setSelection(new Point[0], false);
                Vector<Point> sel = new Vector<Point>();
                String[][] cellTexts = this.parseCellTexts(text);
                int row = 0;
                while (row < cellTexts.length) {
                    int col = 0;
                    while (col < cellTexts[row].length) {
                        model.setContentAt(col + selection[0].x, row + selection[0].y, cellTexts[row][col]);
                        sel.add(new Point(col + selection[0].x, row + selection[0].y));
                        ++col;
                    }
                    ++row;
                }
                KTableActionHandler.this.m_table.setSelection(sel.toArray(new Point[0]), false);
            }
            finally {
                KTableActionHandler.this.m_table.setRedraw(true);
            }
        }

        protected String[][] parseCellTexts(String text) {
            if (!KTableActionHandler.this.m_table.isMultiSelectMode()) {
                return new String[][]{{text}};
            }
            String[] lines = text.split(PlatformLineDelimiter);
            String[][] cellText = new String[lines.length][];
            int line = 0;
            while (line < lines.length) {
                cellText[line] = lines[line].split("\t");
                ++line;
            }
            return cellText;
        }

        public void updateEnabledState() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed()) {
                Point[] selection = KTableActionHandler.this.m_table.getCellSelection();
                if (selection == null) {
                    this.setEnabled(false);
                } else if (selection.length > 1) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    protected class KTableSelectAllAction
    extends Action {
        protected KTableSelectAllAction() {
            this.setId("KTableSelectAllActionHandler");
            this.setEnabled(false);
            this.setText("Alles Markieren");
        }

        public void run() {
            KTableModel model;
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed() && (model = KTableActionHandler.this.m_table.getModel()) != null) {
                this.selectAll(model);
            }
        }

        public void updateEnabledState() {
            if (KTableActionHandler.this.m_table != null && !KTableActionHandler.this.m_table.isDisposed() && KTableActionHandler.this.m_table.isMultiSelectMode()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        protected void selectAll(KTableModel model) {
            Vector<Point> sel = new Vector<Point>();
            int row = model.getFixedHeaderRowCount();
            while (row < model.getRowCount()) {
                int col = model.getFixedHeaderColumnCount();
                while (col < model.getColumnCount()) {
                    Point cell = model.belongsToCell(col, row);
                    if (cell.x == col && cell.y == row) {
                        sel.add(cell);
                    }
                    ++col;
                }
                ++row;
            }
            try {
                KTableActionHandler.this.m_table.setRedraw(false);
                KTableActionHandler.this.m_table.setSelection(new Point[0], false);
                KTableActionHandler.this.m_table.setSelection(sel.toArray(new Point[0]), false);
            }
            finally {
                KTableActionHandler.this.m_table.setRedraw(true);
            }
        }
    }
}

