/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable;

import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableModel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public abstract class KTableCellEditor {
    protected KTableModel m_Model;
    protected KTable m_Table;
    protected Rectangle m_Rect;
    protected int m_Row;
    protected int m_Col;
    private Control m_Control;
    protected String m_toolTip;
    private Rectangle lastProvidedCellRect;
    public static final int DOUBLECLICK = 2;
    public static final int SINGLECLICK = 4;
    public static final int KEY_ANY = 8;
    public static final int KEY_RETURN_AND_SPACE = 16;

    public void dispose() {
        if (this.m_Control != null) {
            Control contr = this.m_Control;
            this.m_Control = null;
            contr.dispose();
        }
    }

    public void open(KTable table, int col, int row, Rectangle rect) {
        this.m_Table = table;
        this.m_Model = table.getModel();
        this.m_Rect = rect;
        this.m_Row = row;
        this.m_Col = col;
        if (this.m_Control == null) {
            this.m_Control = this.createControl();
            this.m_Control.setToolTipText(this.m_toolTip);
            this.m_Control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent arg0) {
                    if (KTableCellEditor.this.m_Control != null && !KTableCellEditor.this.m_Control.isDisposed()) {
                        KTableCellEditor.this.close(true);
                    }
                }
            });
            this.m_Control.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    KTableCellEditor.this.m_Table.setCursor(null);
                }
            });
        }
        this.setBounds(this.m_Rect);
        GC gc = new GC((Drawable)this.m_Table);
        this.m_Table.drawCell(gc, this.m_Col, this.m_Row);
        gc.dispose();
        this.m_Control.setFocus();
    }

    public void close(boolean save) {
        this.m_Table.m_CellEditor = null;
        GC gc = new GC((Drawable)this.m_Table);
        this.m_Table.drawCell(gc, this.m_Col, this.m_Row);
        gc.dispose();
        this.dispose();
        this.m_Table.setFocus();
    }

    public boolean isFocused() {
        if (this.m_Control == null) {
            return false;
        }
        return this.m_Control.isFocusControl();
    }

    public void setBounds(Rectangle rect) {
        if (this.m_Control != null) {
            this.m_Control.setBounds(rect);
        }
    }

    public Rectangle getBounds() {
        if (this.m_Control != null) {
            Rectangle b = this.m_Control.getBounds();
            return b;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    final void setCellRect(Rectangle rect) {
        if (this.lastProvidedCellRect == null || !this.lastProvidedCellRect.equals((Object)rect)) {
            this.setBounds(rect);
            this.lastProvidedCellRect = rect;
        }
    }

    protected abstract Control createControl();

    protected void onKeyPressed(KeyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) == 0) {
            this.close(true);
        } else if (e.character == '\u001b') {
            this.close(false);
        } else {
            this.m_Table.scrollToFocus();
        }
    }

    protected void onTraverse(TraverseEvent e) {
        switch (e.keyCode) {
            case 0x1000003: {
                this.close(true);
                this.m_Table.setSelection(this.m_Col - 1, this.m_Row, true);
                break;
            }
            case 0x1000004: {
                this.close(true);
                Point currentCell = new Point(this.m_Col, this.m_Row);
                int newCol = this.m_Col + 1;
                while (currentCell.equals((Object)this.m_Table.getValidCell(newCol, this.m_Row))) {
                    ++newCol;
                }
                this.m_Table.setSelection(newCol, this.m_Row, true);
                break;
            }
            case 0x1000001: {
                this.close(true);
                this.m_Table.setSelection(this.m_Col, this.m_Row - 1, true);
                break;
            }
            case 0x1000002: {
                this.close(true);
                Point currentCell = new Point(this.m_Col, this.m_Row);
                int newRow = this.m_Row + 1;
                while (currentCell.equals((Object)this.m_Table.getValidCell(this.m_Col, newRow))) {
                    ++newRow;
                }
                this.m_Table.setSelection(this.m_Col, newRow, true);
                break;
            }
            case 9: {
                this.close(true);
                if ((e.stateMask & 0x20000) != 0) {
                    this.m_Table.setSelection(this.m_Col - 1, this.m_Row, true);
                    break;
                }
                this.m_Table.setSelection(this.m_Col + 1, this.m_Row, true);
            }
        }
        this.m_Table.setFocus();
    }

    public void setToolTipText(String toolTip) {
        this.m_toolTip = toolTip;
    }

    public abstract void setContent(Object var1);

    public int getActivationSignals() {
        return 10;
    }

    public boolean isApplicable(int eventType, KTable table, int col, int row, Point clickLocation, String keyInput, int stateMask) {
        return true;
    }

    public Control getControl() {
        return this.m_Control;
    }
}

