/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable;

import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableModel;
import java.util.Hashtable;
import org.eclipse.swt.graphics.Point;

public abstract class KTableDefaultModel
implements KTableModel {
    protected Hashtable m_ColWidths = new Hashtable();
    private Hashtable m_RowHeights = new Hashtable();

    public void initialize() {
    }

    public int getColumnWidth(int col) {
        Integer width = (Integer)this.m_ColWidths.get(new Integer(col));
        if (width == null) {
            int initialW = this.getInitialColumnWidth(col);
            if (initialW < 0) {
                return 0;
            }
            return initialW;
        }
        return width;
    }

    public abstract int getInitialColumnWidth(int var1);

    public int getRowHeight(int row) {
        Integer height = (Integer)this.m_RowHeights.get(new Integer(row));
        if (height == null) {
            int h;
            if (row == 0 && (h = this.getInitialFirstRowHeight()) > 2) {
                return h;
            }
            int initialH = this.getInitialRowHeight(row);
            if (initialH < 2) {
                return 2;
            }
            return initialH;
        }
        if (height < 2) {
            return 2;
        }
        return height;
    }

    public abstract int getInitialRowHeight(int var1);

    public int getFirstRowHeight() {
        return this.getRowHeight(0);
    }

    public int getInitialFirstRowHeight() {
        return -1;
    }

    public void setColumnWidth(int col, int value) {
        if (value < 0) {
            value = 0;
        }
        this.m_ColWidths.put(new Integer(col), new Integer(value));
    }

    public void setRowHeight(int row, int value) {
        if (value < 2) {
            value = 2;
        }
        this.m_RowHeights.put(new Integer(row), new Integer(value));
    }

    public void setFirstRowHeight(int value) {
        this.setRowHeight(0, value);
    }

    public Object getContentAt(int col, int row) {
        return this.doGetContentAt(col, row);
    }

    public abstract Object doGetContentAt(int var1, int var2);

    public String getTooltipAt(int col, int row) {
        return this.doGetTooltipAt(col, row);
    }

    public String doGetTooltipAt(int col, int row) {
        return null;
    }

    public KTableCellEditor getCellEditor(int col, int row) {
        return this.doGetCellEditor(col, row);
    }

    public abstract KTableCellEditor doGetCellEditor(int var1, int var2);

    public void setContentAt(int col, int row, Object value) {
        this.doSetContentAt(col, row, value);
    }

    public abstract void doSetContentAt(int var1, int var2, Object var3);

    public KTableCellRenderer getCellRenderer(int col, int row) {
        return this.doGetCellRenderer(col, row);
    }

    public abstract KTableCellRenderer doGetCellRenderer(int var1, int var2);

    public boolean isFixedCell(int col, int row) {
        return col < this.getFixedColumnCount() || row < this.getFixedRowCount();
    }

    public boolean isHeaderCell(int col, int row) {
        return col < this.getFixedHeaderColumnCount() || row < this.getFixedHeaderRowCount();
    }

    public int getFixedRowCount() {
        return this.getFixedHeaderRowCount() + this.getFixedSelectableRowCount();
    }

    public int getFixedColumnCount() {
        return this.getFixedHeaderColumnCount() + this.getFixedSelectableColumnCount();
    }

    public int getRowCount() {
        return this.doGetRowCount();
    }

    public abstract int doGetRowCount();

    public int getColumnCount() {
        return this.doGetColumnCount();
    }

    public abstract int doGetColumnCount();

    public Point belongsToCell(int col, int row) {
        return this.doBelongsToCell(col, row);
    }

    public Point doBelongsToCell(int col, int row) {
        return new Point(col, row);
    }

    public int mapRowIndexToModel(int shownRow) {
        return shownRow;
    }

    public int mapRowIndexToTable(int modelRow) {
        return modelRow;
    }
}

