/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable;

import de.kupzog.ktable.KTableSortedModel;
import java.util.Comparator;
import org.eclipse.swt.graphics.Point;

public abstract class KTableSortComparator
implements Comparator {
    public static final int SORT_NONE = -1;
    public static final int SORT_UP = 1;
    public static final int SORT_DOWN = 2;
    private int m_ColIndex = -1;
    private KTableSortedModel m_Model;
    private int m_Direction = -1;

    public KTableSortComparator(KTableSortedModel model, int columnIndex, int direction) {
        this.setModel(model);
        this.setSortDirection(direction);
        this.setColumnToCompare(columnIndex);
    }

    public final int compare(Object o1, Object o2) {
        Point loc2;
        if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
            throw new ClassCastException("KTableSortComparator was used in a way not allowed!");
        }
        int row1 = (Integer)o1;
        int row2 = (Integer)o2;
        if (this.m_Direction == -1) {
            if (row1 > row2) {
                return 1;
            }
            if (row1 < row2) {
                return -1;
            }
            return 0;
        }
        Point loc1 = this.m_Model.getValidCell(this.m_ColIndex, row1);
        if (loc1 == null) {
            loc1 = new Point(this.m_ColIndex, row1);
        }
        if ((loc2 = this.m_Model.getValidCell(this.m_ColIndex, row2)) == null) {
            loc2 = new Point(this.m_ColIndex, row2);
        }
        Object content1 = this.m_Model.doGetContentAt(loc1.x, loc1.y);
        Object content2 = this.m_Model.doGetContentAt(loc2.x, loc2.y);
        if (this.m_Direction == 2) {
            return -this.doCompare(content1, content2, row1, row2);
        }
        return this.doCompare(content1, content2, row1, row2);
    }

    public abstract int doCompare(Object var1, Object var2, int var3, int var4);

    public void setColumnToCompare(int column) {
        this.m_ColIndex = column;
    }

    public int getSortDirection() {
        return this.m_Direction;
    }

    public void setSortDirection(int direction) {
        if (direction != 1 && direction != 2 && direction != -1) {
            throw new IllegalArgumentException("Undefined sorting direction: " + direction);
        }
        this.m_Direction = direction;
    }

    public int getColumnToSortOn() {
        return this.m_ColIndex;
    }

    public KTableSortedModel getModel() {
        return this.m_Model;
    }

    public void setModel(KTableSortedModel model) {
        this.m_Model = model;
    }
}

