/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable;

import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableDefaultModel;
import de.kupzog.ktable.KTableSortComparator;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;

public abstract class KTableSortedModel
extends KTableDefaultModel {
    private int m_Ordered = -1;
    private int m_SortColumn = -1;
    private KTableSortComparator m_currentSortComparator = null;
    private Vector rowMapping;

    public void resetRowMapping() {
        int numberOfElems = this.getRowCount() - this.getFixedHeaderRowCount();
        this.rowMapping = new Vector(numberOfElems);
    }

    public void initialize() {
        super.initialize();
        int numberOfElems = this.getRowCount() - this.getFixedHeaderRowCount();
        this.rowMapping = new Vector(numberOfElems);
        int fixedRowCount = this.getFixedHeaderRowCount() + this.getFixedSelectableRowCount();
        int i = 0;
        while (i < numberOfElems) {
            this.rowMapping.add(i, new Integer(i + fixedRowCount));
            ++i;
        }
    }

    public final int getSortState() {
        return this.m_Ordered;
    }

    public void sort(KTableSortComparator comparator) {
        Collections.sort(this.rowMapping, comparator);
        this.m_Ordered = comparator.getSortDirection();
        if (this.m_Ordered == -1) {
            this.setSortColumn(-1);
        } else {
            this.setSortColumn(comparator.getColumnToSortOn());
        }
        this.m_currentSortComparator = comparator;
    }

    public final int getSortColumn() {
        return this.m_SortColumn;
    }

    protected final void setSortColumn(int column) {
        this.m_SortColumn = column;
    }

    public int mapRowIndexToModel(int row) {
        int bodyRow;
        if (row < this.getFixedHeaderRowCount() + this.getFixedSelectableRowCount()) {
            return row;
        }
        if (row - this.getFixedRowCount() >= this.rowMapping.size()) {
            int fixedRowCount = this.getFixedHeaderRowCount() + this.getFixedSelectableRowCount();
            int i = this.rowMapping.size();
            while (i < this.getRowCount() - fixedRowCount) {
                this.rowMapping.add(i, new Integer(i + fixedRowCount));
                ++i;
            }
        }
        if ((bodyRow = row - this.getFixedRowCount()) < 0 || bodyRow >= this.rowMapping.size()) {
            return row;
        }
        int mappedRow = (Integer)this.rowMapping.get(bodyRow);
        if (mappedRow >= this.getRowCount() || mappedRow < 0) {
            this.resetRowMapping();
            if (this.m_currentSortComparator != null) {
                this.sort(this.m_currentSortComparator);
            }
            return this.mapRowIndexToModel(row);
        }
        return mappedRow;
    }

    public int mapRowIndexToTable(int row) {
        if (row < this.getFixedHeaderRowCount() + this.getFixedSelectableRowCount()) {
            return row;
        }
        int i = 0;
        while (i < this.rowMapping.size()) {
            Integer im = (Integer)this.rowMapping.get(i);
            if (im == row) {
                return i + this.getFixedRowCount();
            }
            ++i;
        }
        return row;
    }

    public Object getContentAt(int col, int row) {
        int nrow = this.mapRowIndexToModel(row);
        Point valid = this.getValidCell(col, nrow);
        return this.doGetContentAt(valid.x, valid.y);
    }

    public String getTooltipAt(int col, int row) {
        row = this.mapRowIndexToModel(row);
        Point valid = this.getValidCell(col, row);
        return this.doGetTooltipAt(valid.x, valid.y);
    }

    public KTableCellEditor getCellEditor(int col, int row) {
        row = this.mapRowIndexToModel(row);
        Point valid = this.getValidCell(col, row);
        return this.doGetCellEditor(valid.x, valid.y);
    }

    public void setContentAt(int col, int row, Object value) {
        row = this.mapRowIndexToModel(row);
        Point valid = this.getValidCell(col, row);
        this.doSetContentAt(valid.x, valid.y, value);
    }

    public KTableCellRenderer getCellRenderer(int col, int row) {
        row = this.mapRowIndexToModel(row);
        Point valid = this.getValidCell(col, row);
        return this.doGetCellRenderer(valid.x, valid.y);
    }

    public Point belongsToCell(int col, int row) {
        if (this.getSortState() == -1) {
            return this.doBelongsToCell(col, row);
        }
        return new Point(col, row);
    }

    protected Point getValidCell(int colToCheck, int rowToCheck) {
        Point found = new Point(colToCheck, rowToCheck);
        if (colToCheck == 0 || rowToCheck == 0) {
            return found;
        }
        Point lastFound = null;
        while (!found.equals(lastFound)) {
            lastFound = found;
            found = this.doBelongsToCell(found.x, found.y);
            if (found != null && (found.x > lastFound.x || found.y > lastFound.y)) {
                throw new IllegalArgumentException("When spanning over several cells, supercells that determine the content of the large cell must always be in the left upper corner!");
            }
            if (found != null) continue;
            return lastFound;
        }
        return found;
    }
}

