/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SWTX {
    public static final int AUTO_SCROLL = 1792;
    public static final int FILL_WITH_LASTCOL = 131072;
    public static final int FILL_WITH_DUMMYCOL = 262144;
    public static final int EDIT_ON_KEY = 0x40000000;
    public static final int MARK_FOCUS_HEADERS = Integer.MIN_VALUE;
    public static final int RESIZE_ON_ENTIRE_COLUMN = 0x10000000;
    public static final String COLOR_BGFOCUS = "bgfocus";
    public static final String COLOR_FIXEDHIGHLIGHT = "fixedhighlight";
    private static final ColorRegistry m_colorFactory = new ColorRegistry();
    public static final int EVENT_SWTX_BASE = 1000;
    public static final int EVENT_TABLE_HEADER = 1001;
    public static final int EVENT_TABLE_HEADER_CLICK = 1002;
    public static final int EVENT_TABLE_HEADER_RESIZE = 1003;
    public static final int ALIGN_HORIZONTAL_MASK = 15;
    public static final int ALIGN_HORIZONTAL_NONE = 0;
    public static final int ALIGN_HORIZONTAL_LEFT = 1;
    public static final int ALIGN_HORIZONTAL_LEFT_LEFT = 1;
    public static final int ALIGN_HORIZONTAL_LEFT_RIGHT = 2;
    public static final int ALIGN_HORIZONTAL_LEFT_CENTER = 3;
    public static final int ALIGN_HORIZONTAL_RIGHT = 4;
    public static final int ALIGN_HORIZONTAL_RIGHT_RIGHT = 4;
    public static final int ALIGN_HORIZONTAL_RIGHT_LEFT = 5;
    public static final int ALIGN_HORIZONTAL_RIGHT_CENTER = 6;
    public static final int ALIGN_HORIZONTAL_CENTER = 7;
    public static final int ALIGN_VERTICAL_MASK = 240;
    public static final int ALIGN_VERTICAL_TOP = 16;
    public static final int ALIGN_VERTICAL_BOTTOM = 32;
    public static final int ALIGN_VERTICAL_CENTER = 48;
    public static final int WRAP_MASK = 3840;
    public static final int WRAP = 2304;
    private static GC m_LastGCFromExtend;
    private static Map m_StringExtentCache;

    static {
        m_colorFactory.put(COLOR_BGFOCUS, new RGB(223, 227, 237));
        m_colorFactory.put(COLOR_FIXEDHIGHLIGHT, new RGB(182, 189, 210));
        m_StringExtentCache = new HashMap();
    }

    public static Color getColor(String colorKey) {
        return m_colorFactory.get(colorKey);
    }

    public static synchronized Point getCachedStringExtent(GC gc, String text) {
        Point p;
        if (m_LastGCFromExtend != gc) {
            m_StringExtentCache.clear();
            m_LastGCFromExtend = gc;
        }
        if ((p = (Point)m_StringExtentCache.get(text)) == null) {
            if (text == null) {
                return new Point(0, 0);
            }
            p = gc.textExtent(text);
            m_StringExtentCache.put(text, p);
        }
        return new Point(p.x, p.y);
    }

    public static int drawTextVerticalAlign(GC gc, String text, int textAlign, int x, int y, int w, int h) {
        if (text == null) {
            text = "";
        }
        if ((textAlign & 0xF00) == 2304) {
            text = SWTX.wrapText(gc, text, w);
            text = SWTX.cropWrappedTextForHeight(gc, text, h);
        }
        Rectangle oldClip = gc.getClipping();
        Rectangle newClip = new Rectangle(x, y, w, h);
        newClip.intersect(oldClip);
        gc.setClipping(newClip);
        Point textSize = SWTX.getCachedStringExtent(gc, text);
        boolean addPoint = false;
        while (text.length() > 0 && textSize.x >= w) {
            text = text.substring(0, Math.max(text.length() - 1, 0));
            textSize = SWTX.getCachedStringExtent(gc, String.valueOf(text) + "...");
            addPoint = true;
        }
        if (addPoint) {
            text = String.valueOf(text) + "...";
        }
        textSize = SWTX.getCachedStringExtent(gc, text);
        if (textSize.x >= w) {
            text = "";
            textSize = SWTX.getCachedStringExtent(gc, text);
        }
        int textDrawFlags = 7;
        if ((textAlign & 0xF0) == 16) {
            gc.drawText(text, x, y, textDrawFlags);
        } else if ((textAlign & 0xF0) == 32) {
            gc.drawText(text, x, y + h - textSize.y, textDrawFlags);
        } else if ((textAlign & 0xF0) == 48) {
            int yOffset = (h - textSize.y) / 2;
            gc.drawText(text, x, y + yOffset, textDrawFlags);
        } else {
            throw new SWTException("Unknown alignment for text: " + (textAlign & 0xF0));
        }
        gc.setClipping(oldClip);
        return textSize.x;
    }

    public static void drawTransparentImage(GC gc, Image image, int x, int y) {
        if (image == null) {
            return;
        }
        gc.drawImage(image, x, y);
    }

    public static void drawImageVerticalAlign(GC gc, Image image, int imageAlign, int x, int y, int h) {
        if (image == null) {
            return;
        }
        Point imageSize = new Point(image.getBounds().width, image.getBounds().height);
        if ((imageAlign & 0xF0) == 16) {
            SWTX.drawTransparentImage(gc, image, x, y);
            return;
        }
        if ((imageAlign & 0xF0) == 32) {
            SWTX.drawTransparentImage(gc, image, x, y + h - imageSize.y);
            return;
        }
        if ((imageAlign & 0xF0) == 48) {
            int yOffset = (h - imageSize.y) / 2;
            SWTX.drawTransparentImage(gc, image, x, y + yOffset);
            return;
        }
        throw new SWTException("Unknown alignment for image: " + (imageAlign & 0xF0));
    }

    public static void drawTextImage(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Point textSize = SWTX.getCachedStringExtent(gc, text);
        Point imageSize = image != null ? new Point(image.getBounds().width, image.getBounds().height) : new Point(0, 0);
        if (image == null && (textAlign & 0xF) == 7) {
            Point p = SWTX.getCachedStringExtent(gc, text);
            int offset = (w - p.x) / 2;
            if (offset > 0) {
                SWTX.drawTextVerticalAlign(gc, text, textAlign, x + offset, y, w, h);
            } else {
                p.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, y, w, h);
            }
            return;
        }
        if ((text == null || text.length() == 0) && (imageAlign & 0xF) == 7) {
            int offset = (w - imageSize.x) / 2;
            SWTX.drawImageVerticalAlign(gc, image, imageAlign, x + offset, y, h);
            return;
        }
        if ((textAlign & 0xF) == 1) {
            if ((imageAlign & 0xF) == 0) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, y, w, h);
                return;
            }
            if ((imageAlign & 0xF) == 1) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x + imageSize.x, y, w - imageSize.x, h);
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x, y, h);
                return;
            }
            if ((imageAlign & 0xF) == 4) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, y, w - imageSize.x, h);
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x + w - imageSize.x, y, h);
                return;
            }
            if ((imageAlign & 0xF) == 5) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, y, w - imageSize.x, h);
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x + textSize.x, y, h);
                return;
            }
            if ((imageAlign & 0xF) == 6) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, y, w - imageSize.x, h);
                int xOffset = (w - textSize.x - imageSize.x) / 2;
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x + textSize.x + xOffset, y, h);
                return;
            }
            throw new SWTException("Unknown alignment for text: " + (imageAlign & 0xF));
        }
        if ((textAlign & 0xF) == 4) {
            if ((imageAlign & 0xF) == 0) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w, h);
                SWTX.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w, h);
                return;
            }
            if ((imageAlign & 0xF) == 1) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
                SWTX.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w - imageSize.x, h);
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x, y, h);
                return;
            }
            if ((imageAlign & 0xF) == 2) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
                SWTX.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w - imageSize.x, h);
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x + w - (textSize.x + imageSize.x), y, h);
                return;
            }
            if ((imageAlign & 0xF) == 3) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
                SWTX.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w - imageSize.x, h);
                int xOffset = (w - textSize.x - imageSize.x) / 2;
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x + xOffset, y, h);
                return;
            }
            if ((imageAlign & 0xF) == 4) {
                textSize.x = SWTX.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
                SWTX.drawTextVerticalAlign(gc, text, textAlign, x + w - (textSize.x + imageSize.x), y, w - imageSize.x, h);
                SWTX.drawImageVerticalAlign(gc, image, imageAlign, x + w - imageSize.x, y, h);
                return;
            }
            throw new SWTException("Unknown alignment for text: " + (imageAlign & 0xF));
        }
        throw new SWTException("Unknown alignment for text: " + (textAlign & 0xF));
    }

    public static void drawTextImage(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        SWTX.drawTextImage(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static String cropWrappedTextForHeight(GC gc, String text, int height) {
        String[] lines = text.split("\n");
        int linesToTake = height / gc.getFontMetrics().getHeight();
        if (linesToTake < 1) {
            linesToTake = 1;
        }
        if (lines.length <= linesToTake) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < linesToTake) {
            buffer.append(lines[i]);
            buffer.append('\n');
            ++i;
        }
        return buffer.substring(0, Math.max(buffer.length() - 1, 0));
    }

    public static String wrapText(GC gc, String text, int width) {
        Point textSize = SWTX.getCachedStringExtent(gc, text);
        if (textSize.x > width) {
            StringBuffer wrappedText = new StringBuffer();
            String[] lines = text.split("\n");
            int cutoffLength = width / gc.getFontMetrics().getAverageCharWidth();
            if (cutoffLength < 3) {
                return text;
            }
            int i = 0;
            while (i < lines.length) {
                int breakOffset = 0;
                while (breakOffset < lines[i].length()) {
                    String lPart = lines[i].substring(breakOffset, Math.min(breakOffset + cutoffLength, lines[i].length()));
                    Point lineSize = SWTX.getCachedStringExtent(gc, lPart);
                    while (lPart.length() > 0 && lineSize.x >= width) {
                        lPart = lPart.substring(0, Math.max(lPart.length() - 1, 0));
                        lineSize = SWTX.getCachedStringExtent(gc, lPart);
                    }
                    wrappedText.append(lPart);
                    breakOffset += lPart.length();
                    wrappedText.append('\n');
                }
                ++i;
            }
            return wrappedText.substring(0, Math.max(wrappedText.length() - 1, 0));
        }
        return text;
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face, Color shadowHigh, Color shadowNormal, Color shadowDark, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        Rectangle clip = gc.getClipping();
        ++clip.height;
        ++clip.width;
        gc.setClipping(clip);
        try {
            gc.setBackground(face);
            gc.setForeground(shadowHigh);
            gc.drawLine(x, y, x, y + h - 1);
            gc.drawLine(x, y, x + w - 2, y);
            gc.setForeground(shadowDark);
            gc.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            gc.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            gc.setForeground(shadowNormal);
            gc.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
            gc.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            gc.fillRectangle(x + 1, y + 1, w - 3, h - 3);
            gc.setForeground(prevForeground);
            SWTX.drawTextImage(gc, text, textAlign, image, imageAlign, x + 1 + leftMargin, y + 1 + topMargin, w - 3 - leftMargin, h - 3 - topMargin);
        }
        finally {
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
        }
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face) {
        Display display = Display.getCurrent();
        SWTX.drawButtonUp(gc, text, textAlign, image, imageAlign, x, y, w, h, face, display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), 2, 2);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r, int leftMargin, int topMargin) {
        Display display = Display.getCurrent();
        SWTX.drawButtonUp(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height, display.getSystemColor(22), display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), leftMargin, topMargin);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Display display = Display.getCurrent();
        SWTX.drawButtonUp(gc, text, textAlign, image, imageAlign, x, y, w, h, display.getSystemColor(22), display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), 2, 2);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        SWTX.drawButtonUp(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face, Color shadowNormal, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setBackground(face);
            gc.setForeground(shadowNormal);
            Rectangle clip = gc.getClipping();
            ++clip.height;
            ++clip.width;
            gc.setClipping(clip);
            gc.drawRectangle(x, y, w - 1, h - 1);
            gc.fillRectangle(x + 1, y + 1, w - 2, h - 2);
            gc.setForeground(prevForeground);
            SWTX.drawTextImage(gc, text, textAlign, image, imageAlign, x + 2 + leftMargin, y + 2 + topMargin, w - 3 - leftMargin, h - 3 - topMargin);
        }
        finally {
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
        }
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Display display = Display.getCurrent();
        SWTX.drawButtonDown(gc, text, textAlign, image, imageAlign, x, y, w, h, display.getSystemColor(22), display.getSystemColor(18), 2, 2);
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        SWTX.drawButtonDown(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face) {
        Display display = Display.getCurrent();
        SWTX.drawButtonDown(gc, text, textAlign, image, imageAlign, x, y, w, h, face, display.getSystemColor(18), 2, 2);
    }

    public static void drawButtonDeepDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Display display = Display.getCurrent();
        gc.setForeground(display.getSystemColor(2));
        gc.drawLine(x, y, x + w - 2, y);
        gc.drawLine(x, y, x, y + h - 2);
        gc.setForeground(display.getSystemColor(1));
        gc.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        gc.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        gc.setForeground(display.getSystemColor(22));
        gc.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        gc.drawLine(x + w - 2, y + h - 2, x + w - 2, y + 1);
        gc.setForeground(display.getSystemColor(21));
        gc.setBackground(display.getSystemColor(22));
        gc.fillRectangle(x + 2, y + 2, w - 4, 1);
        gc.fillRectangle(x + 1, y + 2, 2, h - 4);
        gc.setBackground(display.getSystemColor(22));
        SWTX.drawTextImage(gc, text, textAlign, image, imageAlign, x + 2 + 1, y + 2 + 1, w - 4, h - 3 - 1);
    }

    public static void drawButtonDeepDown(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        SWTX.drawButtonDeepDown(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static void drawFlatButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face, Color shadowLight, Color shadowNormal, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setForeground(shadowLight);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h);
            gc.setForeground(shadowNormal);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x + 1, y + h, x + w, y + h);
            gc.setBackground(face);
            gc.fillRectangle(x + 1, y + 1, leftMargin, h - 1);
            gc.fillRectangle(x + 1, y + 1, w - 1, topMargin);
            gc.setBackground(face);
            gc.setForeground(prevForeground);
            SWTX.drawTextImage(gc, text, textAlign, image, imageAlign, x + 1 + leftMargin, y + 1 + topMargin, w - 1 - leftMargin, h - 1 - topMargin);
        }
        finally {
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
        }
    }

    public static void drawShadowImage(GC gc, Image image, int x, int y, int alpha) {
        Display display = Display.getCurrent();
        Point imageSize = new Point(image.getBounds().width, image.getBounds().height);
        ImageData imgData = new ImageData(imageSize.x, imageSize.y, 24, new PaletteData(255, 255, 255));
        imgData.alpha = alpha;
        Image img = new Image((Device)display, imgData);
        GC imgGC = new GC((Drawable)img);
        imgGC.drawImage(image, 0, 0);
        gc.drawImage(img, x, y);
        imgGC.dispose();
        img.dispose();
    }

    public static Image loadImageResource(Display d, String name) {
        try {
            Image ret = null;
            InputStream is = SWTX.class.getResourceAsStream(name);
            if (is != null) {
                ret = new Image((Device)d, is);
                is.close();
            }
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

