/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.editors;

import de.kupzog.ktable.KTable;
import de.kupzog.ktable.editors.KTableCellEditorCheckbox;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class KTableCellEditorCheckbox2
extends KTableCellEditorCheckbox {
    private Point m_Active;
    private int m_hAlign;
    private int m_vAlign;

    public KTableCellEditorCheckbox2(Point activeArea, int hAlign, int vAlign) {
        if (activeArea == null || !this.isValidHAlignment(hAlign) || !this.isValidVAlignment(vAlign)) {
            throw new ClassCastException("Check the parameters given to KTableCellEditorCheckbox2!");
        }
        this.m_Active = activeArea;
        this.m_hAlign = hAlign;
        this.m_vAlign = vAlign;
    }

    private boolean isValidHAlignment(int align) {
        return align == 7 || align == 1 || align == 4;
    }

    private boolean isValidVAlignment(int align) {
        return align == 16 || align == 48 || align == 32;
    }

    public boolean isApplicable(int eventType, KTable table, int col, int row, Point clickLocation, String keyInput, int stateMask) {
        if (eventType == 4) {
            Rectangle active = new Rectangle(0, 0, this.m_Active.x, this.m_Active.y);
            Rectangle cellBoundary = table.getCellRect(col, row);
            if (cellBoundary.width < active.width) {
                active.width = cellBoundary.width;
            }
            if (cellBoundary.height < active.height) {
                active.height = cellBoundary.height;
            }
            active.x = this.m_hAlign == 1 ? cellBoundary.x : (this.m_hAlign == 4 ? cellBoundary.x + cellBoundary.width - active.width : cellBoundary.x + (cellBoundary.width - active.width) / 2);
            active.y = this.m_vAlign == 16 ? cellBoundary.y : (this.m_vAlign == 32 ? cellBoundary.y + cellBoundary.height - active.height : cellBoundary.y + (cellBoundary.height - active.height) / 2);
            return active.contains(clickLocation);
        }
        return true;
    }
}

