/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.editors;

import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class KTableCellEditorCombo
extends KTableCellEditor {
    private CCombo m_Combo;
    private String[] m_Items;
    private Cursor m_ArrowCursor;
    private KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            try {
                KTableCellEditorCombo.this.onKeyPressed(e);
            }
            catch (Exception exception) {}
            e.doit = false;
        }
    };
    private TraverseListener travListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            KTableCellEditorCombo.this.onTraverse(e);
        }
    };

    public void open(KTable table, int col, int row, Rectangle rect) {
        this.m_ArrowCursor = new Cursor((Device)Display.getDefault(), 0);
        super.open(table, col, row, rect);
        String content = this.m_Model.getContentAt(this.m_Col, this.m_Row).toString();
        this.m_Combo.setText(content);
        this.m_Combo.setSelection(new Point(0, content.length()));
    }

    public void close(boolean save) {
        if (save) {
            this.m_Model.setContentAt(this.m_Col, this.m_Row, this.m_Combo.getText());
        }
        this.m_Combo.removeKeyListener((KeyListener)this.keyListener);
        this.m_Combo.removeTraverseListener(this.travListener);
        super.close(save);
        this.m_Combo = null;
        this.m_ArrowCursor.dispose();
    }

    protected Control createControl() {
        this.m_Combo = new CCombo((Composite)this.m_Table, 8);
        this.m_Combo.setBackground(Display.getCurrent().getSystemColor(25));
        if (this.m_Items != null) {
            this.m_Combo.setItems(this.m_Items);
        }
        this.m_Combo.addKeyListener((KeyListener)this.keyListener);
        this.m_Combo.addTraverseListener(this.travListener);
        this.m_Combo.setCursor(this.m_ArrowCursor);
        return this.m_Combo;
    }

    protected void onTraverse(TraverseEvent e) {
        switch (e.keyCode) {
            case 0x1000001: 
            case 0x1000002: {
                break;
            }
            default: {
                super.onTraverse(e);
            }
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(new Rectangle(rect.x, rect.y + 1, rect.width, rect.height - 2));
    }

    public void setItems(String[] items) {
        this.m_Items = items;
    }

    public void setContent(Object content) {
        if (content instanceof Integer) {
            this.m_Combo.select(((Integer)content).intValue());
        } else if (content instanceof String) {
            this.setSelectionToClosestMatch((String)content);
        } else {
            this.setSelectionToClosestMatch(content.toString());
        }
    }

    private void setSelectionToClosestMatch(String content) {
        content = content.toLowerCase();
        String[] citems = this.m_Combo.getItems();
        String[] items = new String[citems.length];
        int i = 0;
        while (i < citems.length) {
            items[i] = citems[i].toLowerCase();
            ++i;
        }
        int length = content.length();
        while (length >= 0) {
            String part = content.substring(0, length);
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2].startsWith(part)) {
                    this.m_Combo.select(i2);
                    return;
                }
                ++i2;
            }
            --length;
        }
    }
}

