/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.editors;

import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class KTableCellEditorText2
extends KTableCellEditor {
    protected Text m_Text;
    protected KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            try {
                KTableCellEditorText2.this.onKeyPressed(e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    protected TraverseListener travListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            KTableCellEditorText2.this.onTraverse(e);
        }
    };

    public void open(KTable table, int col, int row, Rectangle rect) {
        super.open(table, col, row, rect);
        this.m_Text.setText(this.getEditorContent());
        this.m_Text.selectAll();
        this.m_Text.setVisible(true);
        this.m_Text.setFocus();
    }

    protected String getEditorContent() {
        return this.m_Model.getContentAt(this.m_Col, this.m_Row).toString();
    }

    public void close(boolean save) {
        if (save) {
            this.m_Model.setContentAt(this.m_Col, this.m_Row, this.m_Text.getText());
        }
        this.m_Text.removeKeyListener((KeyListener)this.keyListener);
        this.m_Text.removeTraverseListener(this.travListener);
        super.close(save);
        this.m_Text = null;
    }

    protected Control createControl() {
        this.m_Text = new Text((Composite)this.m_Table, 0);
        this.m_Text.addKeyListener((KeyListener)this.keyListener);
        this.m_Text.addTraverseListener(this.travListener);
        return this.m_Text;
    }

    protected void onTraverse(TraverseEvent e) {
        if (e.keyCode == 0x1000003) {
            if (this.m_Text.getCaretPosition() == 0 && this.m_Text.getSelectionCount() == 0) {
                super.onTraverse(e);
            }
        } else if (e.keyCode == 0x1000004) {
            if (this.m_Text.getCaretPosition() == this.m_Text.getText().length() && this.m_Text.getSelectionCount() == 0) {
                super.onTraverse(e);
            }
        } else {
            super.onTraverse(e);
        }
    }

    protected void onKeyPressed(KeyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) == 0) {
            this.close(true);
        } else {
            super.onKeyPressed(e);
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(new Rectangle(rect.x, rect.y + (rect.height - 15) / 2 + 1, rect.width, 15));
    }

    public void setContent(Object content) {
        this.m_Text.setText(content.toString());
        this.m_Text.setSelection(content.toString().length());
    }
}

