/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.renderers;

import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import de.kupzog.ktable.renderers.IPercentage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class BarDiagramCellRenderer
extends DefaultCellRenderer {
    public BarDiagramCellRenderer(int style) {
        super(style);
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
        return 20;
    }

    public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        if (focus && (this.m_Style & 0x10) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawBar(gc, rect, content, COLOR_BGFOCUS, this.getForeground());
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        } else if (focus && (this.m_Style & 0x20) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_BGROWFOCUS, COLOR_BGROWFOCUS);
            Color defaultBg = this.COLOR_BACKGROUND;
            this.setDefaultBackground(COLOR_BGROWFOCUS);
            this.drawBar(gc, rect, content, this.getBackground(), this.getForeground());
            this.setDefaultBackground(defaultBg);
        } else {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawBar(gc, rect, content, this.getBackground(), this.getForeground());
        }
    }

    protected void drawGradientBar(GC gc, Rectangle rect, float m_fraction, Color background, Color foreground) {
        int barWidth = Math.round((float)rect.width * m_fraction);
        gc.setForeground(background);
        gc.setBackground(foreground);
        gc.fillGradientRectangle(rect.x, rect.y, barWidth, rect.height, false);
        gc.setBackground(this.COLOR_BACKGROUND);
        gc.fillRectangle(rect.x + barWidth, rect.y, rect.width - barWidth, rect.height);
    }

    protected void drawNormalBar(GC gc, Rectangle rect, Color background, Color foreground, float m_fraction) {
        int barWidth = Math.round((float)rect.width * m_fraction);
        gc.setBackground(foreground);
        gc.fillRectangle(rect.x, rect.y, barWidth, rect.height);
        gc.setBackground(background);
        gc.fillRectangle(rect.x + barWidth, rect.y, rect.width - barWidth, rect.height);
    }

    protected void drawBar(GC gc, Rectangle rect, Object content, Color background, Color foreground) {
        float m_fraction = content instanceof Float ? ((Float)content).floatValue() : (content instanceof Double ? ((Double)content).floatValue() : (content instanceof IPercentage ? ((IPercentage)content).getPercentage() : 0.0f));
        if (m_fraction > 1.0f) {
            m_fraction = 1.0f;
        }
        if (m_fraction < 0.0f) {
            m_fraction = 0.0f;
        }
        if ((this.m_Style & 0x100) != 0) {
            this.drawGradientBar(gc, rect, m_fraction, background, foreground);
        } else {
            this.drawNormalBar(gc, rect, background, foreground, m_fraction);
        }
    }
}

