/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.renderers;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public abstract class BorderPainter {
    public static Rectangle drawDoubleLineSeperatorBorder(GC gc, Rectangle rect, Color vColor, Color hColor, Color seperatorBGColor, boolean vSeperator, boolean hSeperator) {
        Rectangle newContentBounds = BorderPainter.drawDefaultSolidCellLine(gc, rect, vColor, hColor);
        if (vSeperator) {
            gc.setForeground(vColor);
            gc.drawLine(rect.x + rect.width - 2, rect.y, rect.x + rect.width - 2, rect.y + rect.height);
            gc.setForeground(seperatorBGColor);
            gc.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height);
            newContentBounds.width -= 2;
        }
        if (hSeperator) {
            gc.setForeground(hColor);
            gc.drawLine(rect.x, rect.y + rect.height - 2, rect.x + rect.width, rect.y + rect.height - 2);
            gc.setForeground(seperatorBGColor);
            gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
            newContentBounds.height -= 2;
        }
        return newContentBounds;
    }

    public static final Rectangle drawDefaultSolidCellLine(GC gc, Rectangle rect, Color vBorderColor, Color hBorderColor) {
        gc.setForeground(hBorderColor);
        gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        gc.setForeground(vBorderColor);
        gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
        return rect;
    }

    public static final Rectangle drawSolidCellLines(GC gc, Rectangle rect, Color topBorderColor, Color bottomBorderColor, Color leftBorderColor, Color rightBorderColor, int topWidth, int bottomWidth, int leftWidth, int rightWidth) {
        if (leftWidth < 0 || rightWidth < 0 || topWidth < 0 || bottomWidth < 0) {
            SWT.error((int)5, null, (String)"Invalid border line width in KTable CellRenderer");
        }
        ++rightWidth;
        gc.setBackground(bottomBorderColor);
        gc.fillRectangle(rect.x, rect.y + rect.height - ++bottomWidth + 1, rect.width + 1, bottomWidth);
        gc.setBackground(topBorderColor);
        gc.fillRectangle(rect.x, rect.y, rect.width + 1, topWidth);
        gc.setBackground(rightBorderColor);
        gc.fillRectangle(rect.x + rect.width - rightWidth + 1, rect.y, rightWidth, rect.height + 1);
        gc.setBackground(leftBorderColor);
        gc.fillRectangle(rect.x, rect.y, leftWidth, rect.height + 1);
        rect.x += leftWidth;
        rect.y += topWidth;
        rect.height = rect.height - bottomWidth - topWidth + 1;
        rect.width = rect.width - leftWidth - rightWidth + 1;
        return rect;
    }
}

