/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.renderers;

import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.SWTX;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class CheckableCellRenderer
extends DefaultCellRenderer {
    public static final int SIGN_IMAGE = Integer.MIN_VALUE;
    public static final int SIGN_X = 0x40000000;
    public static final int SIGN_CHECK = 0x20000000;
    public static final Image IMAGE_CHECKED = SWTX.loadImageResource(Display.getCurrent(), "/icons/checked.gif");
    public static final Image IMAGE_UNCHECKED = SWTX.loadImageResource(Display.getCurrent(), "/icons/unchecked.gif");
    public static final Image IMAGE_CHECKED_CLICKED = SWTX.loadImageResource(Display.getCurrent(), "/icons/checked_clicked.gif");
    public static final Image IMAGE_UNCHECKED_CLICKED = SWTX.loadImageResource(Display.getCurrent(), "/icons/unchecked_clicked.gif");
    public static final Color COLOR_FILL = new Color((Device)Display.getDefault(), 206, 206, 206);
    public static final Color BORDER_DARK = new Color((Device)Display.getDefault(), 90, 90, 57);
    public static final Color BORDER_LIGHT = new Color((Device)Display.getDefault(), 156, 156, 123);

    public CheckableCellRenderer(int style) {
        super(style);
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
        return CheckableCellRenderer.IMAGE_CHECKED.getBounds().x + 6;
    }

    public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        if (focus && (this.m_Style & 0x10) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCheckableImage(gc, rect, content, COLOR_BGFOCUS, clicked);
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        } else if (focus && (this.m_Style & 0x20) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_BGROWFOCUS, COLOR_BGROWFOCUS);
            this.drawCheckableImage(gc, rect, content, COLOR_BGROWFOCUS, clicked);
        } else {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCheckableImage(gc, rect, content, this.getBackground(), clicked);
        }
        if ((this.m_Style & 0x80) != 0) {
            this.drawCommentSign(gc, rect);
        }
    }

    protected void drawCheckableImage(GC gc, Rectangle rect, Object content, Color bgColor, boolean clicked) {
        if ((this.m_Style & Integer.MIN_VALUE) != 0) {
            if (!(content instanceof Boolean)) {
                if (content.toString().equalsIgnoreCase("true")) {
                    content = new Boolean(true);
                } else if (content.toString().equalsIgnoreCase("false")) {
                    content = new Boolean(false);
                }
            }
            if (!(content instanceof Boolean)) {
                this.drawCellContent(gc, rect, "?", null, this.getForeground(), bgColor);
            } else {
                boolean checked = (Boolean)content;
                if (checked) {
                    if (clicked && (this.m_Style & 0x40) != 0) {
                        this.drawImage(gc, rect, IMAGE_CHECKED_CLICKED, bgColor);
                    } else {
                        this.drawImage(gc, rect, IMAGE_CHECKED, bgColor);
                    }
                } else if (clicked && (this.m_Style & 0x40) != 0) {
                    this.drawImage(gc, rect, IMAGE_UNCHECKED_CLICKED, bgColor);
                } else {
                    this.drawImage(gc, rect, IMAGE_UNCHECKED, bgColor);
                }
            }
        } else {
            if (!(content instanceof Boolean)) {
                if (content.toString().equalsIgnoreCase("true")) {
                    content = new Boolean(true);
                } else if (content.toString().equalsIgnoreCase("false")) {
                    content = new Boolean(false);
                }
            }
            if (!(content instanceof Boolean)) {
                this.drawCellContent(gc, rect, "?", null, this.getForeground(), bgColor);
            } else {
                boolean checked = (Boolean)content;
                if (clicked && (this.m_Style & 0x40) != 0) {
                    this.drawCheckedSymbol(gc, rect, checked, bgColor, COLOR_FILL);
                } else {
                    this.drawCheckedSymbol(gc, rect, checked, bgColor, bgColor);
                }
            }
        }
    }

    protected void drawImage(GC gc, Rectangle rect, Image image, Color backgroundColor) {
        gc.setBackground(backgroundColor);
        gc.setForeground(backgroundColor);
        gc.fillRectangle(rect);
        SWTX.drawTextImage(gc, "", this.getAlignment(), image, this.getAlignment(), rect.x + 3, rect.y, rect.width - 3, rect.height);
    }

    public void setCommentIndication(boolean value) {
        this.m_Style = value ? (this.m_Style |= 0x80) : (this.m_Style &= 0xFFFFFF7F);
    }

    protected void drawCheckedSymbol(GC gc, Rectangle rect, boolean checked, Color bgColor, Color fillColor) {
        gc.setBackground(bgColor);
        gc.fillRectangle(rect);
        Rectangle bound = this.getAlignedLocation(rect, IMAGE_CHECKED);
        gc.setForeground(BORDER_LIGHT);
        gc.drawLine(bound.x, bound.y, bound.x + bound.width, bound.y);
        gc.drawLine(bound.x, bound.y, bound.x, bound.y + bound.height);
        gc.setForeground(BORDER_DARK);
        gc.drawLine(bound.x + bound.width, bound.y + 1, bound.x + bound.width, bound.y + bound.height - 1);
        gc.drawLine(bound.x, bound.y + bound.height, bound.x + bound.width, bound.y + bound.height);
        if (!bgColor.equals((Object)fillColor)) {
            gc.setBackground(fillColor);
            gc.fillRectangle(bound.x + 1, bound.y + 1, bound.width - 1, bound.height - 1);
        }
        if (checked) {
            this.drawCheckSymbol(gc, bound);
        }
    }

    private void drawCheckSymbol(GC gc, Rectangle bound) {
        if ((this.m_Style & 0x40000000) != 0) {
            gc.setForeground(BORDER_LIGHT);
            gc.drawLine(bound.x + 3, bound.y + 2, bound.x - 2 + bound.width, bound.y - 3 + bound.height);
            gc.drawLine(bound.x + 2, bound.y + 3, bound.x - 3 + bound.width, bound.y - 2 + bound.height);
            gc.drawLine(bound.x + 3, bound.y - 2 + bound.height, bound.x - 2 + bound.width, bound.y + 3);
            gc.drawLine(bound.x + 2, bound.y - 3 + bound.height, bound.x - 3 + bound.width, bound.y + 2);
            gc.setForeground(this.COLOR_TEXT);
            gc.drawLine(bound.x + 2, bound.y + 2, bound.x - 2 + bound.width, bound.y - 2 + bound.height);
            gc.drawLine(bound.x + 2, bound.y - 2 + bound.height, bound.x - 2 + bound.width, bound.y + 2);
        } else {
            gc.setForeground(this.getForeground());
            gc.drawLine(bound.x + 2, bound.y + bound.height - 4, bound.x + 4, bound.y + bound.height - 2);
            gc.drawLine(bound.x + 2, bound.y + bound.height - 5, bound.x + 5, bound.y + bound.height - 3);
            gc.drawLine(bound.x + 2, bound.y + bound.height - 6, bound.x + 4, bound.y + bound.height - 4);
            int i = 1;
            while (i < 4) {
                gc.drawLine(bound.x + 2 + i, bound.y + bound.height - 3, bound.x + bound.width - 2, bound.y + 1 + i);
                ++i;
            }
        }
    }

    protected Rectangle getAlignedLocation(Rectangle rect, Image img) {
        Rectangle bounds = img.getBounds();
        bounds.x -= 2;
        bounds.y -= 2;
        bounds.height -= 4;
        bounds.width -= 4;
        bounds.x = (this.getAlignment() & 7) != 0 ? rect.x + (rect.width - bounds.width) / 2 : ((this.getAlignment() & 4) != 0 ? rect.x + rect.width - bounds.width - 2 : rect.x + 2);
        bounds.y = (this.getAlignment() & 0x30) != 0 ? rect.y + (rect.height - bounds.height) / 2 : ((this.getAlignment() & 0x20) != 0 ? rect.y + rect.height - bounds.height - 2 : rect.y + 2);
        return bounds;
    }
}

