/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.renderers;

import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.SWTX;
import de.kupzog.ktable.renderers.BorderPainter;
import de.kupzog.ktable.renderers.FixedCellRenderer;
import de.kupzog.ktable.renderers.TextCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class DefaultCellRenderer
implements KTableCellRenderer {
    public Color COLOR_TEXT = Display.getDefault().getSystemColor(24);
    public Color COLOR_BACKGROUND = Display.getDefault().getSystemColor(25);
    public static Color COLOR_LINE_LIGHTGRAY = Display.getDefault().getSystemColor(22);
    public static Color COLOR_LINE_DARKGRAY = Display.getDefault().getSystemColor(16);
    public static Color COLOR_BGFOCUS = SWTX.getColor("bgfocus");
    public static Color COLOR_COMMENTSIGN = Display.getDefault().getSystemColor(10);
    public static Color COLOR_FIXEDHIGHLIGHT = SWTX.getColor("fixedhighlight");
    public static Color COLOR_BGROWFOCUS = Display.getDefault().getSystemColor(26);
    public static Color COLOR_FGROWFOCUS = Display.getDefault().getSystemColor(27);
    public static final int STYLE_PUSH = 0;
    public static final int STYLE_FLAT = 4;
    public static final int INDICATION_SORT = 8;
    public static final int INDICATION_FOCUS = 16;
    public static final int INDICATION_FOCUS_ROW = 32;
    public static final int INDICATION_CLICKED = 64;
    public static final int INDICATION_COMMENT = 128;
    public static final int INDICATION_GRADIENT = 256;
    protected final Display m_Display = Display.getCurrent();
    protected int m_Style = 0;
    protected int m_alignment = 49;
    protected Color m_bgColor = null;
    protected Color m_fgColor = null;
    protected Font m_font = null;
    private Font m_GCfont;
    private Font m_TMPfont = null;
    protected static final FixedCellRenderer m_FixedRenderer = new FixedCellRenderer(4);
    protected static final TextCellRenderer m_TextRenderer = new TextCellRenderer(16);

    public DefaultCellRenderer(int style) {
        this.m_Style |= style;
    }

    public void setStyle(int style) {
        this.m_Style = style;
    }

    public int getStyle() {
        return this.m_Style;
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
        this.applyFont(gc);
        int result = SWTX.getCachedStringExtent((GC)gc, (String)content.toString()).x + 8;
        this.resetFont(gc);
        return result;
    }

    public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        if (fixed) {
            m_FixedRenderer.drawCell(gc, rect, col, row, content, focus, fixed, clicked, model);
        } else {
            m_TextRenderer.drawCell(gc, rect, col, row, content, focus, fixed, clicked, model);
        }
    }

    protected void drawCellContent(GC gc, Rectangle rect, String text, Image img, Color textColor, Color backColor) {
        gc.setBackground(backColor);
        gc.setForeground(textColor);
        gc.fillRectangle(rect);
        SWTX.drawTextImage(gc, text, this.getAlignment(), img, this.getAlignment(), rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
    }

    protected void drawVerticalCellContent(GC gc, Rectangle rect, String text, Image img, Color textColor, Color backColor) {
        if (rect.height <= 0) {
            rect.height = 1;
        }
        if (rect.width <= 0) {
            rect.width = 1;
        }
        Image vImg = new Image((Device)Display.getCurrent(), rect.height, rect.width);
        GC gcImg = new GC((Drawable)vImg);
        this.applyFont(gcImg);
        gcImg.setBackground(backColor);
        gc.setBackground(backColor);
        gcImg.setForeground(textColor);
        gc.setForeground(textColor);
        gcImg.fillRectangle(vImg.getBounds());
        int alignment = this.mirrorAlignment();
        SWTX.drawTextImage(gcImg, text, alignment, img, alignment, 3, 3, rect.height - 6, rect.width - 6);
        gcImg.dispose();
        Image mirrorImg = this.mirrorImage(vImg);
        gc.drawImage(mirrorImg, rect.x, rect.y);
        vImg.dispose();
        mirrorImg.dispose();
    }

    private int mirrorAlignment() {
        int align = this.getAlignment();
        int result = 0;
        result = (align & 0xF) == 7 ? 48 : ((align & 0xF) == 4 ? 16 : 32);
        result = (align & 0xF0) == 48 ? (result |= 7) : ((align & 0xF0) == 16 ? (result |= 4) : (result |= 1));
        return result |= 0xF00 & align;
    }

    private Image mirrorImage(Image source) {
        Rectangle bounds = source.getBounds();
        ImageData sourceData = source.getImageData();
        ImageData resultData = new ImageData(sourceData.height, sourceData.width, sourceData.depth, sourceData.palette);
        int x = 0;
        while (x < bounds.width) {
            int y = 0;
            while (y < bounds.height) {
                resultData.setPixel(y, resultData.height - x - 1, sourceData.getPixel(x, y));
                ++y;
            }
            ++x;
        }
        source.dispose();
        return new Image((Device)Display.getCurrent(), resultData);
    }

    protected Rectangle drawDefaultSolidCellLine(GC gc, Rectangle rect, Color vBorderColor, Color hBorderColor) {
        return BorderPainter.drawDefaultSolidCellLine(gc, rect, vBorderColor, hBorderColor);
    }

    protected final void drawCommentSign(GC gc, Rectangle rect) {
        gc.setBackground(COLOR_COMMENTSIGN);
        gc.fillPolygon(new int[]{rect.x + rect.width - 4, rect.y + 1, rect.x + rect.width - 1, rect.y + 1, rect.x + rect.width - 1, rect.y + 4});
    }

    public void setAlignment(int style) {
        this.m_alignment = style;
    }

    public int getAlignment() {
        return this.m_alignment;
    }

    public void setForeground(Color fgcolor) {
        this.m_fgColor = fgcolor;
    }

    public void setDefaultForeground(Color fgcolor) {
        this.COLOR_TEXT = fgcolor;
    }

    public void setBackground(Color bgcolor) {
        this.m_bgColor = bgcolor;
    }

    public void setDefaultBackground(Color bgcolor) {
        this.COLOR_BACKGROUND = bgcolor;
    }

    public Color getForeground() {
        if (this.m_fgColor != null) {
            return this.m_fgColor;
        }
        return this.COLOR_TEXT;
    }

    public Color getBackground() {
        if (this.m_bgColor != null) {
            return this.m_bgColor;
        }
        return this.COLOR_BACKGROUND;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public Font getFont() {
        return this.m_font;
    }

    protected void applyFont(GC gc) {
        this.m_GCfont = gc.getFont();
        if (this.m_font == null) {
            this.m_font = Display.getCurrent().getSystemFont();
        }
        if ((this.m_Style & 1) != 0 || (this.m_Style & 2) != 0) {
            FontData[] fd = this.m_font.getFontData();
            int style = 0;
            if ((this.m_Style & 1) != 0) {
                style |= 1;
            }
            if ((this.m_Style & 2) != 0) {
                style |= 2;
            }
            int i = 0;
            while (i < fd.length) {
                fd[i].setStyle(style);
                ++i;
            }
            this.m_TMPfont = new Font((Device)Display.getCurrent(), fd);
            gc.setFont(this.m_TMPfont);
        } else {
            gc.setFont(this.m_font);
        }
    }

    protected void resetFont(GC gc) {
        if (this.m_TMPfont != null) {
            this.m_TMPfont.dispose();
            this.m_TMPfont = null;
        }
        gc.setFont(this.m_GCfont);
    }
}

