/*
 * Decompiled with CFR 0.152.
 */
package de.kupzog.ktable.renderers;

import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.KTableSortedModel;
import de.kupzog.ktable.SWTX;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class FixedCellRenderer
extends DefaultCellRenderer {
    public static final Image IMAGE_ARROWDOWN = SWTX.loadImageResource(Display.getCurrent(), "/icons/arrow_down.gif");
    public static final Image IMAGE_ARROWUP = SWTX.loadImageResource(Display.getCurrent(), "/icons/arrow_up.gif");
    public static final Color COLOR_FIXEDBACKGROUND = Display.getCurrent().getSystemColor(22);

    public FixedCellRenderer(int style) {
        super(style);
        this.m_Style |= 0;
    }

    public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        this.applyFont(gc);
        Color bgColor = this.getBackground();
        Color bottomBorderColor = COLOR_LINE_DARKGRAY;
        Color rightBorderColor = COLOR_LINE_DARKGRAY;
        Color fgColor = this.getForeground();
        if (focus && (this.m_Style & 0x10) != 0) {
            bgColor = COLOR_FIXEDHIGHLIGHT;
            bottomBorderColor = this.COLOR_TEXT;
            rightBorderColor = this.COLOR_TEXT;
        }
        if (focus && (this.m_Style & 0x20) != 0) {
            bgColor = COLOR_BGROWFOCUS;
            bottomBorderColor = COLOR_BGROWFOCUS;
            rightBorderColor = COLOR_BGROWFOCUS;
            fgColor = COLOR_FGROWFOCUS;
        }
        if ((this.m_Style & 4) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, bottomBorderColor, rightBorderColor);
            this.drawCellContent(gc, rect, col, row, content, model, bgColor, fgColor);
        } else {
            this.drawCellButton(gc, rect, "", clicked && (this.m_Style & 0x40) != 0);
            rect.x += 2;
            rect.y += 2;
            rect.width -= 5;
            rect.height -= 5;
            this.drawCellContent(gc, rect, col, row, content, model, bgColor, fgColor);
        }
        this.resetFont(gc);
    }

    protected void drawCellContent(GC gc, Rectangle rect, int col, int row, Object content, KTableModel model, Color bgColor, Color fgColor) {
        int oldWidth = rect.width;
        Image indicator = null;
        int x = 0;
        int y = 0;
        if ((this.m_Style & 8) != 0 && model instanceof KTableSortedModel && ((KTableSortedModel)model).getSortColumn() == col && model.getFixedHeaderRowCount() > row && row == 0) {
            int sort = ((KTableSortedModel)model).getSortState();
            if (sort == 1) {
                indicator = IMAGE_ARROWDOWN;
            } else if (sort == 2) {
                indicator = IMAGE_ARROWUP;
            }
            if (indicator != null) {
                int contentLength = rect.x + 11 + gc.stringExtent((String)content.toString()).x;
                x = rect.x + rect.width - 8;
                if (contentLength < x) {
                    x = contentLength;
                } else {
                    rect.width -= indicator.getBounds().width + 8;
                }
                y = rect.y + rect.height / 2 - indicator.getBounds().height / 2;
                if (rect.width + 4 < indicator.getBounds().width) {
                    rect.width += indicator.getBounds().width + 8;
                    indicator = null;
                }
            }
        }
        this.drawCellContent(gc, rect, content.toString(), null, fgColor, bgColor);
        if (indicator != null) {
            gc.fillRectangle(rect.x + rect.width, rect.y, Math.min(indicator.getBounds().width + 8, oldWidth - rect.width - 1), rect.height);
            gc.drawImage(indicator, x, y);
        }
    }

    protected void drawCellButton(GC gc, Rectangle rect, String text, boolean pressed) {
        ++rect.height;
        ++rect.width;
        gc.setForeground(Display.getCurrent().getSystemColor(24));
        if (pressed) {
            SWTX.drawButtonDown(gc, text, this.getAlignment(), null, this.getAlignment(), rect);
        } else {
            SWTX.drawButtonUp(gc, text, this.getAlignment(), null, this.getAlignment(), rect);
        }
    }

    public Color getBackground() {
        if (this.m_bgColor != null) {
            return this.m_bgColor;
        }
        return COLOR_FIXEDBACKGROUND;
    }
}

