/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.activitydiagram;

import com.modeliosoft.modelio.api.model.diagrams.IActivityDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivity;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehaviorParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.diagram.editor.activity.elements.activitydiagram.GmActivityDiagram;
import com.modeliosoft.modelio.diagram.editor.activity.elements.activitydiagram.SmartObjectNodeCommand;
import com.modeliosoft.modelio.diagram.editor.activity.elements.commands.CreateActivityParameterNodeCommand;
import com.modeliosoft.modelio.diagram.editor.activity.elements.commands.CreateCallBehaviorCommand;
import com.modeliosoft.modelio.diagram.editor.activity.elements.commands.CreateCallOperationCommand;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.PartitionToolKind;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class ActivityDiagramElementDropEditPolicy
extends DiagramElementDropEditPolicy {
    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        GmActivityDiagram gmDiagram = (GmActivityDiagram)this.getHost().getModel();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (!(gmDiagram.canUnmask(droppedElement) || droppedElement instanceof IOperation && request.isSmart() || droppedElement instanceof IBehavior && request.isSmart() || droppedElement instanceof IBehaviorParameter && request.isSmart() || this.isSmartObjectNodeTarget(droppedElement, request))) {
                return null;
            }
            ++n2;
        }
        return this.getHost();
    }

    protected Command getDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            if (toUnmask instanceof IActivityPartition) {
                command.add(this.getPartitionDropCommand(dropLocation, (IActivityPartition)toUnmask));
            } else if (toUnmask instanceof IOperation && request.isSmart()) {
                command.add(this.getOperationDropCommand(dropLocation, (IOperation)toUnmask));
            } else if (toUnmask instanceof IBehavior && request.isSmart()) {
                command.add(this.getBehaviorDropCommand(dropLocation, (IBehavior)toUnmask));
            } else if (toUnmask instanceof IBehaviorParameter) {
                command.add(this.getBehaviorParameterDropCommand(dropLocation, (IBehaviorParameter)toUnmask));
            } else if (this.isSmartObjectNodeTarget(toUnmask, request)) {
                command.add(this.getSmartObjectNodeDropCommand(dropLocation, toUnmask));
            } else if (toUnmask != null) {
                this.createSubRequest(request, command, dropLocation, toUnmask);
            }
            dropLocation = dropLocation.getTranslated(20, 20);
            ++n2;
        }
        return command;
    }

    private Command getPartitionDropCommand(Point dropLocation, IActivityPartition partitionToUnmask) {
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(dropLocation);
        creationRequest.setSize(new Dimension(-1, -1));
        ModelioCreationContext gmCreationContext = new ModelioCreationContext((IElement)partitionToUnmask);
        if (((IActivityDiagram)((GmActivityDiagram)this.getHost().getModel()).getRelatedIElement()).isVertical()) {
            gmCreationContext.setProperty("kind", (Object)PartitionToolKind.VERTICAL_CONTAINER.toString());
        } else {
            gmCreationContext.setProperty("kind", (Object)PartitionToolKind.HORIZONTAL_CONTAINER.toString());
        }
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        return this.getHost().getCommand((Request)creationRequest);
    }

    private Command getBehaviorParameterDropCommand(Point dropLocation, IBehaviorParameter toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IActivityDiagram diag = (IActivityDiagram)gmDiagram.getRelatedIElement();
        IActivity owner = (IActivity)diag.getOrigin();
        return new CreateActivityParameterNodeCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private Command getOperationDropCommand(Point dropLocation, IOperation toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IActivityDiagram diag = (IActivityDiagram)gmDiagram.getRelatedIElement();
        IActivity owner = (IActivity)diag.getOrigin();
        return new CreateCallOperationCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private Command getBehaviorDropCommand(Point dropLocation, IBehavior toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IActivityDiagram diag = (IActivityDiagram)gmDiagram.getRelatedIElement();
        IActivity owner = (IActivity)diag.getOrigin();
        return new CreateCallBehaviorCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private Command getSmartObjectNodeDropCommand(Point dropLocation, IElement toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IActivityDiagram diag = (IActivityDiagram)gmDiagram.getRelatedIElement();
        IActivity owner = (IActivity)diag.getOrigin();
        return new SmartObjectNodeCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private boolean isSmartObjectNodeTarget(IElement element, ModelElementDropRequest request) {
        if (!request.isSmart()) {
            return false;
        }
        return element instanceof IAssociationEnd || element instanceof IAttribute || element instanceof IInstance || element instanceof IGeneralClass || element instanceof IParameter;
    }

    private void createSubRequest(ModelElementDropRequest request, CompoundCommand command, Point dropLocation, IElement toUnmask) {
        ModelElementDropRequest subReq = new ModelElementDropRequest();
        subReq.setDroppedElements(new IElement[]{toUnmask});
        subReq.setExtendedData(request.getExtendedData());
        subReq.setLocation(dropLocation);
        subReq.isSmart(request.isSmart());
        command.add(super.getDropCommand(subReq));
    }
}

