/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.activitydiagram;

import com.modeliosoft.modelio.api.model.diagrams.IActivityDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.editor.activity.elements.activitydiagram.ActivityDiagramEditPart;
import com.modeliosoft.modelio.diagram.editor.activity.elements.activitydiagram.GmActivityDiagram;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.PartitionToolKind;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partitioncontainer.GmDiagramPartitionContainer;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partitioncontainer.GmPartitionContainer;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class CreatePartitionContainerCommand
extends Command {
    private boolean vertical;
    private ModelioCreationContext context;
    private Rectangle constraint;
    private GmActivityDiagram parentDiagram;
    private CreateRequest originalRequest;
    private Map<?, ?> editPartRegistry;

    public CreatePartitionContainerCommand(CreateRequest originalRequest, ActivityDiagramEditPart parentDiagramEditPart, ModelioCreationContext context, Rectangle constraint, boolean vertical) {
        this.originalRequest = originalRequest;
        this.editPartRegistry = parentDiagramEditPart.getViewer().getEditPartRegistry();
        this.parentDiagram = (GmActivityDiagram)parentDiagramEditPart.getModel();
        this.context = context;
        this.constraint = constraint;
        this.vertical = vertical;
    }

    public void execute() {
        IModelElement parentElement = ((IActivityDiagram)this.parentDiagram.getRelatedIElement()).getOrigin();
        IActivityPartition partition = (IActivityPartition)this.context.getElementToUnmask();
        if (partition != null) {
            this.executeUnmasking((IElement)parentElement, partition);
        } else {
            this.executeActualCreation((IElement)parentElement);
        }
    }

    private void executeUnmasking(IElement parentElement, IActivityPartition partition) {
        IActivityPartition topLevelPartition = partition;
        while (topLevelPartition.getSuperPartition() != null) {
            topLevelPartition = topLevelPartition.getSuperPartition();
        }
        GmCompositeNode topLevelBodyGm = null;
        List models = this.parentDiagram.getAllGMRepresenting(new ObRef((IElement)topLevelPartition));
        if (!models.isEmpty()) {
            topLevelBodyGm = ((GmCompositeNode)models.get(0)).getCompositeFor(IActivityPartition.class);
        } else {
            GmNodeModel createdModel = this.parentDiagram.unmask((GmCompositeNode)this.parentDiagram, (IElement)topLevelPartition, (Object)this.constraint);
            if (createdModel instanceof GmDiagramPartitionContainer) {
                ((GmPartitionContainer)createdModel).setVertical(!this.vertical);
            }
            if (topLevelPartition == partition) {
                return;
            }
            models = this.parentDiagram.getAllGMRepresenting(new ObRef((IElement)topLevelPartition));
            if (!models.isEmpty()) {
                topLevelBodyGm = ((GmCompositeNode)models.get(0)).getCompositeFor(IActivityPartition.class);
            }
        }
        assert (topLevelBodyGm != null) : "CreatePartitionContainerCommand#executeUnmasking: could not find a valid Gm for body of top level super partition of : " + partition.getName();
        EditPart topLevelPartitionBodyEditPart = (EditPart)this.editPartRegistry.get(topLevelBodyGm);
        this.context.setProperty("kind", (Object)PartitionToolKind.INNER.toString());
        Command command = topLevelPartitionBodyEditPart.getCommand((Request)this.originalRequest);
        if (command != null && command.canExecute()) {
            command.execute();
        }
    }

    private void executeActualCreation(IElement parentElement) {
        IModelFactory modelFactory = this.parentDiagram.getModelFactory();
        IActivityPartition partition1 = modelFactory.createActivityPartition();
        IActivityPartition partition2 = modelFactory.createActivityPartition();
        Meta meta = new Meta(parentElement);
        try {
            meta.appendToDependency(this.context.getDependency(), (IElement)partition1);
            meta.appendToDependency(this.context.getDependency(), (IElement)partition2);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)parentElement, (IElement)partition1);
            if (compositionDep != null && !compositionDep.equals("")) {
                meta.appendToDependency(compositionDep, (IElement)partition1);
                meta.appendToDependency(compositionDep, (IElement)partition2);
            }
            modelFactory.deleteElement((IElement)partition1);
            modelFactory.deleteElement((IElement)partition2);
            return;
        }
        if (this.context.getStereotype() != null) {
            partition1.addExtension(this.context.getStereotype());
            partition2.addExtension(this.context.getStereotype());
        }
        IElementInitializer elementInitializer = this.parentDiagram.getElementInitializer();
        elementInitializer.initialize((IElement)partition1, this.context.getProperties());
        elementInitializer.initialize((IElement)partition2, this.context.getProperties());
        GmPartitionContainer partitionContainer = (GmPartitionContainer)this.parentDiagram.unmask((GmCompositeNode)this.parentDiagram, (IElement)partition1, (Object)this.constraint);
        this.parentDiagram.unmask((GmCompositeNode)partitionContainer, (IElement)partition2, (Object)this.constraint);
        partitionContainer.setVertical(!this.vertical);
        Integer partitionConstraint = this.constraint.width / partitionContainer.getChildren().size();
        for (GmNodeModel gmPartition : partitionContainer.getChildren()) {
            gmPartition.setLayoutData((Object)partitionConstraint);
        }
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.parentDiagram)) {
            return false;
        }
        IModelElement parentElement = ((IActivityDiagram)this.parentDiagram.getRelatedIElement()).getOrigin();
        return parentElement != null && parentElement.isValid() && parentElement.getElementStatus().isModifiable();
    }
}

