/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.activitydiagram;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivity;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IInstanceNode;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehaviorParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class SmartObjectNodeCommand
extends Command {
    private IElement parentElement;
    private IElement toUnmask;
    private Point location;
    private EditPart parentEditPart;

    public SmartObjectNodeCommand(Point dropLocation, IElement toUnmask, EditPart parentEditPart, IElement parentElement) {
        this.location = dropLocation;
        this.toUnmask = toUnmask;
        this.parentEditPart = parentEditPart;
        this.parentElement = parentElement;
    }

    public void execute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IInstanceNode instanceNode = factory.createInstanceNode();
        String effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)instanceNode);
        if (effectiveDependency == null || effectiveDependency.isEmpty()) {
            throw new IllegalStateException("Cannot find a composition dependency to attach " + instanceNode.toString() + " to " + this.parentElement.toString());
        }
        Meta meta = new Meta(this.parentElement);
        meta.appendToDependency(effectiveDependency, (IElement)instanceNode);
        if (this.toUnmask instanceof IInstance) {
            instanceNode.setRepresented((IInstance)this.toUnmask);
        } else if (this.toUnmask instanceof IAttribute) {
            instanceNode.setRepresentedAttribute((IAttribute)this.toUnmask);
        } else if (this.toUnmask instanceof IAssociationEnd) {
            instanceNode.setRepresentedRole((IAssociationEnd)this.toUnmask);
        } else if (this.toUnmask instanceof IGeneralClass) {
            instanceNode.setType((IGeneralClass)this.toUnmask);
        } else if (this.toUnmask instanceof IParameter) {
            IActivity owningActivity = null;
            IElement tmp = this.parentElement;
            while (tmp != null) {
                if (tmp instanceof IActivity) {
                    owningActivity = (IActivity)tmp;
                    break;
                }
                tmp = tmp.getCompositionOwner();
            }
            if (owningActivity != null) {
                IBehaviorParameter behaviorParameter = factory.createBehaviorParameter();
                behaviorParameter.setOwner((IBehavior)owningActivity);
                behaviorParameter.setMapped((IParameter)this.toUnmask);
                instanceNode.setRepresentedRealParameter(behaviorParameter);
            }
        }
        gmDiagram.getElementInitializer().initialize((IElement)instanceNode);
        this.unmaskElement((IElement)instanceNode);
    }

    private void unmaskElement(IElement el) {
        ModelioCreationContext gmCreationContext = new ModelioCreationContext(el);
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(this.location);
        creationRequest.setSize(new Dimension(-1, -1));
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        Command cmd = this.parentEditPart.getTargetEditPart((Request)creationRequest).getCommand((Request)creationRequest);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }

    public boolean canExecute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmDiagram)) {
            return false;
        }
        return this.parentElement != null && this.parentElement.isValid() && this.parentElement.getElementStatus().isModifiable();
    }
}

