/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.commands;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityParameterNode;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehaviorParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class CreateActivityParameterNodeCommand
extends Command {
    private EditPart parentEditPart;
    private IBehaviorParameter toUnmask;
    private Point dropLocation;
    private IElement parentElement;

    public CreateActivityParameterNodeCommand(Point dropLocation, IBehaviorParameter toUnmask, EditPart editPart, IElement parentElement) {
        this.toUnmask = toUnmask;
        this.dropLocation = dropLocation;
        this.parentEditPart = editPart;
        this.parentElement = parentElement;
    }

    public void execute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IActivityParameterNode el = factory.createActivityParameterNode();
        String effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)el);
        if (effectiveDependency == null || effectiveDependency.isEmpty()) {
            throw new IllegalStateException("Cannot find a composition dependency to attach " + el.toString() + " to " + this.parentElement.toString());
        }
        Meta meta = new Meta(this.parentElement);
        meta.appendToDependency(effectiveDependency, (IElement)el);
        el.setRepresentedRealParameter(this.toUnmask);
        el.setName(this.toUnmask.getName());
        this.unmaskElement((IElement)el);
    }

    private void unmaskElement(IElement el) {
        ModelioCreationContext gmCreationContext = new ModelioCreationContext(el);
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(this.dropLocation);
        creationRequest.setSize(new Dimension(-1, -1));
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        Command cmd = this.parentEditPart.getTargetEditPart((Request)creationRequest).getCommand((Request)creationRequest);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }

    public boolean canExecute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmModel.getDiagram())) {
            return false;
        }
        return this.parentElement != null && this.parentElement.isValid() && this.parentElement.getElementStatus().isModifiable();
    }
}

