/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.conditional;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IClause;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IConditionalNode;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.activity.elements.clause.GmClause;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.resizablegroup.GmResizableGroup;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmClausesGroup
extends GmResizableGroup {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmClausesGroup(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public GmClausesGroup() {
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return GmClause.class.isAssignableFrom(nodeClass);
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return IClause.class.isAssignableFrom(type);
    }

    public boolean canUnmask(IElement el) {
        return IClause.class.isAssignableFrom(el.getClass()) && el.getCompositionOwner().equals((Object)this.getRelatedIElement());
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        IConditionalNode conditional = (IConditionalNode)this.getRelatedIElement();
        if (conditional != null && conditional.isValid()) {
            for (IClause part : conditional.getOwnedClause()) {
                if (this.getChild(new ObRef((IElement)part)) != null) continue;
                this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
            }
        }
    }

    protected final boolean isValidChild(GmNodeModel node) {
        IElement el = node.getRelatedIElement();
        if (el == null || !el.isValid() || !this.canUnmask(el)) {
            return false;
        }
        GmNodeModel sameChild = this.getChild(node.getRepresentedRef());
        return sameChild == null || sameChild == node;
    }

    public boolean isVisible() {
        return this.getParent().getRepresentationMode().equals((Object)StyleKey.RepresentationMode.STRUCTURED);
    }

    protected void doSetVisible(boolean visible) {
        StyleKey key;
        if (visible && (key = this.getStyleKey(MetaKey.REPMODE)) != null) {
            this.getParent().getStyle().setProperty(key, (Object)StyleKey.RepresentationMode.STRUCTURED);
        }
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmClausesGroup.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmClausesGroup.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

