/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.datastore;

import com.modeliosoft.modelio.diagram.editor.activity.elements.datastore.GmDataStore;
import com.modeliosoft.modelio.diagram.editor.activity.elements.datastore.GmDataStorePrimaryNode;
import com.modeliosoft.modelio.diagram.editor.activity.elements.datastore.v0._GmDataStore;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.persistence.IPersistentMigrator;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmDataStoreMigrator
implements IPersistentMigrator {
    public IPersistent createInstanceOfMajorVersion(int majorVersionToInstantiate) {
        switch (majorVersionToInstantiate) {
            case 0: {
                return new _GmDataStore();
            }
        }
        return null;
    }

    public IPersistent migrate(IPersistent instanceToMigrate) {
        if (instanceToMigrate.getMajorVersion() == 0) {
            return this.migrateFromV0(instanceToMigrate);
        }
        return null;
    }

    private IPersistent migrateFromV0(IPersistent instanceToMigrate) {
        _GmDataStore oldDataStore = (_GmDataStore)instanceToMigrate;
        GmDataStore newDataStore = new GmDataStore(oldDataStore);
        newDataStore.setLayoutData(oldDataStore.getLayoutData());
        newDataStore.setRoleInComposition(oldDataStore.getRoleInComposition());
        GmDataStorePrimaryNode newPrimaryNode = newDataStore.getMainNode();
        for (IGmLink link : oldDataStore.getStartingLinks()) {
            oldDataStore.removeStartingLink(link);
            newPrimaryNode.addStartingLink(link);
        }
        for (IGmLink link : oldDataStore.getEndingLinks()) {
            oldDataStore.removeEndingLink(link);
            newPrimaryNode.addEndingLink(link);
        }
        newDataStore.getStyle().setCascadedStyle(oldDataStore.getStyle().getCascadedStyle());
        for (StyleKey key : oldDataStore.getStyle().getLocalKeys()) {
            newDataStore.getStyle().setProperty(key, oldDataStore.getStyle().getProperty(key));
        }
        oldDataStore.delete();
        return newDataStore;
    }
}

