/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.figures;

import com.modeliosoft.modelio.diagram.elements.core.figures.EllipseShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.IShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.ShapedFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.ShapedBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class FinalNodeFigure
extends ShapedFigure {
    private ShapedBorder shapedBorder;
    private final int MARGIN = 4;

    public FinalNodeFigure() {
        super((IShaper)new EllipseShaper());
        this.setOpaque(true);
        this.shapedBorder = new ShapedBorder(this.penOptions.lineColor, this.penOptions.lineWidth, this.shaper);
        this.setBorder((Border)this.shapedBorder);
    }

    public void setLineColor(Color lineColor) {
        if (this.penOptions.lineColor != lineColor) {
            this.shapedBorder.setColor(lineColor);
            super.setLineColor(lineColor);
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.penOptions.lineWidth != lineWidth) {
            this.shapedBorder.setWidth(lineWidth);
            super.setLineWidth(lineWidth);
        }
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle innerRect = this.getBounds().getCopy().shrink(4, 4);
        graphics.setClip(this.shaper.getShapePath(innerRect));
        if (this.isOpaque() && this.brushOptions.fillColor != null) {
            Color base = this.brushOptions.fillColor;
            Color gradientColor = this.brushOptions.useGradient ? this.computeGradientColor(base) : base;
            graphics.setBackgroundColor(gradientColor);
            graphics.setForegroundColor(base);
            if (this.brushOptions.useGradient) {
                graphics.fillGradient(innerRect, false);
                gradientColor.dispose();
            } else {
                graphics.fillRectangle(innerRect);
            }
        }
        graphics.restoreState();
    }
}

