/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.objectnode;

import com.modeliosoft.modelio.diagram.editor.activity.elements.objectnode.GmObjectNode;
import com.modeliosoft.modelio.diagram.editor.activity.elements.objectnode.GmObjectNodePrimaryNode;
import com.modeliosoft.modelio.diagram.editor.activity.elements.objectnode.v0._GmObjectNode;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.persistence.IPersistentMigrator;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmObjectNodeMigrator
implements IPersistentMigrator {
    public IPersistent createInstanceOfMajorVersion(int majorVersionToInstantiate) {
        switch (majorVersionToInstantiate) {
            case 0: {
                return new _GmObjectNode();
            }
        }
        return null;
    }

    public IPersistent migrate(IPersistent instanceToMigrate) {
        if (instanceToMigrate.getMajorVersion() == 0) {
            return this.migrateFromV0(instanceToMigrate);
        }
        return null;
    }

    private IPersistent migrateFromV0(IPersistent instanceToMigrate) {
        _GmObjectNode oldObjectNode = (_GmObjectNode)instanceToMigrate;
        GmObjectNode newObjectNode = new GmObjectNode(oldObjectNode);
        newObjectNode.setLayoutData(oldObjectNode.getLayoutData());
        newObjectNode.setRoleInComposition(oldObjectNode.getRoleInComposition());
        GmObjectNodePrimaryNode newPrimaryNode = newObjectNode.getMainNode();
        for (IGmLink link : oldObjectNode.getStartingLinks()) {
            oldObjectNode.removeStartingLink(link);
            newPrimaryNode.addStartingLink(link);
        }
        for (IGmLink link : oldObjectNode.getEndingLinks()) {
            oldObjectNode.removeEndingLink(link);
            newPrimaryNode.addEndingLink(link);
        }
        newObjectNode.getStyle().setCascadedStyle(oldObjectNode.getStyle().getCascadedStyle());
        for (StyleKey key : oldObjectNode.getStyle().getLocalKeys()) {
            newObjectNode.getStyle().setProperty(key, oldObjectNode.getStyle().getProperty(key));
        }
        oldObjectNode.delete();
        return newObjectNode;
    }
}

