/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.partition;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityEdge;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IPin;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.GmPartitionStructuredStyleKeys;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.bodyhybridcontainer.GmBodyHybridContainer;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.header.GmPartitionHeader;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partitioncontainer.GmPartitionContainer;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.List;

public class GmPartition
extends GmCompositeNode {
    IActivityPartition element;
    private static GmPartitionStructuredStyleKeys STRUCTKEYS = new GmPartitionStructuredStyleKeys();
    private GmPartitionHeader header;
    private GmPartitionContainer body;
    private boolean vertical;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmPartition(GmAbstractDiagram diagram, IActivityPartition thePartition, ObRef ref) {
        super(diagram, ref);
        this.element = thePartition;
        this.header = new GmPartitionHeader(diagram, ref);
        this.body = new GmBodyHybridContainer(diagram, ref);
        super.addChild((GmNodeModel)this.header);
        super.addChild((GmNodeModel)this.body);
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return this.acceptMetaclass(type);
    }

    public boolean canUnmask(IElement el) {
        Class<?> type = el.getClass();
        return el.getCompositionOwner().equals((Object)this.element) && this.acceptMetaclass(type);
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        return STRUCTKEYS.getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        return STRUCTKEYS.getStyleKeys();
    }

    public StyleKey.RepresentationMode getRepresentationMode() {
        return StyleKey.RepresentationMode.STRUCTURED;
    }

    public GmCompositeNode getCompositeFor(Class<? extends IElement> metaclass) {
        if (this.acceptMetaclass(metaclass)) {
            return this.body;
        }
        return null;
    }

    public GmPartition() {
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmPartition.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public GmCompositeNode getContentsArea() {
        return this.body;
    }

    private boolean acceptMetaclass(Class<? extends IElement> type) {
        boolean accept = false;
        if (this.body.getChildren("SubPartition").isEmpty()) {
            accept = IActivityNode.class.isAssignableFrom(type) && !IPin.class.isAssignableFrom(type) || IActivityEdge.class.isAssignableFrom(type);
        }
        accept = accept || IActivityPartition.class.isAssignableFrom(type);
        return accept;
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("isVertical", this.vertical ? Boolean.TRUE : Boolean.FALSE);
        if (false) {
            out.writeProperty("GmPartition.version", (Object)0);
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
        this.header.setVertical(this.vertical);
        this.body.setVertical(!this.vertical);
        super.removeChild((GmNodeModel)this.header);
        super.removeChild((GmNodeModel)this.body);
        super.addChild((GmNodeModel)this.header);
        super.addChild((GmNodeModel)this.body);
    }

    public IElement getRepresentedIElement() {
        return this.element;
    }

    public IElement getRelatedIElement() {
        return this.getRepresentedIElement();
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.header = (GmPartitionHeader)this.getChildren().get(0);
        this.body = (GmPartitionContainer)this.getChildren().get(1);
        this.element = (IActivityPartition)this.resolveRef(this.getRepresentedRef());
        this.vertical = (Boolean)in.readProperty("isVertical");
    }

    public int getMajorVersion() {
        return 0;
    }
}

