/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.partition.header;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.header.GmPartitionHeader;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.header.PartitionSymbolProvider;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.header.GmDefaultModelElementHeader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import org.eclipse.swt.graphics.Image;

public class GmPartitionHeader
extends GmDefaultModelElementHeader {
    private boolean vertical = true;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    protected IStyle createStyle(GmAbstractDiagram gmAbstractDiagram) {
        return new GmPartitionHeaderStyle(gmAbstractDiagram.getStyle());
    }

    public GmPartitionHeader() {
    }

    public GmPartitionHeader(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmPartitionHeader.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("isVertical", this.vertical ? Boolean.TRUE : Boolean.FALSE);
        if (false) {
            out.writeProperty("GmPartitionHeader.version", (Object)0);
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public void refreshFromObModel() {
        IActivityPartition partition = (IActivityPartition)this.getRelatedIElement();
        if (partition != null && partition.isValid()) {
            this.setShowMetaclassIcon(partition.getRepresented() != null);
        } else {
            this.setShowMetaclassIcon(false);
        }
        super.refreshFromObModel();
    }

    protected Image getMetaclassIcon() {
        IActivityPartition partition = (IActivityPartition)this.getRelatedIElement();
        IModelElement represented = partition.getRepresented();
        if (represented != null) {
            return this.getDiagram().getImageServices().getStereotypeIcon((IElement)represented);
        }
        return this.getDiagram().getImageServices().getStereotypeIcon((IElement)partition);
    }

    protected String computeMainLabel() {
        IActivityPartition partition = (IActivityPartition)this.getRelatedIElement();
        return PartitionSymbolProvider.computeSimpleLabel((IActivityPartition)partition);
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.vertical = (Boolean)in.readProperty("isVertical");
    }

    public int getMajorVersion() {
        return 0;
    }
}

