/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.partitioncontainer;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class CreatePartitionInPartitionContainerCommand
extends Command {
    private ModelioCreationContext context;
    private GmNodeModel insertAfter;
    private IElement parentElement;
    private GmCompositeNode parentNode;
    private int newConstraint;
    private CreateRequest originalRequest;
    private Map<?, ?> editPartRegistry;

    public CreatePartitionInPartitionContainerCommand(CreateRequest originalRequest, EditPart parentEditPart, ModelioCreationContext context, GmNodeModel insertAfter, int newConstraint) {
        this.originalRequest = originalRequest;
        this.editPartRegistry = parentEditPart.getViewer().getEditPartRegistry();
        this.parentNode = (GmCompositeNode)parentEditPart.getModel();
        this.parentElement = this.parentNode.getRelatedIElement();
        if (this.parentElement instanceof IAbstractDiagram) {
            this.parentElement = ((IAbstractDiagram)this.parentElement).getOrigin();
        }
        this.context = context;
        this.insertAfter = insertAfter;
        this.newConstraint = newConstraint;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IActivityPartition newElement = (IActivityPartition)this.context.getElementToUnmask();
        if (newElement != null) {
            this.executeUnmask(diagram, newElement);
        } else {
            this.executeCreation(diagram);
        }
    }

    private void executeUnmask(GmAbstractDiagram diagram, IActivityPartition requestedPartition) {
        IActivityPartition partitionToUnmask = requestedPartition;
        while (partitionToUnmask.getSuperPartition() != null && !partitionToUnmask.getSuperPartition().equals((Object)this.parentElement)) {
            partitionToUnmask = partitionToUnmask.getSuperPartition();
        }
        GmCompositeNode newChild = this.unmaskAdditionalChild(diagram, partitionToUnmask);
        if (!partitionToUnmask.equals((Object)requestedPartition)) {
            assert (newChild != null) : "CreatePartitionInPartitionContainerCommand#executeUnmask: could not find a valid Gm for partition: " + partitionToUnmask.getName();
            GmCompositeNode newChildBody = newChild.getCompositeFor(IActivityPartition.class);
            EditPart newChildBodyEditPart = (EditPart)this.editPartRegistry.get(newChildBody);
            Command command = newChildBodyEditPart.getCommand((Request)this.originalRequest);
            if (command != null && command.canExecute()) {
                command.execute();
            }
        }
    }

    private void executeCreation(GmAbstractDiagram diagram) {
        IModelFactory modelFactory = diagram.getModelFactory();
        IActivityPartition newElement = (IActivityPartition)modelFactory.createElement(this.context.getMetaclass());
        Meta meta = new Meta(this.parentElement);
        try {
            meta.appendToDependency(this.context.getDependency(), (IElement)newElement);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement);
            if (compositionDep != null && !compositionDep.equals("")) {
                meta.appendToDependency(compositionDep, (IElement)newElement);
            }
            modelFactory.deleteElement((IElement)newElement);
            return;
        }
        if (this.context.getStereotype() != null) {
            newElement.addExtension(this.context.getStereotype());
        }
        IElementInitializer elementInitializer = diagram.getElementInitializer();
        elementInitializer.initialize((IElement)newElement, this.context.getProperties());
        int nbOfChildren = this.parentNode.getChildren("SubPartition").size();
        if (nbOfChildren == 0) {
            this.createAndUnmaskFirstPairOfSubPartitions(diagram, newElement);
            return;
        }
        this.unmaskAdditionalChild(diagram, newElement);
    }

    private void createAndUnmaskFirstPairOfSubPartitions(GmAbstractDiagram diagram, IActivityPartition newElement) {
        IModelFactory modelFactory = diagram.getModelFactory();
        IActivityPartition newElement2 = (IActivityPartition)modelFactory.createElement(this.context.getMetaclass());
        Meta meta = new Meta(this.parentElement);
        try {
            meta.appendToDependency(this.context.getDependency(), (IElement)newElement2);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement2);
            if (compositionDep != null && !compositionDep.equals("")) {
                meta.appendToDependency(compositionDep, (IElement)newElement2);
            }
            modelFactory.deleteElement((IElement)newElement);
            modelFactory.deleteElement((IElement)newElement2);
            return;
        }
        if (this.context.getStereotype() != null) {
            newElement2.addExtension(this.context.getStereotype());
        }
        IElementInitializer elementInitializer = diagram.getElementInitializer();
        elementInitializer.initialize((IElement)newElement2, this.context.getProperties());
        diagram.unmask(this.parentNode, (IElement)newElement, (Object)this.newConstraint);
        diagram.unmask(this.parentNode, (IElement)newElement2, (Object)this.newConstraint);
    }

    private GmCompositeNode unmaskAdditionalChild(GmAbstractDiagram diagram, IActivityPartition newElement) {
        int nbOfChildren = this.parentNode.getChildren("SubPartition").size();
        for (GmNodeModel child : this.parentNode.getChildren("SubPartition")) {
            Integer childConstraint = (Integer)child.getLayoutData();
            if (childConstraint == -1) continue;
            childConstraint = childConstraint * nbOfChildren / (nbOfChildren + 1);
            child.setLayoutData((Object)childConstraint);
        }
        GmCompositeNode newChild = (GmCompositeNode)diagram.unmask(this.parentNode, (IElement)newElement, (Object)this.newConstraint);
        this.parentNode.moveChild((GmNodeModel)newChild, this.parentNode.getChildren().indexOf(this.insertAfter));
        return newChild;
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.parentNode.getDiagram())) {
            return false;
        }
        IActivityPartition newElement = (IActivityPartition)this.context.getElementToUnmask();
        if (newElement != null) {
            return true;
        }
        return AuthHelper.canAdd((IElement)this.parentElement, (String)"ActivityPartition");
    }
}

