/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.partitioncontainer;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.GmPartition;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GmPartitionContainer
extends GmCompositeNode {
    private boolean vertical;
    public static final String SUB_PARTITION = "SubPartition";
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmCompositeNode getCompositeFor(Class<? extends IElement> metaclass) {
        if (IActivityPartition.class.isAssignableFrom(metaclass)) {
            return this;
        }
        return null;
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return IActivityPartition.class.isAssignableFrom(type);
    }

    public boolean canUnmask(IElement el) {
        return IActivityPartition.class.isAssignableFrom(el.getClass()) && el.getCompositionOwner().equals((Object)this.getRelatedIElement());
    }

    public StyleKey.RepresentationMode getRepresentationMode() {
        return StyleKey.RepresentationMode.STRUCTURED;
    }

    public GmPartitionContainer(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public GmPartitionContainer() {
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmPartitionContainer.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("isVertical", this.vertical ? Boolean.TRUE : Boolean.FALSE);
        if (false) {
            out.writeProperty("GmPartitionContainer.version", (Object)0);
        }
    }

    public List<GmPartition> getPartitions() {
        ArrayList<GmPartition> partitions = new ArrayList<GmPartition>();
        for (GmNodeModel p : this.getChildren()) {
            partitions.add((GmPartition)p);
        }
        return partitions;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean value) {
        if (this.vertical != value) {
            this.vertical = value;
            for (GmNodeModel child : this.getChildren()) {
                if (!(child instanceof GmPartition)) continue;
                ((GmPartition)child).setVertical(!this.vertical);
            }
            this.firePropertyChange("LayoutData", null, this.getLayoutData());
        }
    }

    public void addChild(GmNodeModel child) {
        if (child instanceof GmPartition) {
            child.setRoleInComposition(SUB_PARTITION);
            ((GmPartition)child).setVertical(!this.vertical);
        }
        super.addChild(child);
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        return null;
    }

    public List<StyleKey> getStyleKeys() {
        return Collections.emptyList();
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.vertical = (Boolean)in.readProperty("isVertical");
    }

    public int getMajorVersion() {
        return 0;
    }
}

