/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.partitioncontainer;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.PartitionToolKind;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partitioncontainer.GmPartitionContainer;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class PartitionDropEditPolicy
extends GraphicalEditPolicy {
    private RectangleFigure highlight;

    private EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        GmModel hostModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram diagram = hostModel.getDiagram();
        IElement hostElement = hostModel.getRelatedIElement();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (!(droppedElement instanceof IActivityPartition)) {
                return null;
            }
            IActivityPartition droppedPartition = (IActivityPartition)droppedElement;
            IActivityPartition ancestorPartition = droppedPartition.getSuperPartition();
            while (ancestorPartition != null) {
                if (ancestorPartition.equals((Object)hostElement)) break;
                if (!diagram.getAllGMRepresenting(new ObRef((IElement)ancestorPartition)).isEmpty()) {
                    return null;
                }
                ancestorPartition = ancestorPartition.getSuperPartition();
            }
            if (ancestorPartition == null) {
                return null;
            }
            ++n2;
        }
        return this.getHost();
    }

    private Command getDropCommand(ModelElementDropRequest request) {
        GmPartitionContainer hostModel = (GmPartitionContainer)this.getHost().getModel();
        GmAbstractDiagram diagram = hostModel.getDiagram();
        IActivityPartition hostPartition = (IActivityPartition)hostModel.getRelatedIElement();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (!(droppedElement instanceof IActivityPartition)) {
                return null;
            }
            IActivityPartition droppedPartition = (IActivityPartition)droppedElement;
            IActivityPartition ancestorPartition = droppedPartition.getSuperPartition();
            while (ancestorPartition != null) {
                if (ancestorPartition.equals((Object)hostPartition)) break;
                if (!diagram.getAllGMRepresenting(new ObRef((IElement)ancestorPartition)).isEmpty()) {
                    return null;
                }
                ancestorPartition = ancestorPartition.getSuperPartition();
            }
            if (ancestorPartition == null) {
                return null;
            }
            ++n2;
        }
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        IElement[] iElementArray2 = request.getDroppedElements();
        int n3 = iElementArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            IElement toUnmask = iElementArray2[n4];
            CreateRequest req = new CreateRequest();
            req.setLocation(dropLocation);
            req.setSize(new Dimension(-1, -1));
            ModelioCreationContext gmCreationContext = new ModelioCreationContext(toUnmask);
            gmCreationContext.setProperty("kind", (Object)PartitionToolKind.INNER.toString());
            req.setFactory((CreationFactory)gmCreationContext);
            command.add(this.getHost().getCommand((Request)req));
            dropLocation = dropLocation.getTranslated(20, 20);
            ++n4;
        }
        return command.unwrap();
    }

    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("DROPELEMENT")) {
            return this.getDropTargetEditPart((ModelElementDropRequest)request);
        }
        return null;
    }

    public Command getCommand(Request request) {
        if (request.getType().equals("DROPELEMENT")) {
            return this.getDropCommand((ModelElementDropRequest)request);
        }
        return null;
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("DROPELEMENT") && this.highlight == null) {
            this.highlight = new RectangleFigure();
            this.highlight.setLineWidth(2);
            this.highlight.setForegroundColor(this.getHostFigure().getForegroundColor());
            this.highlight.setLineStyle(2);
            this.highlight.setBounds(this.getHostFigure().getBounds().getCopy().expand(0, 0));
            this.highlight.setFill(false);
            this.addFeedback((IFigure)this.highlight);
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (request.getType().equals("DROPELEMENT") && this.highlight != null) {
            this.removeFeedback((IFigure)this.highlight);
            this.highlight = null;
        }
        super.eraseTargetFeedback(request);
    }
}

