/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.pincontainer;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityAction;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IPin;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.GmPortContainer;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.PortConstraint;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public abstract class GmPinContainer
extends GmPortContainer {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmPinContainer(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public GmPinContainer() {
    }

    public abstract IActivityAction getRepresentedIElement();

    public void refreshFromObModel() {
        super.refreshFromObModel();
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            this.refreshPinsFromObModel();
        }
    }

    public void styleChanged(IStyle changedStyle) {
        super.styleChanged(changedStyle);
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            this.refreshPinsFromObModel();
        }
    }

    public void styleChanged(StyleKey property, Object newValue) {
        super.styleChanged(property, newValue);
        if (property.equals((Object)this.getStyleKeyStrict(MetaKey.AUTOSHOWPINS)) && this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            this.refreshPinsFromObModel();
        }
    }

    private void refreshPinsFromObModel() {
        if (this.arePinsAutoDisplayed().booleanValue()) {
            GmNodeModel gmPin;
            IActivityAction node = this.getRepresentedIElement();
            for (IPin pin : node.getInput()) {
                if (this.getChild(new ObRef((IElement)pin)) != null) continue;
                gmPin = this.getDiagram().unmask((GmCompositeNode)this, (IElement)pin, (Object)PortConstraint.Border.West);
                gmPin.setRoleInComposition("Port");
            }
            for (IPin pin : node.getOutput()) {
                if (this.getChild(new ObRef((IElement)pin)) != null) continue;
                gmPin = this.getDiagram().unmask((GmCompositeNode)this, (IElement)pin, (Object)PortConstraint.Border.East);
                gmPin.setRoleInComposition("Port");
            }
        }
    }

    protected Boolean arePinsAutoDisplayed() {
        return (Boolean)this.getStyle().getProperty(this.getStyleKeyStrict(MetaKey.AUTOSHOWPINS));
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmPinContainer.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmPinContainer.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }

    public boolean isPort(GmNodeModel childNode) {
        return "Port".equals(childNode.getRoleInComposition());
    }
}

