/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.activity.elements.policies;

import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehaviorParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.diagram.editor.activity.elements.commands.CreateActivityParameterNodeCommand;
import com.modeliosoft.modelio.diagram.editor.activity.elements.commands.CreateCallBehaviorCommand;
import com.modeliosoft.modelio.diagram.editor.activity.elements.commands.CreateCallOperationCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class SmartDropEditPolicy
extends DefaultElementDropEditPolicy {
    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        if (!request.isSmart()) {
            return super.getDropTargetEditPart(request);
        }
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (!(droppedElement instanceof IOperation || droppedElement instanceof IBehavior || droppedElement instanceof IBehaviorParameter)) {
                return super.getDropTargetEditPart(request);
            }
            ++n2;
        }
        return this.getHost();
    }

    protected Command getSmartDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        if (request.isSmart()) {
            IElement[] iElementArray = request.getDroppedElements();
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement toUnmask = iElementArray[n2];
                if (toUnmask instanceof IOperation) {
                    command.add(this.getOperationDropCommand(dropLocation, (IOperation)toUnmask));
                } else if (toUnmask instanceof IBehavior) {
                    command.add(this.getBehaviorDropCommand(dropLocation, (IBehavior)toUnmask));
                } else if (toUnmask instanceof IBehaviorParameter) {
                    command.add(this.getBehaviorParameterDropCommand(dropLocation, (IBehaviorParameter)toUnmask));
                }
                ++n2;
            }
        }
        if (command.isEmpty()) {
            return null;
        }
        return command;
    }

    private Command getBehaviorParameterDropCommand(Point dropLocation, IBehaviorParameter toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        IElement owner = gmModel.getRelatedIElement();
        return new CreateActivityParameterNodeCommand(dropLocation, toUnmask, this.getHost(), owner);
    }

    private Command getOperationDropCommand(Point dropLocation, IOperation toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        IElement owner = gmModel.getRelatedIElement();
        return new CreateCallOperationCommand(dropLocation, toUnmask, this.getHost(), owner);
    }

    private Command getBehaviorDropCommand(Point dropLocation, IBehavior toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        IElement owner = gmModel.getRelatedIElement();
        return new CreateCallBehaviorCommand(dropLocation, toUnmask, this.getHost(), owner);
    }
}

