/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.mdac;

import com.modeliosoft.modelio.api.mc.IModelComponentContributor;
import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IParameterEditionModel;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.mdac.commands.IWorkbenchAction;
import com.modeliosoft.modelio.api.mdac.commands.WorkbenchActionLocation;
import com.modeliosoft.modelio.api.mdac.paramEdition.DefaultParametersEditionModel;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyPage;
import com.modeliosoft.modelio.api.mdac.script.IScriptService;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.module.IMdacConfiguration;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class AbstractJavaMdac
implements IMdac {
    private final Map<ActionLocation, List<IMdacAction>> actionsRegistry;
    private final IMdacConfiguration configuration;
    private ImageRegistry imageRegistry;
    private ScriptEngine jythonEngine = null;
    private final IModule mdacHandle;
    private final IModelingSession modelingSession;
    protected IParameterEditionModel parameterEditionModel = null;
    protected List<IMdacPropertyPage> propertyPages = new ArrayList<IMdacPropertyPage>();
    private IMdac.MdacState runtimeState = IMdac.MdacState.Loaded;
    private List<Bundle> docBundles = new ArrayList<Bundle>();

    public AbstractJavaMdac(IModelingSession iModelingSession, IModule iModule, IMdacConfiguration iMdacConfiguration) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractJavaMdac.this.imageRegistry = new ImageRegistry();
            }
        });
        this.modelingSession = iModelingSession;
        this.mdacHandle = iModule;
        this.configuration = iMdacConfiguration;
        this.actionsRegistry = new HashMap<ActionLocation, List<IMdacAction>>();
        this.actionsRegistry.put(ActionLocation.menu, new ArrayList());
        this.actionsRegistry.put(ActionLocation.toolbar, new ArrayList());
        this.actionsRegistry.put(ActionLocation.property, new ArrayList());
        this.actionsRegistry.put(ActionLocation.contextualpopup, new ArrayList());
        this.actionsRegistry.put(ActionLocation.diagramtoolbar, new ArrayList());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractJavaMdac abstractJavaMdac = (AbstractJavaMdac)object;
        return !(this.mdacHandle == null ? abstractJavaMdac.mdacHandle != null : !this.mdacHandle.equals(abstractJavaMdac.mdacHandle));
    }

    @Override
    public List<IMdacAction> getActions(ActionLocation actionLocation) {
        if (this.actionsRegistry.containsKey((Object)actionLocation)) {
            return this.actionsRegistry.get((Object)actionLocation);
        }
        return Collections.emptyList();
    }

    @Override
    public IMdacConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getDescription() {
        try {
            return this.getManifestBundle().getString("MdacDescription");
        }
        catch (MissingResourceException missingResourceException) {
            Modelio.getInstance().getLogService().warning((IMdac)this, missingResourceException.toString());
            return "";
        }
    }

    @Override
    public long getHid() {
        return this.mdacHandle.getHid();
    }

    @Override
    public Image getImage(IStereotype iStereotype, IMdac.ImageType imageType) {
        if (iStereotype != null) {
            ImageDescriptor imageDescriptor;
            String string = this.getImageKey(iStereotype, imageType);
            Image image = this.imageRegistry.get(string);
            if (image == null && (imageDescriptor = this.getImageDescriptor(iStereotype, imageType)) != null) {
                this.imageRegistry.put(string, imageDescriptor);
                image = this.imageRegistry.get(string);
            }
            return image;
        }
        return null;
    }

    @Override
    public ImageDescriptor getImageDescriptor(IStereotype iStereotype, IMdac.ImageType imageType) {
        if (!this.isStereotypeOwner(iStereotype)) {
            return null;
        }
        ImageDescriptor imageDescriptor = null;
        File file = this.getConfiguration().getModuleResourcesPath();
        String string = null;
        if (imageType == IMdac.ImageType.ICON) {
            string = iStereotype.getIconBrowser();
        } else if (imageType == IMdac.ImageType.DIAGRAM_ICON) {
            string = iStereotype.getIconBrowser();
        } else if (imageType == IMdac.ImageType.DIAGRAM_IMAGE) {
            string = iStereotype.getIcon();
        }
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            File file2 = new File(file, string);
            if (!file2.isFile() && string.startsWith(this.getName())) {
                string = string.substring(this.getName().length() + 1);
                file2 = new File(file, string);
            }
            if (file2.isFile()) {
                URL uRL = file2.toURI().toURL();
                imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
                if (imageDescriptor != ImageDescriptor.getMissingImageDescriptor()) {
                    return imageDescriptor;
                }
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Modelio.getInstance().getLogService().error((IMdac)this, malformedURLException.getMessage());
        }
        return imageDescriptor;
    }

    @Override
    public ScriptEngine getJythonEngine() {
        if (this.jythonEngine == null) {
            IScriptService iScriptService = Modelio.getInstance().getScriptService();
            ScriptEngineManager scriptEngineManager = iScriptService.getScriptEngineManager(this.getClass().getClassLoader());
            scriptEngineManager.put("SESSION", this.getModelingSession());
            scriptEngineManager.put("MODULE", this);
            scriptEngineManager.put("modelingSession", this.getModelingSession());
            scriptEngineManager.put("module", this);
            this.jythonEngine = scriptEngineManager.getEngineByName("jython");
            iScriptService.initJython(this.jythonEngine);
        }
        return this.jythonEngine;
    }

    @Override
    public String getLabel() {
        try {
            return this.getManifestBundle().getString("MdacLabel");
        }
        catch (MissingResourceException missingResourceException) {
            Modelio.getInstance().getLogService().error((IMdac)this, missingResourceException.getMessage());
            return this.getName();
        }
    }

    @Override
    public long getLid() {
        return this.mdacHandle.getLid();
    }

    @Override
    @Deprecated
    public Collection<IMdacAction> getMdacActions(ActionLocation actionLocation) {
        return this.getActions(actionLocation);
    }

    public String getMdacImage() {
        return "";
    }

    @Override
    public ImageDescriptor getMdacImageDescriptor() {
        String string = this.getMdacImage();
        if (string != null && !string.isEmpty()) {
            String string2 = this.getName() + "MainImageKey";
            ImageDescriptor imageDescriptor = this.imageRegistry.getDescriptor(string2);
            if (imageDescriptor == null) {
                File file = this.getConfiguration().getModuleResourcesPath();
                try {
                    File file2 = new File(file, string);
                    if (file2.isFile()) {
                        URL uRL = file2.toURI().toURL();
                        ImageDescriptor imageDescriptor2 = ImageDescriptor.createFromURL((URL)uRL);
                        this.imageRegistry.put(string2, imageDescriptor2);
                        imageDescriptor = this.imageRegistry.getDescriptor(string2);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Modelio.getInstance().getLogService().error((IMdac)this, malformedURLException.getMessage());
                }
            }
            return imageDescriptor;
        }
        return null;
    }

    @Override
    public IModule getModel() {
        return this.mdacHandle;
    }

    @Override
    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    @Override
    public String getName() {
        return this.mdacHandle.getName();
    }

    @Override
    public IParameterEditionModel getParametersEditionModel() {
        if (this.parameterEditionModel == null) {
            this.parameterEditionModel = new DefaultParametersEditionModel(this);
        }
        return this.parameterEditionModel;
    }

    @Override
    public Collection<IMdacPropertyPage> getPropertyPages() {
        return this.propertyPages;
    }

    @Override
    public IModelComponentContributor getModelComponentContributor() {
        return null;
    }

    @Override
    public Version getRequiredModelioVersion() {
        return new Version(this.mdacHandle.getModelioRequiredVersion());
    }

    @Override
    public Version getVersion() {
        try {
            return new Version(this.mdacHandle.getVersion());
        }
        catch (Exception exception) {
            return new Version("0.0.00.7008");
        }
    }

    @Override
    @Deprecated
    public Collection<IWorkbenchAction> getWorkbenchActions(WorkbenchActionLocation workbenchActionLocation) {
        return new ArrayList<IWorkbenchAction>();
    }

    @Override
    public void init() {
        for (File file : this.configuration.getDocpath()) {
            try {
                BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
                Bundle bundle = bundleContext.installBundle("reference:file:/" + file);
                bundle.start(1);
                this.docBundles.add(bundle);
            }
            catch (Exception exception) {
                if (exception.getClass().getSimpleName().equals("DuplicateBundleException")) continue;
                Modelio.getInstance().getLogService().warning((IMdac)this, exception.getMessage());
            }
        }
        if (!this.docBundles.isEmpty()) {
            HelpPlugin.getTocManager().clearCache();
        }
    }

    @Override
    public void registerAction(ActionLocation actionLocation, IMdacAction iMdacAction) {
        switch (actionLocation) {
            case Contextual: 
            case ExplorerElementCreation: 
            case ExplorerMdacElementCreation: 
            case elementcreationpopup: {
                this.registerAction(ActionLocation.contextualpopup, iMdacAction);
                break;
            }
            case ExplorerDiagramCreation: 
            case ExplorerMdacDiagramCreation: {
                this.registerAction(ActionLocation.toolbar, iMdacAction);
                break;
            }
            case PropertyPage: {
                this.registerAction(ActionLocation.property, iMdacAction);
                break;
            }
            default: {
                List<IMdacAction> list = this.actionsRegistry.get((Object)actionLocation);
                list.add(iMdacAction);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" '");
        stringBuilder.append(this.getName());
        stringBuilder.append("' {");
        stringBuilder.append(this.mdacHandle.getIdentifier());
        stringBuilder.append("} module");
        return stringBuilder.toString();
    }

    private String getImageKey(IStereotype iStereotype, IMdac.ImageType imageType) {
        return "mdac." + iStereotype.getName() + "." + imageType.name();
    }

    private ResourceBundle getManifestBundle() throws MissingResourceException {
        File file = this.getConfiguration().getModuleResourcesPath();
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            return ResourceBundle.getBundle("module", Locale.getDefault(), uRLClassLoader);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MissingResourceException(malformedURLException.getLocalizedMessage(), "module", "");
        }
        catch (MissingResourceException missingResourceException) {
            MissingResourceException missingResourceException2 = new MissingResourceException(missingResourceException.getLocalizedMessage() + " in '" + file.getPath() + "'", missingResourceException.getClassName(), missingResourceException.getKey());
            missingResourceException2.initCause(missingResourceException);
            Modelio.getInstance().getLogService().error((IMdac)this, missingResourceException.getMessage());
            throw missingResourceException2;
        }
    }

    private boolean isStereotypeOwner(IStereotype iStereotype) {
        IProfile iProfile = iStereotype.getOwner();
        if (iProfile != null) {
            IModule iModule = iProfile.getOwnerModule();
            if (iModule != null) {
                return iModule.equals(this.mdacHandle);
            }
            IModelTree iModelTree = iProfile.getOwner();
            return this.mdacHandle.equals(iModelTree);
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mdacHandle == null ? 0 : this.mdacHandle.hashCode());
        return n;
    }

    @Override
    public IMdac.MdacState getState() {
        return this.runtimeState;
    }

    public void setState(IMdac.MdacState mdacState) {
        this.runtimeState = mdacState;
    }

    @Override
    public void uninit() {
        if (!this.docBundles.isEmpty()) {
            for (Bundle bundle : this.docBundles) {
                try {
                    bundle.stop();
                    bundle.uninstall();
                }
                catch (BundleException bundleException) {
                    Modelio.getInstance().getLogService().warning((IMdac)this, bundleException.getMessage());
                }
            }
            this.docBundles.clear();
            HelpPlugin.getTocManager().clearCache();
        }
    }
}

