/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.mdac;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IMdacPropertyView;
import com.modeliosoft.modelio.api.mdac.IMdacSession;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.mdac.contrib.MdacActionDelegatingHandler;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyPage;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.modelio.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class DefaultMdacSession
implements IMdacSession {
    protected final IMdac mdac;
    private final Map<String, IHandlerActivation> handlerActivationTable = new HashMap<String, IHandlerActivation>();
    private PerspectiveAdapter perspectiveListener;

    public DefaultMdacSession(IMdac iMdac) {
        this.mdac = iMdac;
    }

    public static boolean install(String string, String string2) throws MdacException {
        return true;
    }

    @Override
    public boolean select() throws MdacException {
        return true;
    }

    @Override
    public boolean start() throws MdacException {
        this.addWorkbenchActions();
        this.showModulePropertyViews();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    DefaultMdacSession.this.perspectiveListener = new PerspectiveAdapter(){

                        public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                            super.perspectiveActivated(iWorkbenchPage, iPerspectiveDescriptor);
                            DefaultMdacSession.this.showModulePropertyViews();
                        }

                        public void perspectivePreDeactivate(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                            super.perspectivePreDeactivate(iWorkbenchPage, iPerspectiveDescriptor);
                            DefaultMdacSession.this.hideMdacPropertyViews();
                        }
                    };
                    iWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)DefaultMdacSession.this.perspectiveListener);
                }
            }
        });
        return true;
    }

    @Override
    public void stop() throws MdacException {
        this.hideMdacPropertyViews();
        Display.getDefault().syncExec((Runnable)new ContextualPopupActionsRemover(this.mdac, this.handlerActivationTable));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    iWorkbenchWindow.removePerspectiveListener((IPerspectiveListener)DefaultMdacSession.this.perspectiveListener);
                }
            }
        });
    }

    @Override
    public void unselect() throws MdacException {
    }

    @Override
    public void upgrade(Version version, Map<String, String> map) throws MdacException {
        this.mdac.getConfiguration().updateFrom(map);
    }

    private void showModulePropertyViews() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IMdac iMdac = DefaultMdacSession.this.mdac;
                Collection<IMdacPropertyPage> collection = iMdac.getPropertyPages();
                for (IMdacPropertyPage iMdacPropertyPage : collection) {
                    try {
                        IViewPart iViewPart = iWorkbenchWindow.getActivePage().showView("com.modeliosoft.modelio.edition.MdacPropertyViewID", iMdacPropertyPage.getName(), 3);
                        if (!(iViewPart instanceof IMdacPropertyView)) continue;
                        IMdacPropertyView iMdacPropertyView = (IMdacPropertyView)iViewPart;
                        IModelingSession iModelingSession = Modelio.getInstance().getModelingSession();
                        if (iModelingSession == null) continue;
                        iMdacPropertyView.start(iModelingSession, iMdacPropertyPage);
                        iMdacPropertyView.setPartName(iMdacPropertyPage.getLabel());
                        iMdacPropertyView.setPartImage(iMdacPropertyPage.getBitmap());
                    }
                    catch (PartInitException partInitException) {
                        Modelio.getInstance().getLogService().error(iMdac, partInitException.getMessage());
                    }
                }
            }
        });
    }

    private void addWorkbenchActions() {
        Display.getDefault().syncExec((Runnable)new ContextualPopupActionsAdder(this.mdac, this.handlerActivationTable));
    }

    private void hideMdacPropertyViews() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IMdac iMdac = DefaultMdacSession.this.mdac;
                Collection<IMdacPropertyPage> collection = iMdac.getPropertyPages();
                for (IMdacPropertyPage iMdacPropertyPage : collection) {
                    String string = iMdacPropertyPage.getName();
                    IViewReference[] iViewReferenceArray = iWorkbenchWindow.getActivePage().getViewReferences();
                    IViewPart iViewPart = null;
                    for (IViewReference iViewReference : iViewReferenceArray) {
                        if (!"com.modeliosoft.modelio.edition.MdacPropertyViewID".equals(iViewReference.getId()) || !string.equals(iViewReference.getSecondaryId())) continue;
                        iViewPart = iViewReference.getView(false);
                    }
                    if (!(iViewPart instanceof IMdacPropertyView)) continue;
                    IMdacPropertyView iMdacPropertyView = (IMdacPropertyView)iViewPart;
                    iMdacPropertyView.setInput(null);
                    iMdacPropertyView.stop();
                    iWorkbenchWindow.getActivePage().hideView((IViewPart)iMdacPropertyView);
                }
            }
        });
    }

    private static class ContextualPopupActionsRemover
    implements Runnable {
        private final IMdac javaMdac;
        private final Map<String, IHandlerActivation> handlerActivationTable;

        public ContextualPopupActionsRemover(IMdac iMdac, Map<String, IHandlerActivation> map) {
            this.handlerActivationTable = map;
            this.javaMdac = iMdac;
        }

        @Override
        public void run() {
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ICommandService iCommandService = (ICommandService)iWorkbenchWindow.getService(ICommandService.class);
            IHandlerService iHandlerService = (IHandlerService)iWorkbenchWindow.getService(IHandlerService.class);
            ArrayList<IMdacAction> arrayList = new ArrayList<IMdacAction>();
            arrayList.addAll(this.javaMdac.getActions(ActionLocation.contextualpopup));
            arrayList.addAll(this.javaMdac.getActions(ActionLocation.toolbar));
            for (IMdacAction iMdacAction : arrayList) {
                String string = iMdacAction.getMdac().getName() + "." + iMdacAction.getName();
                Command command = iCommandService.getCommand(string);
                if (!command.isDefined()) continue;
                IHandlerActivation iHandlerActivation = this.handlerActivationTable.get(string);
                if (iHandlerActivation != null) {
                    iHandlerService.deactivateHandler(iHandlerActivation);
                    this.handlerActivationTable.remove(string);
                }
                command.undefine();
            }
        }
    }

    private static class ContextualPopupActionsAdder
    implements Runnable {
        private final IMdac javaMdac;
        private final Map<String, IHandlerActivation> handlerActivationTable;

        public ContextualPopupActionsAdder(IMdac iMdac, Map<String, IHandlerActivation> map) {
            this.handlerActivationTable = map;
            this.javaMdac = iMdac;
        }

        @Override
        public void run() {
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ICommandService iCommandService = (ICommandService)iWorkbenchWindow.getService(ICommandService.class);
            IHandlerService iHandlerService = (IHandlerService)iWorkbenchWindow.getService(IHandlerService.class);
            ArrayList<IMdacAction> arrayList = new ArrayList<IMdacAction>();
            arrayList.addAll(this.javaMdac.getActions(ActionLocation.contextualpopup));
            arrayList.addAll(this.javaMdac.getActions(ActionLocation.toolbar));
            for (IMdacAction iMdacAction : arrayList) {
                String string = iMdacAction.getMdac().getName() + "." + iMdacAction.getName();
                Command command = iCommandService.getCommand(string);
                if (command.isDefined()) continue;
                Category category = iCommandService.getCategory("mdac");
                command.define(iMdacAction.getLabel(), iMdacAction.getLabel(), category);
                IHandlerActivation iHandlerActivation = iHandlerService.activateHandler(string, (IHandler)MdacActionDelegatingHandler.create(iMdacAction));
                this.handlerActivationTable.put(string, iHandlerActivation);
            }
        }
    }
}

