/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.mdac.commands;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.mdac.commands.IMdacContextualCommand;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class DefaultMdacAction
implements IMdacAction {
    private String bitmapPath;
    private boolean editTheModel;
    private String label;
    private String name;
    private boolean needReadWriteObject;
    private String tooltip;
    private List<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
    private IMdacContextualCommand command;
    private IMdac mdac;
    private List<IStereotype> allowedStereotypes = new ArrayList<IStereotype>();
    private List<String> slotImagePaths = new ArrayList<String>();
    private List<String> slots = new ArrayList<String>();

    public DefaultMdacAction(IMdac iMdac, String string, String string2, String string3, String string4, boolean bl, boolean bl2, IMdacContextualCommand iMdacContextualCommand) {
        this(iMdac, string, string2, string3, string4, "", "", bl, bl2, iMdacContextualCommand);
    }

    public DefaultMdacAction(IMdac iMdac, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, IMdacContextualCommand iMdacContextualCommand) {
        this.mdac = iMdac;
        this.name = string;
        this.label = string2;
        this.tooltip = string3;
        this.bitmapPath = string4;
        if (!string5.isEmpty()) {
            for (String string7 : string5.split("\\|")) {
                this.slots.add(string7);
            }
            for (String string7 : string6.split("\\|")) {
                this.slotImagePaths.add(string7);
            }
        }
        this.needReadWriteObject = bl;
        this.editTheModel = bl2;
        this.command = iMdacContextualCommand;
        this.allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
    }

    @Deprecated
    public DefaultMdacAction(IMdac iMdac, int n, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, IMdacContextualCommand iMdacContextualCommand) {
        this(iMdac, string, string2, string3, string4, string5, "", bl, bl2, iMdacContextualCommand);
    }

    @Override
    public final boolean accept(IElement[] iElementArray) {
        for (int i = 0; i < iElementArray.length; ++i) {
            boolean bl = false;
            boolean bl2 = false;
            for (Class<? extends IElement> clazz : this.allowedMetaclasses) {
                if (!clazz.isAssignableFrom(iElementArray[i].getClass())) continue;
                bl2 = true;
                break;
            }
            if (this.allowedStereotypes.size() > 0) {
                for (IStereotype iStereotype : this.allowedStereotypes) {
                    IModelElement iModelElement;
                    IElement iElement = iElementArray[i];
                    if (!(iElement instanceof IModelElement) || !(iModelElement = (IModelElement)iElement).isStereotyped(iStereotype.getName())) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
            if (bl2 && bl) continue;
            return false;
        }
        return this.command.accept((ObList<IElement>)new ObList(iElementArray), this.mdac);
    }

    @Override
    public void addAllowedMetaclass(Class<? extends IElement> clazz) {
        this.allowedMetaclasses.add(clazz);
    }

    @Override
    public void addAllowedStereotype(IStereotype iStereotype) {
        this.allowedStereotypes.add(iStereotype);
    }

    @Override
    public ImageDescriptor getBitmap() {
        File file = new File(this.getImagePath());
        if (!(file.exists() && file.isFile() && file.isAbsolute())) {
            File file2 = this.mdac.getConfiguration().getModuleResourcesPath();
            file = new File(file2, this.getImagePath());
        }
        if (file.exists() && file.isFile()) {
            try {
                return ImageDescriptor.createFromURL((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Modelio.getInstance().getLogService().error(this.mdac, malformedURLException);
            }
        }
        return null;
    }

    @Override
    public IMdacContextualCommand getCommand() {
        return this.command;
    }

    @Override
    @Deprecated
    public String getImagePath() {
        return this.bitmapPath;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public IMdac getMdac() {
        return this.mdac;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImageDescriptor getSlotImage(int n) {
        if (n < this.slotImagePaths.size()) {
            String string = this.slotImagePaths.get(n);
            File file = new File(string);
            if (!(file.exists() && file.isFile() && file.isAbsolute())) {
                File file2 = this.mdac.getConfiguration().getModuleResourcesPath();
                file = new File(file2, string);
            }
            if (file.exists() && file.isFile()) {
                try {
                    return ImageDescriptor.createFromURL((URL)file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    Modelio.getInstance().getLogService().error(this.mdac, malformedURLException);
                }
            }
        }
        return null;
    }

    @Override
    public List<String> getSlots() {
        return this.slots;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public final boolean isActiveFor(IElement[] iElementArray, boolean bl) {
        if (this.editTheModel && bl) {
            return false;
        }
        if (this.needReadWriteObject) {
            for (IElement iElement : iElementArray) {
                if (iElement.getElementStatus().isModifiable()) continue;
                return false;
            }
        }
        return this.command.isActiveFor((ObList<IElement>)new ObList(iElementArray), this.mdac);
    }

    @Override
    public boolean needReadWriteObject() {
        return this.needReadWriteObject;
    }
}

