/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.model;

import com.modeliosoft.modelio.api.Messages;
import com.modeliosoft.modelio.api.model.InvalidPathException;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.utils.IObListFilter;
import com.modeliosoft.modelio.api.utils.NameFilter;
import com.modeliosoft.modelio.api.utils.ObList;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class UMLPath {
    private List<INameSpace> hierarchy = new ArrayList<INameSpace>();
    private boolean valid = false;

    public UMLPath(INameSpace iNameSpace, String string) {
        this(iNameSpace, string, ".");
    }

    public UMLPath(INameSpace iNameSpace, String string, String string2) {
        this.valid = false;
        INameSpace iNameSpace2 = iNameSpace;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            NameFilter nameFilter = new NameFilter(string3);
            ObList obList = iNameSpace2.getOwnedElement().select((IObListFilter)nameFilter);
            if (obList.size() != 1) {
                this.hierarchy.clear();
                return;
            }
            if (obList.get(0) instanceof INameSpace) {
                this.hierarchy.add((INameSpace)obList.get(0));
            }
            iNameSpace2 = this.hierarchy.get(this.hierarchy.size() - 1);
        }
        this.valid = true;
    }

    public UMLPath(INameSpace iNameSpace) {
        this.valid = true;
        this.hierarchy.add(iNameSpace);
        for (IElement iElement = iNameSpace.getCompositionOwner(); iElement != null && iElement.getCompositionOwner() != null; iElement = iElement.getCompositionOwner()) {
            if (!(iElement instanceof INameSpace)) {
                this.valid = false;
                this.hierarchy.clear();
                return;
            }
            this.hierarchy.add(0, (INameSpace)iElement);
        }
    }

    public List<INameSpace> getHierarchy() throws InvalidPathException {
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage("keyUmlPath.Invalid", new String[0]));
        }
        return this.hierarchy;
    }

    public INameSpace getLastElement() throws InvalidPathException, IllegalArgumentException {
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage("keyUmlPath.Invalid", new String[0]));
        }
        if (this.hierarchy.size() == 0) {
            throw new IllegalArgumentException(Messages.getMessage("keyUmlPath.Empty", new String[0]));
        }
        return this.hierarchy.get(this.hierarchy.size() - 1);
    }

    public UMLPath getParentPath() throws InvalidPathException, IllegalArgumentException {
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage("keyUmlPath.Invalid", new String[0]));
        }
        if (this.hierarchy.size() == 0) {
            throw new IllegalArgumentException("the parent path cannot be determined from an empty hierarchy");
        }
        ArrayList<INameSpace> arrayList = new ArrayList<INameSpace>(this.hierarchy);
        arrayList.remove(arrayList.size() - 1);
        return new UMLPath(arrayList);
    }

    public String getPath(String string) throws InvalidPathException {
        String string2 = "";
        if (!this.valid) {
            throw new InvalidPathException(Messages.getMessage("keyUmlPath.Invalid", new String[0]));
        }
        for (int i = 0; i < this.hierarchy.size(); ++i) {
            if (i != 0) {
                string2 = string2.concat(string);
            }
            string2 = string2.concat(this.hierarchy.get(i).getName());
        }
        return string2;
    }

    public boolean isValid() {
        return this.valid;
    }

    private UMLPath(List<INameSpace> list) {
        this.hierarchy = list;
        this.valid = true;
    }
}

